execute 'Install EPEL' do
  command 'amazon-linux-extras install epel'
end

package 'syslog-ng'
package 'amazon-cloudwatch-agent'
package 'logrotate'

cookbook_file 'Copy Syslog-ng config' do
  group 'root'
  mode '0644'
  owner 'root'
  path '/etc/syslog-ng/syslog-ng.conf'
  source 'syslog-ng.conf'
end

cookbook_file 'Copy Cloudwatch config' do
  group 'root'
  mode '0644'
  owner 'root'
  path '/opt/aws/amazon-cloudwatch-agent/etc/amazon-cloudwatch-agent.json'
  source 'amazon-cloudwatch-agent.json'
end

cookbook_file 'Copy logrotate config' do
  group 'root'
  mode '0644'
  owner 'root'
  path '/etc/logrotate.d/syslog-ext'
  source 'syslog-ext'
end

service 'Enable/Start/Restart syslog-ng' do
  service_name 'syslog-ng'
  action [ :enable, :start, :restart]
end

service 'Enable/Start/Restart amazon-cloudwatch-agent' do
  service_name 'amazon-cloudwatch-agent'
  action [ :enable, :start, :restart]
end
