package 'sssd'
package 'sssd-ldap'
package 'ldap-utils'

cookbook_file "Copy SSSD config" do  
  group "root"
  mode "0600"
  owner "root"
  path "/etc/sssd/sssd.conf"
  source "sssd.conf"
end

cookbook_file "Copy SSHD_config" do
  group "root"
  mode "0644"
  owner "root"
  path "/etc/ssh/sshd_config"
  source "sshd_config"
end

cookbook_file "copy LDAP CA Certs" do
  group "root"
  mode "0644"
  owner "root"
  path "/etc/ssl/certs/ca-certificates.crt"
  source "ca-certificates.crt"
end

cookbook_file "Copy sudoers file" do
  group "root"
  mode "0440"
  owner "root"
  path "/etc/sudoers"
  source "sudoers"
end

execute'Enable SSSD Auth' do
  command 'pam-auth-update --enable mkhomedir'
end

service 'Enable & Start/Restart sssd' do
  service_name 'sssd'
  action [ :enable, :start, :restart]
end

service 'restart sshd' do
  service_name 'sshd'
  action :restart
end
