#!/bin/bash

for var in $@; do
    if [[ $var == "-v" ]]; then verbose=true; fi
    if [[ $var == "-z" ]]; then ztp=true; fi
done

#remove old lighthouse
echo -n "Removing old lighthouse details............"
config -d config.ssh.servers.server1.address -d config.ssh.servers.total -d config.wizard.callhome.server1.plaintext_password
echo "DONE"

#set root password
echo -n "Setting Root Password.............."
config -s config.users.user1.password='$1$s4lt$dT67kjeVvp1xHSjjA3zwN0'
echo "DONE"

# set SysLog/PortLogs
echo -n "Configuring Syslog/PortLogs..............."
config -s config.syslog.server.hostname=syslog-relay.dco.xarth.tv
config -s config.syslog.server.port=514
config -s config.eventlog.server.address=syslog-relay.dco.xarth.tv -s config.eventlog.server.logfacility=local2 -s config.eventlog.server.logpriority=info -s config.eventlog.server.type=syslog
echo "DONE"

# set NTP

echo -n "Configuring NTP.................."
config -s config.system.timezone=Etc/GMT
config -s config.ntp.enabled=on
config -s config.ntp.servers.server1.address=ntp1.internal.justin.tv
config -s config.ntp.servers.server1.key_id=0
config -s config.ntp.servers.server2.address=ntp2.internal.justin.tv
#53.223.240.120
config -s config.ntp.servers.server2.key_id=0
config -s config.ntp.servers.total=2
echo "DONE"

# set SNMP

#echo -n "Configuring SNMP................."
#config -s config.services.snmp.enabled=on
#config -s config.services.snmp.protocol=UDP
#config -s config.services.snmp.roauthprotocol=SHA
#config -s config.services.snmp.rocommunity=jtv
#config -s config.services.snmp.roprivprotocol=DES
#config -s config.services.snmp.roseclevel=noauth
#config -s config.services.snmp.rwcommunity=N8ucDURGJu5z
#echo "DONE"

# set HTTPS only

echo -n "Configuring HTTPS only..........."
config -s config.services.http.enabled=off
echo "DONE"

# set LDAP auth (Depreitiated)
#echo -n "Configuring LDAP authentication.."
#config -s config.auth.ldap.basedn=dc=justin,dc=tv
#config -s config.auth.ldap.ignore_ssl_errors=on -s config.auth.ldap.loginattr=uid
#config -s config.auth.ldap.memberattr=memberOf -s config.auth.ldap.protocol=ldaps_preferred
#config -s config.auth.ldap.server=ldap-vip.internal.justin.tv -s config.auth.type=LDAPLocal
#config -s config.auth.useremotegroups=on
#config -s config.auth.ldap.usersdn=cn=infra,ou=Groups,dc=justin,dc=tv
#config -s config.auth.ldap.admindn=cn=team-dcops-sudo,ou=Groups,dc=justin,dc=tv
# config -r auth >/dev/null 2>&1 #Removed in favor of config-a command run later in script

#remove LDAP Auth
echo "Removing old LDAP Configs"
config -d config.auth.ldap
echo "DONE"

#Set RADIUS Auth
echo "setting RADIUS Configs"
config -s config.auth.radius.auth_server=authproxy.dco.xarth.tv -s config.auth.radius.password=VgKkMb3UK2Dxm6PpW7LiXzNi -s config.auth.useremotegroups=on -s config.auth.type=RADIUSLocal
echo "DONE"

# set key auth only for ssh
# removed in favor of LDAP auth, SSH Key as backup if LDAP is unreachable
# in theory, this would have been overwritten via config -a

#echo -n "Setting Key Only SSH............."
#sed -i "s/#PasswordAuthentication yes/PasswordAuthentication no/g" /etc/config/sshd_config
#sed -i "s/#ChallengeResponseAuthentication yes/ChallengeResponseAuthentication no/g" /etc/config/sshd_config
#echo "DONE"

# apply configuration
if [[ $ztp == true ]]; then
    echo "done"
elif [[ $verbose == true ]]; then
    config -a
else
    echo -n "Applying opengear config........."
    config -a >/dev/null 2>&1
    echo "DONE"
fi
