#!/bin/bash
# Arguments...
#    -v         : verbose mode
#    --audit    : audits users based on mast user list, checking for unexpected users (not yet setup)

for var in $@; do
    if [[ $var == "-v" ]]; then verbose=true; fi
    if [[ $var == "--audit" ]]; then audit=true; fi
    if [[ $var == "-z" ]]; then ztp=true;fi
done

# setup user groups

if [[ $verbose != true ]]; then echo -n "Updating User Groups............."; fi
config -s config.groups.total=14
config -s config.groups.group12.name=dcops
config -s config.groups.group13.name=neteng
config -s config.groups.group14.name=video
config -s config.groups.group12.description=Datacenter Operations Team
config -s config.groups.group13.description=Network Engineering Team
config -s config.groups.group14.description=Video Team
if [[ $verbose != true ]]; then echo "DONE"; fi

# give dcops and neteng access to all ports

portCounterRaw=1
if [[ $verbose != true ]]; then echo -n "Updating Port Permissions........"; fi
while [ $portCounterRaw -le 48 ]; do
    if [[ $verbose == true ]]; then
        echo "Update group permissions for port $portCounterRaw"
    fi
    config -s config.groups.group12.port${portCounterRaw}=on -s config.groups.group13.port${portCounterRaw}=on -s config.groups.group14.port${portCounterRaw}=on
    config -s config.ports.port${portCounterRaw}.ssh=on
    let portCounterRaw=portCounterRaw+1
done
if [[ $verbose != true ]]; then echo "DONE"; fi

# save config before adding/updating/removing users

if [[ $ztp == true ]]; then
    echo "DONE"
elif [[ $verbose == true ]]; then
    config -a
else
    echo -n "Applying opengear config........."
    config -a >/dev/null 2>&1
    echo "DONE"
fi

