#!/bin/bash

for var in $@; do
    if [[ $var == "-z" ]]; then ztp=true; fi
done

# Download Scripts from FTP

echo
echo "============================================="
echo "= Downloading Twitch Scripts ================"
echo "============================================="
echo
#New TFTP download from DCOps01 in AWS EC2
echo twitch_opengear_main.sh
curl ftp://odin.dco.xarth.tv/scripts/twitch_opengear_main.sh -o /etc/config/twitch_opengear_main.sh
echo twitch_opengear_general.sh
curl ftp://odin.dco.xarth.tv/scripts/twitch_opengear_general.sh -o /etc/config/twitch_opengear_general.sh
#echo twitch_opengear_userUpdate.sh
#curl ftp://odin.dco.xarth.tv/scripts/twitch_opengear_userUpdate.sh -o /etc/config/twitch_opengear_userUpdate.sh
echo twitch_opengear_portUpdate.sh
curl ftp://odin.dco.xarth.tv/scripts/twitch_opengear_portUpdate.sh -o /etc/config/twitch_opengear_portUpdate.sh
#echo twitch_opengear_groupUpdate.sh
#curl ftp://odin.dco.xarth.tv/scripts/twitch_opengear_groupUpdate.sh -o /etc/config/twitch_opengear_groupUpdate.sh
#echo twitch_opengear_users
#curl ftp://odin.dco.xarth.tv/scripts/twitch_opengear_users -o /etc/config/twitch_opengear_users
echo DONE


# Download device specific values from FTP and check

ipAddress=`ifconfig eth0 | grep -Eo 'inet (addr:)?([0-9]*\.){3}[0-9]*' | grep -Eo '([0-9]*\.){3}[0-9]*' | grep -v '127.0.0.1'`
echo
echo "============================================="
echo "= Found IP address: $ipAddress ============"
echo "= Downloading info file for above IP ========"
echo "============================================="
echo
echo downloading twitch_$ipAddress
curl ftp://odin.dco.xarth.tv/config_info_sheet/twitch_$ipAddress -o /etc/config/twitch_$ipAddress
#wget -P /etc/config/ ftp://01.usw2.dco.xarth.tv/data/deployment/config_info_sheet/twitch_$ipAddress
while read -r line || [[ -n "$line" ]]; do
    recordType=$(echo $line | cut -d ':' -f 1)
    #group=$(echo $line | cut -d ' ' -f 2 | cut -d ' ' -f 2-)
    #key=$(echo $line | cut -d ' ' -f 3-)
    case $recordType in
        ip)
            if [[ $ipAddress == $(echo $line | cut -d ':' -f 2-) ]]; then
                echo "IP Address Match"
            else
                echo "ALERT, Downloaded file does not match Interface IP address of machine!"
                exit
            fi
            ;;
        gw)
            gwAddress=$(netstat -rn  | grep UG | awk '{print $2}')
            if [[ $gwAddress == $(echo $line | cut -d ':' -f 2-) ]]; then
                echo "Gateway Address Match"
            else
                echo "ALERT, Downloaded file does not match Gateway IP address of machine!"
                exit
            fi
            ;;
    esac
done < /etc/config/twitch_$ipAddress

# Force static IP addressing
# Still needed

# Run general configuration

echo
echo "============================================="
echo "= Confirming General Settings ==============="
echo "============================================="
echo
if [[ $ztp == true ]]; then 
/bin/bash /etc/config/twitch_opengear_general.sh -z
else
/bin/bash /etc/config/twitch_opengear_general.sh
fi


# Run device specific settings

echo
echo "============================================="
echo "= Applying Device Specific Settings ========="
echo "============================================="
echo
if [[ $ztp == true ]]; then
/bin/bash /etc/config/twitch_opengear_portUpdate.sh -z
else
/bin/bash /etc/config/twitch_opengear_portUpdate.sh
fi

# Configure user groups

echo
echo "============================================="
echo "= Setting up user groups ===================="
echo "============================================="
echo
echo "Skipped(depretiated)"
#if [[ $ztp == true ]]; then
#/bin/bash /etc/config/twitch_opengear_groupUpdate.sh -z
#else
#/bin/bash /etc/config/twitch_opengear_groupUpdate.sh
#fi

# Update users

echo
echo "============================================="
echo "= Updating users ============================"
echo "============================================="
echo
echo "Skipped(depretiated)"
#if [[ $ztp == true ]]; then
#/bin/bash /etc/config/twitch_opengear_userUpdate.sh -z
#else
#/bin/bash /etc/config/twitch_opengear_userUpdate.sh
#fi

# Update users
#echo
#echo "============================================="
#echo "= Connecting to lighthouse =================="
#echo "============================================="
#echo
#lhvpn-callhome -a lighthouse.usw2.dco.xarth.tv -p 8443 -s zAGEnk3q6ZCf7kH9 -m Script
echo "DONE"

#echo
#echo "============================================="
#echo "= Connecting to lighthouse 4================="
#echo "============================================="
#echo
#/bin/bash /etc/config/twitch_opengear_cms.sh
#echo -n "DONE"

# Force initial backup (final step)

#backup will be managed by lighthoue

#echo
#echo "============================================="
#echo "= Force Backup - Final step ================="
#echo "============================================="
#echo
#if [[ $ztp != true ]]; then
#/bin/bash /etc/config/twitch_opengear_backup.sh
#fi
