#!/bin/bash
for var in $@; do
    if [[ $var == "-z" ]]; then ztp=true; fi
done


echo
echo "============================================="
echo "= Applying Device Specific Settings ========="
echo "============================================="
echo

ipAddress=`ifconfig eth0 | grep -Eo 'inet (addr:)?([0-9]*\.){3}[0-9]*' | grep -Eo '([0-9]*\.){3}[0-9]*' | grep -v '127.0.0.1'`

while read -r line || [[ -n "$line" ]]; do
    recordType=$(echo $line | cut -d ':' -f 1)
    case $recordType in
        name)
            deviceName=$(echo $line | cut -d ':' -f 2-)
            echo "Setting name to $deviceName"
            config -s config.system.name=$deviceName
            echo "Creating temp hosts file"
            echo "$ipAddress $deviceName" > /etc/config/twitch_hosts
            ;;
        desc)
            deviceDesc=$(echo $line | cut -d ':' -f 2-)
            echo "setting system description to $deviceDesc"
            config -s config.system.location="$deviceDesc"
            ;;
        serial)
            portNumber=$(echo $line | cut -d ':' -f 2)
            portIPAddress=$(echo $ipAddress | cut -d '.' -f 1-3)"."$(($(echo $ipAddress | cut -d '.' -f 4) + $portNumber))
            #portIPAddress=$(echo $line | cut -d ':' -f 3)
            portState=$(echo $line | cut -d ':' -f 4)
            portBaud=$(echo $line | cut -d ':' -f 5)
            portBits=$(echo $line | cut -d ':' -f 6)
            portParity=$(echo $line | cut -d ':' -f 7)
            portStopBits=$(echo $line | cut -d ':' -f 8)
            portLabel=$(echo $line | cut -d ':' -f 9)
            config -s config.ports.port${portNumber}.interfaces.wan=$portIPAddress/24\
             -s config.ports.port${portNumber}.ssh=$portState\
             -s config.ports.port${portNumber}.speed=$portBaud\
             -s config.ports.port${portNumber}.charsize=$portBits\
             -s config.ports.port${portNumber}.parity=$portParity\
             -s config.ports.port${portNumber}.stop=$portStopBits\
             -s config.ports.port${portNumber}.flowcontrol=None\
             -s config.ports.port${portNumber}.mode=portmanager\
             -s config.ports.port${portNumber}.loglevel=2\
             -s config.ports.port${portNumber}.pinout=X2\
             -s config.ports.port${portNumber}.protocol=RS232\
             -s config.ports.port${portNumber}.syslog.facility=Default\
             -s config.ports.port${portNumber}.syslog.priority=Default\
             -s config.ports.port${portNumber}.terminal=vt220
            if [[ $portLabel ]]; then 
                config -s config.ports.port${portNumber}.label=$portLabel
                echo "$portIPAddress $portLabel" >> /etc/config/twitch_hosts
                echo "Configuring serial port s$portNumber with label $portLabel"
            else
                config -s config.ports.port${portNumber}.label=s$portNumber
                echo "$portIPAddress s$portNumber" >> /etc/config/twitch_hosts
                echo "Configuring serial port s$portNumber"
            fi
    esac
done < /etc/config/twitch_$ipAddress
echo && echo "Appling full config...."
if [[ $ztp != true ]]; then
config -a >/dev/null 2>&1;
fi
echo && echo "Port 1 config....."
config -g config.ports.port1
echo "Updating host file"
cp /etc/config/twitch_hosts /etc/config/hosts
