#!/bin/bash
# Arguments...
#    -v         : verbose mode
#    --: also updates user groups (obsolete due to group script)
#    --audit    : audits users based on mast user list, checking for unexpected users
# Expected format for each line of user list from FTP is: <username> <group> <ssh key>

for var in $@; do
    if [[ $var == "-v" ]]; then verbose=true; fi
    if [[ $var == "--audit" ]]; then audit=true; fi
    if [[ $var == "-z" ]]; then ztp=true; fi
done

pad='.................................'


# audit users
if [[ $audit == true ]]; then
    if [[ -f /etc/config/twitch_opengear_users ]]; then
        echo "Removing old user list"
        rm /etc/config/twitch_opengear_users
    fi
    curl ftp://odin.dco.xarth.tv/scripts/twitch_opengear_users -o /etc/config/twitch_opengear_users
    echo "Downloaded twitch user list from FTP"
    userCount=`config -g config.users.total`
    userCount=${userCount#config.users.total}
    counter=2
    while [ $counter -le $userCount ]; do
            found=false
            localUser=$(config -g config.users.user$counter.username | cut -d ' ' -f 2-)
            while read -r line || [[ -n "$line" ]]; do
                listUser=$(echo $line | cut -d ' ' -f 1)
                #echo "testing $localUser against $listUser"
                if [[ $localUser == $listUser ]]; then
                    found=true
                fi
            done < /etc/config/twitch_opengear_users
            if [[ $found == false ]]; then
                echo "Found extraneous user: $localUser"
            fi
            let counter=counter+1
    done
    exit
fi

# remove user list and temp root keys if already esists

if [[ $verbose != true ]]; then echo -n "Removing stale temporary files..."; fi
if [[ -f /etc/config/twitch_opengear_users ]]; then
    if [[ $verbose == true ]]; then echo "Removing old user list"; fi
    rm /etc/config/twitch_opengear_users
fi
if [[ -f /etc/config/ssh_authorized_keys.tmp ]]; then
    if [[ $verbose == true ]]; then echo "Removing old temporary root key file"; fi
    rm /etc/config/ssh_authorized_keys.tmp
fi
if [[ $verbose != true ]]; then echo "DONE"; fi

# download latest user list from FTP

if [[ $verbose == true ]]; then
    curl ftp://odin.dco.xarth.tv/scripts/twitch_opengear_users -o /etc/config/twitch_opengear_users
else
    echo -n "Downloading twitch user list....."
    curl ftp://odin.dco.xarth.tv/scripts/twitch_opengear_users -o /etc/config/twitch_opengear_users >/dev/null 2>&1
    echo "DONE"
fi

# iterate through user list pulling appart usernames, groups, and keys

#touch /etc/config/ssh_authorized_keys.tmp

# set config variables
while read -r line || [[ -n "$line" ]]; do
    #echo "full: $line"
    username=$(echo $line | cut -d ' ' -f 1)
    group=$(echo $line | cut -d ' ' -f 2 | cut -d ' ' -f 2-)
    key=$(echo $line | cut -d ' ' -f 3-)
    #echo "user: $username"
    #echo "group: $group"
    #echo "key: $key"
    exists=$(id -u $username > /dev/null 2>&1; echo $?)
    testPrefix=$(config --list-base config.users --list-item-key username --list-get-by-value $username  | head -n1 | cut -f1-3 -d.)
    if [[ $exists == 1 ]]; then
        # user does not exist, create user
        #echo "Needs to create new user: $username"
	tempHead="Creating new user: $username"
	printf '%s %s' $tempHead "${pad:${#tempHead}}"
        prefix=$(config --list-base config.users --list-add)
        config -s $prefix.username=$username -s $prefix.groups.group1=$group  -s $prefix.groups.group2=users -s $prefix.password='$1$s4lt1e$4TmD7ANKGtbISf1A/jy14.'
        if [[ $group == "dcops" ]]; then
            config -s $prefix.groups.group3=admin
        fi
        printf '%s\n' "DONE"
    elif [ $exists == 0 ] && [ -z $testPrefix ]; then
        tempHead="Conflict user: $username"
	printf '%s %s' $tempHead "${pad:${#tempHead}}"
        prefix=$(config --list-base config.users --list-add)
        config -s $prefix.username=$username -s $prefix.groups.group1=$group  -s $prefix.groups.group2=users
        if [[ $group == "dcops" ]]; then
            config -s $prefix.groups.group3=admin
        fi
        printf '%s\n' "DONE"
    else
        prefix=$testPrefix
	tempHead="Updating user: $username"
        printf '%s %s' $tempHead "${pad:${#tempHead}}"
        config -s $prefix.groups.group1=$group -s $prefix.groups.group2=users
        if [[ $group == "dcops" ]]; then
            config -s $prefix.groups.group3=admin
        fi
        printf '%s\n' "DONE"
    fi
done < /etc/config/twitch_opengear_users

#apply config
if [[ $ztp == true ]]; then
	echo "DONE"
elif [[ $verbose == true ]]; then
    config -r users
else
    echo -n "Applying user configs............"
    config -r users >/dev/null 2>&1
    echo "DONE"
fi

while read -r line || [[ -n "$line" ]]; do
    username=$(echo $line | cut -d ' ' -f 1)
    group=$(echo $line | cut -d ' ' -f 2 | cut -d ' ' -f 2-)
    key=$(echo $line | cut -d ' ' -f 3-)
    echo -n "Updating key for user: $username"
    echo $key > /etc/config/users/$username/.ssh/authorized_keys
    if [[ $group == "dcops" ]]; then
        echo " (with root)"
        echo $key >> /etc/config/ssh_authorized_keys.tmp
    else
        echo
    fi
done < /etc/config/twitch_opengear_users


#inlcude lighthouse root key (old lighthouse)
#echo "ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAQEAxMMuDrRVBIOiK0cKLljblekre/ZsynJaOJ8l3cGlcq2H6L/IDOQDkREGn8cFHi0sHCaPNQpdwW+UiFsONUY2XH43UOU+1Xn9Y7f9KwgtDKCCra46UkRhpIzvgtgKwfVTuP5QGPBlQwJwMtLLoLq4ve/RzTKWF9mouLIe3SfE1NZZo3HJ8URpk8/DRgcI5iC9U0e0k6+bLnHSY790d2SkXu3gB1rsvQCsuxw60O13nyVb3tNn8dlEkGTivQM/vppNxp04zAERa4LCA1GV9PQ9EXL2WAJIwtZD06Gq7KjXD7zTg/7C7aO+S5tnX9bonNLdMCKOYhTS3dhYMPruODZQ3Q== nagios@lighthouse" >> /etc/config/ssh_authorized_keys.tmp
#mv /etc/config/ssh_authorized_keys.tmp /etc/config/ssh_authorized_keys

# set all users to key only auth

userCount=`config -g config.users.total`
userCount=${userCount#config.users.total}
counter=2
if [[ $verbose != true ]]; then
    echo -n "Removing key force on all users.."
else
    echo "Removing key force on all users"
fi
while [ $counter -le $userCount ]; do
        config -s config.users.user$counter.ssh_pubkey_only=off
        let counter=counter+1
done
if [[ $verbose != true ]]; then echo "DONE"; fi

if [[ $ztp == true ]]; then
echo "DONE"
elif [[ $verbose == true ]]; then
    config -a
else
    echo -n "Applying opengear config........."
    config -a >/dev/null 2>&1
    echo "DONE"
fi

