# Script to thread a large ping test (equivilent to nmap -sP)
# Usage mass-ping.py <input_file> <output_file>

import sys, subprocess, threading, time, os, re, json, dns.resolver, dns.reversename
tempArray={}

class threadedCommand(object):
        responseDict = {} # Populated while we in use
        hosts = []
        thread_count = 4
	dnsResolver = None
        ping_success = False
        lock = threading.Lock()

        def runCommand(self, host):
                self.responseDict[host] = {}
		self.responseDict[host]["ping"] = None
		self.responseDict[host]["PTR"] = []
		self.responseDict[host]["err"] = []
		# Ping CHeck
                if os.system("ping -c 1 " + host + " > /dev/null 2>&1") == 0:
                        self.ping_success = True
                else:
                        if os.system("ping -c 4 " + host + " > /dev/null 2>&1") == 0:
                                self.ping_success = True
                        else:
                                self.ping_success = False
                if self.ping_success == False:
                        self.responseDict[host]["ping"] = False
			print host.strip() + " down"
                if self.ping_success == True:
                        self.responseDict[host]["ping"] = True
			print host.strip() + " up"
		# DNS Reverse Check
		try:
	                ptrLookup = self.dnsResolver.query(dns.reversename.from_address(host),'PTR')
        	        rrList = []
                	for response in ptrLookup:
                        	rrList.append(str(response))
	                self.responseDict[host]["PTR"] = rrList
		except dns.resolver.NXDOMAIN:
			self.responseDict[host]["err"].append("No PTR Record Found")

        def popQueue(self):
                hostname = None
                self.lock.acquire()
                if self.hosts:
                                hostname = self.hosts.pop().rstrip()
                self.lock.release()
                return hostname

        def deQueue(self):
                while True:
                        hostname = self.popQueue()
                        if not hostname:
                                return None
                        self.runCommand(hostname)

        def start(self):
                threads = []
                for i in range(self.thread_count):
                        # add threads to the thread array
                        t = threading.Thread(target=self.deQueue)
                        t.start()
                        threads.append(t)
                # Wait for all threads
                [ t.join() for t in threads ]
                return self.responseDict

if __name__=='__main__':

        #Check for arguments
        if len(sys.argv) != 3:
                print "Two arguments expected"
                exit()

        #Open first arugment as read-only input file
        input_file = open(sys.argv[1],"r")

	#Create DNS resolver
	newResolver = dns.resolver.Resolver()
	newResolver.nameservers = ['10.254.0.3']

        # instantiate class
        run = threadedCommand()
        run.thread_count = 36
	run.dnsResolver = newResolver
        run.hosts = input_file.readlines()
        #run.hosts = ['pdu27b.sfo01.justin.tv']

        # start threaded processes
        final=run.start()
	jsonFinal = json.dumps(final)

        #Open second argument as write-only output file
        output_file = open(sys.argv[2],"w")

        #print dict/json style result to output file
        output_file.write(str(jsonFinal))

	pingCount = 0
	for host,value in final.iteritems():
		if value["ping"]:
			pingCount+=1
		
	print "Done - " + str(pingCount) + "/" + str(len(final)) + " responded"
        #for host, value in final.iteritems():
        #        if value["ping"]:
        #                print host+" up"
        #        else:
        #                print host+" down"


