#!/bin/bash

# Prompt for needed information
echo -n "Enter IP address within the /24 (10.8.0.1): "
read startingIP
echo
echo -n "Enter IPMI Password: "
read -s password
echo
echo
echo -n "Desired identity for blink (0=off,1=1second,force=forever): "
read identity
if [[ $identity !=  "0" && $identity != "1" && $identity != "force" ]]; then
	echo
	echo "Unknown identity specific"
	exit
fi
echo
read -p "Press enter to continue"

IFS='.' read -r -a IParray <<< "$startingIP"

for index in {1..254};do
    echo "running chosen blink on ${IParray[0]}.${IParray[1]}.${IParray[2]}.$index"
    ipmitool -H ${IParray[0]}.${IParray[1]}.${IParray[2]}.$index -U ADMIN -P $password chassis identify $identity &
done
echo
echo "Complete"
