#!/bin/bash

#masterAddr=$1
#slaveAddr=$2

for masterAddr in "$@"; do

	echo && echo "$masterAddr" && echo "=========================================================" && echo

	declare -A targetArray
	declare -A infoArray
	targetArray=(
		[1]="0x20"
		[2]="0x10"
		[3]="0x82"
		[4]="0x84"
		[5]="0x86"
		[6]="0x88"
		[7]="0x8A"
		[8]="0x8C"
		[9]="0x8E"
		[10]="0x90"
		[11]="0x92"
	)
	infoArray=(
		[1]="Hubnode 1"
		[2]="Hubnode 2"
		[3]="Node 1"
		[4]="Node 2"
		[5]="Node 3"
		[6]="Node 4"
		[7]="Node 5"
		[8]="Node 6"
		[9]="Node 7"
		[10]="Node 8"
		[11]="Node 9"
	)

	for i in {1..11};do
		if [ "${targetArray[$i]}" == "0x20" ]; then
			echo && echo "$masterAddr: Sensor Information"
			ipmi-kontron -H $masterAddr -U admin -P admin -I lanplus -t ${targetArray[$i]} sdr list | grep 'Hot Swap\|Node\|PSU2:Status\|PSU1:Status\|:Speed\|Chassis Health'
			echo && echo "$masterAddr: Hubnode Version Info"
			/data/dco/scripts/kontron/symtool.sh $masterAddr hub all ver | grep 'Active\|BMC'
		fi
		echo && echo "$masterAddr: ${infoArray[$i]}"
		ipmi-kontron -H $masterAddr -U admin -P admin -I lanplus -t ${targetArray[$i]} fru | grep 'Board Serial\|Chassis Serial\|Board Product'
		ipmi-kontron -H $masterAddr -U admin -P admin -I lanplus -t ${targetArray[$i]} lan print | grep 'Address'
		#/data/dco/scripts/kontron/symtool.sh $masterAddr hub 1 ver | grep 'Active\|BMC'
	done
	echo && echo "=========================================================" && echo
done
