import paramiko
from threading import Thread
from navigation import navigateToBMC, navigateToCLI, navigateToSHMC, backToSHMC
from commands import launchSHMCCommands
from collectors import BMCWrapper, collectLogs
from listeners import commandListener
from validations import switchValidation
from files import report
from tools import watchdog
import globalVariables

def app(host, port, username, password, outputFile, keyfile):
    ssh = paramiko.SSHClient()
    ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
    if keyfile:
        ssh.connect(host, port=port, username=username,
                    key_filename=keyfile)
    else:
        ssh.connect(host, port=port, username=username, password=password)

    print("Connected to %s" % host)

    globalVariables.channel = ssh.invoke_shell()

    _watchdog = Thread(target=watchdog)
    _watchdog.start()

    # Begin the SHMC collector
    navigateToSHMC()
    launchSHMCCommands()
    BMCWrapper("0x20", outputFile)

    # collect nodes informations
    # 0x82 -> 0x92
    for x in range(0x82, 0x94, 0x02):
        navigateToBMC(hex(x))
        BMCWrapper(hex(x), outputFile)
    backToSHMC()

    navigateToCLI()

    t1 = Thread(target=collectLogs)
    t2 = Thread(target=commandListener)

    t1.start()
    t2.start()
    

    t1.join()
    t2.join()
    _watchdog.join()

    switchValidation(outputFile)

    report(outputFile, globalVariables.FAIL)