import time
import re
import globalVariables
from tools import parser
from files import saveOutput

def collectBMC(cmd, msg):
    print("Collecting %s ..." % msg)
    output = ''
    done = False

    globalVariables.channel.send("\x0d")
    globalVariables.channel.send(cmd)
    globalVariables.channel.send("\x0d")
    time.sleep(globalVariables.sleepTime)

    while not done:
        globalVariables.buffer = globalVariables.channel.recv(4096)
        output += globalVariables.buffer.decode("utf-8")

        if re.search("(.*ipmitool>\ +$)", globalVariables.buffer.decode("utf-8")):
            done = True

    time.sleep(globalVariables.sleepTime)
    globalVariables.channel.send("\x0d")
    return output


def collectLogs():
    print("Start collecting logs ...")

    # Collect the logs
    while globalVariables.collectingLogs:
        globalVariables.buffer = globalVariables.channel.recv(4096)
        globalVariables.switchOutput += globalVariables.buffer.decode("utf-8")
    return

def BMCWrapper(id, outputFile):
    print("Starting BMC Collector ...")

    fru = collectBMC("fru", "FRU")
    hpm = collectBMC("hpm check", "HPM")
    lan = collectBMC("lan print", "LAN")
    # Parsing Process
    parser(id, fru, "Board Serial", outputFile)
    parser(id, fru, "Chassis Serial", outputFile, True)
    parser(id, fru, "Board Product", outputFile)
    parser(id, fru, "Board Extra", outputFile)
    parser(id, hpm, "BMC", outputFile)
    parser(id, hpm, "FPGA", outputFile)
    parser(id, hpm, "BIOS", outputFile, True)
    parser(id, lan, "^IP Address Source\ +:", outputFile)
    parser(id, lan, "^IP Address\ +:", outputFile)
    parser(id, lan, "MAC Address", outputFile)
    parser(id, lan, "802.1q VLAN ID", outputFile)
    saveOutput(outputFile, "\r")