import csv

def getFileList(filename):
    obj = dict()
    with open(filename, 'r') as csvFile:
        reader = csv.reader(csvFile, delimiter=';')
        for row in reader:
            obj[row[0]] = row[1]
    csvFile.close()
    return obj


def saveOutput(filename, line):
    if filename:
        with open(filename, 'a') as writeFile:
            writer = csv.writer(
                writeFile, delimiter=';', lineterminator='\n', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
            if isinstance(line, list):
                for l in line:
                    writer.writerow([l])
            else:
                writer.writerow([line])
        writeFile.close()
    else:
        print("No filename provided, the logs WILL NOT be SAVED")

def report(filename, fail):
    print("Printing if PASS or FAIL ...")
    if filename:
        with open(filename, 'a') as writeFile:
            writer = csv.writer(
                writeFile, delimiter=';', lineterminator='\n', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
            if fail:
                print("FAIL")
                writer.writerow(["Global Test Result\tFAIL"])
            else:
                print("PASS")
                writer.writerow(["Global Test Result\tPASS"])
        writeFile.close()
    else:
        print("No filename provided, the report WILL NOT be SAVED")