# Author: Tommy Gingras Kontron Canada
# Goal: Using a Serial terminal from the SSH connection get and validate the output
# Date: 2019-05-16
# Version: 1.4.0

import sys
import getopt
import getpass
from app import app
from files import getFileList
from globalVariables import init

def main(argv):
    inputfile = ''
    outputfile = ''
    key_filename = ''

    print("----------INFO----------")
    try:
        opts, args = getopt.getopt(
            argv, "hi:o:k:", ["filename=", "output=", "key="])
    except getopt.GetoptError:
        print('script.py -i <inputfile> -o <outputfile> -k <ssh_key>')
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print('script.py -i <inputfile> -o <outputfile> -k <ssh_key>')
            sys.exit()
        elif opt in ("-i", "--filename"):
            inputfile = arg
            print("The hosts/ports will be loaded from : %s" % inputfile)
        elif opt in ("-k", "--key"):
            key_filename = arg
            print("The SSH key : %s" % key_filename)
        elif opt in ("-o", "--output"):
            outputfile = arg
            print("The logs will be saved : %s" % outputfile)
    print("----------INFO----------")

    init()

    # Prompt for ssh password
    username = input("Serial Terminal SSH Username: ")
    # keyfile = input("Path to private key: ")
    password = getpass.getpass()

    terminalList = dict()
    # Contants
    if inputfile:
        terminalList = getFileList(inputfile)

    if len(terminalList) == 0:
        host = input("SSH IP of the serial console: ")
        port = int(input("SSH Port of the serial console: "))
        if not outputfile:
            outputfile = (host.replace('.', '-') + '-' + str(port) + ".log")
            print("The logs will be saved : %s" % outputfile)
        app(host, port, username, password, outputfile, key_filename)
    else:
        if not outputfile:
            outputfile = input("Output file name: ")
            print("The logs will be saved : %s" % outputfile)
        for key, value in terminalList.items():
            host = key
            port = int(value)
            app(host, port, username, password, outputfile, key_filename)


if __name__ == "__main__":
    main(sys.argv[1:])

    print("Jobs complete")
