import time
import globalVariables

def navigateToBMC(hex):
    navigateToSHMC()
    print("Navigate to the node BMC %s ..." % hex)
    # From the SHMC write set targetaddr 0x[82-92]
    globalVariables.channel.send("set targetaddr %s" % hex)
    globalVariables.channel.send("\x0d")
    time.sleep(globalVariables.sleepTime)


def navigateToSHMC():
    print("Navigate to the SHMC ...")
    # Send CTRL+G 0 then Enter
    globalVariables.channel.send("\x07")
    globalVariables.channel.send("0")
    globalVariables.channel.send("\x0d")
    time.sleep(globalVariables.sleepTime)


def navigateToCLI():
    print("Navigate to the Swith CLI ...")
    # Send CTRL+G - then Enter
    globalVariables.channel.send("\x07")
    globalVariables.channel.send("-")
    globalVariables.channel.send("\x0d")
    globalVariables.channel.send("\x0d")
    globalVariables.channel.send("\x0d")
    time.sleep(globalVariables.sleepTime)


def backToSHMC():
    navigateToSHMC()
    globalVariables.channel.send("set targetaddr 0x20")
    globalVariables.channel.send("\x0d")