import re
from files import saveOutput
import globalVariables
import time
from threading import Thread

output = ''

def sendCommand(cmds, msg):
    print("Collecting %s" % msg)

    if len(cmds) > 0:
        for cmd in cmds:
            globalVariables.channel.send(cmd)
            globalVariables.channel.send("\x0d")


def cleaning(value):
    value = value.strip().rstrip()
    value = " ".join(value.split())
    value = value.replace(' : ', '\t')
    value = value.replace(' | ', '\t')
    value = value.replace('| ', '')
    value = value.replace('|* ', '')
    value = value.replace(' |', '')
    value = value.replace('|', '\t')
    return value

def parser(id, content, search, outputFile, optional=False):
    cleaned = content.split('\n')
    for value in cleaned:
        if re.search("(" + search + ")", value):
            value = cleaning(value)
            value = id+"\t"+value
            saveOutput(outputFile, value)
            return value

    if optional:
        saveOutput(
            outputFile, "%s\t%s\tNot Applicable or Not Present" % (id, search))
    if not optional:
        saveOutput(
            outputFile, "%s\tData Not Found\tNeed Manual Investigation" % id)
        globalVariables.FAIL = True
    return "Invalid Data"

def isHang():
    global output
    while globalVariables.collectingLogs:
        output = globalVariables.channel.recv(4096)
        if output:
            time.sleep(2)
    return

def watchdog():
  global output
  lastState = ''
  counter = 0

  t1 = Thread(target=isHang)
  t1.start()

  lastState = output
  while globalVariables.collectingLogs:
      time.sleep(2)
      if output != lastState:
          lastState = output
      else:
          counter += 1
          if counter >= 5:
              counter = 0
              print("Watchdog sent ENTER command ...")
              globalVariables.channel.send("\x0d")
  t1.join()
  globalVariables.channel.send("\x0d")
              
  print("watchdog has stopped !")
  return