import re
from files import saveOutput
import globalVariables

switchValidators = dict()
switchValidators["(Eth\ 1\/2.*Enabled.*6.*1)"] = ("LACP Eth 1/2\tUP",
                                                  "LACP Eth 1/2\tDOWN")
switchValidators["(Eth\ 1\/25.*Enabled)"] = ("LACP Eth 1/25\tUP",
                                             "LACP Eth 1/25\tDOWN")
switchValidators["(Eth\ 2\/2.*Enabled.*6.*1)"] = ("LACP Eth 2/2\tUP",
                                                  "LACP Eth 2/2\tDOWN")
switchValidators["(Eth\ 2\/25.*Enabled)"] = ("LACP Eth 2/25\tUP",
                                             "LACP Eth 2/25\tDOWN")

def switchValidation(outputFile):
    print("Running Switch validations ...")
    msg = []

    for key in switchValidators:
        if re.search(key, globalVariables.switchOutput):
            msg.append(switchValidators[key][0])
        else:
            msg.append(switchValidators[key][1])
            globalVariables.FAIL = True

    saveOutput(outputFile, msg)