# Author: Tommy Gingras Kontron Canada
# Goal: Using a Serial terminal from the SSH connection get and validate the output
# Date: 2019-05-16
# Version: 1.3.0

import paramiko
import time
import getpass
import re
from threading import Thread
import sys
import getopt
import csv

FAIL = False

# Functions

# Switch Validations
switchValidators = dict()
switchValidators["(Eth\ 1\/2.*Enabled.*6.*1)"] = ("LACP Eth 1/2\tUP",
                                                  "LACP Eth 1/2\tDOWN")
switchValidators["(Eth\ 1\/25.*Enabled)"] = ("LACP Eth 1/25\tUP",
                                             "LACP Eth 1/25\tDOWN")
switchValidators["(Eth\ 2\/2.*Enabled.*6.*1)"] = ("LACP Eth 2/2\tUP",
                                                  "LACP Eth 2/2\tDOWN")
switchValidators["(Eth\ 2\/25.*Enabled)"] = ("LACP Eth 2/25\tUP",
                                             "LACP Eth 2/25\tDOWN")
# SHMC Commands
SHMCCommands = dict()
SHMCCommands["(.*ipmitool>\ +$)"] = (True, "set targetaddr 0x20")
#SHMCCommands["(.*MSH8900 login:\ +$)"] = (False, "admin")
SHMCCommands["(.*MSH8900\ +)"] = (False, "admin")
SHMCCommands["(.*Username:\ +$)"] = (False, "admin")
SHMCCommands["(.*Password:\ +$)"] = (False, "admin")

global currentHost
currentHost = str("")
sleepTime = int(3)

# Validators


def switchValidation(outputFile):
    global switch
    global FAIL
    print("Running Switch validations ...")
    msg = []

    for key in switchValidators:
        if re.search(key, switch):
            msg.append(switchValidators[key][0])
        else:
            msg.append(switchValidators[key][1])
            FAIL = True

    saveOutput(outputFile, msg)


def parser(id, content, search, outputFile, optional=False):
    global FAIL

    cleaned = content.split('\n')
    for value in cleaned:
        if re.search("(" + search + ")", value):
            value = cleaning(value)
            value = id+"\t"+value
            saveOutput(outputFile, value)
            return value

    if optional:
        saveOutput(
            outputFile, "%s\t%s\tNot Applicable or Not Present" % (id, search))
    if not optional:
        saveOutput(
            outputFile, "%s\tData Not Found\tNeed Manual Investigation" % id)
        FAIL = True
    return "Invalid Data"
# Navigation


def navigateToBMC(hex):
    global channel
    navigateToSHMC()
    print("Navigate to the node BMC %s ..." % hex)
    channel.send("set targetaddr %s" % hex)
    channel.send("\x0d")
    time.sleep(sleepTime)


def navigateToSHMC():
    global channel
    print("Navigate to the SHMC ...")
    # Send CTRL+G 0 then Enter
    channel.send("\x07")
    channel.send("0")
    channel.send("\x0d")
    time.sleep(sleepTime)


def navigateToCLI():
    global channel
    print("Navigate to the Swith CLI ...")
    # Send CTRL+G - then Enter
    channel.send("\x07")
    channel.send("-")
    channel.send("\x0d")
    channel.send("\x0d")
    channel.send("\x0d")
    time.sleep(sleepTime)


# Launcher
def launchSHMCCommands():
    global channel
    print("Launch SHMC Commands...")
    output = ''
    done = False
    while not done:
        buffer = channel.recv(4096)
        output += buffer.decode("utf-8")

        for key in SHMCCommands:
            if re.search(key, buffer.decode("utf-8")):
                channel.send(SHMCCommands[key][1])
                channel.send("\x0d")
                time.sleep(sleepTime)
                done = SHMCCommands[key][0]

    return output

# Tooling


def grabCommands():
    global buffer
    global switch
    global collectingLogs
    global channel

    print("Start Grabbing commands ...")
    # Grab the command while we need it.
    done = False

    while not done:
        if re.search("(.*#\ +$)", buffer.decode("utf-8")):
            if not done:
                print("Getting the Switch Output ..")
                time.sleep(1)
                channel.send("en")
                channel.send("\x0d")
                # collectors
                sendCommand(["show running-config", "g"],
                            "Running configuration")
                sendCommand(["show lacp neighbour"], "LACP Neighbor")

                # After ten seconds just enough time to collect all the output, end the program
                done = True
                time.sleep(10)
                collectingLogs = False
                channel.send("\x0d")
            else:
                continue

        elif re.search("(.*Username:\ +$)", buffer.decode("utf-8")):
            channel.send("admin")
            channel.send("\x0d")
            time.sleep(sleepTime)

        elif re.search("(.*Password:\ +$)", buffer.decode("utf-8")):
            channel.send("admin")
            channel.send("\x0d")
            #time.sleep(1)
            time.sleep(sleepTime)

        elif re.search("(.*ENTER.*)", buffer.decode("utf-8")):
            channel.send("\x0d")

        else:
            # Maybe not a good idea ...
            if not done:
                channel.send("\x0d")
    return


def sendCommand(cmds, msg):
    global channel
    print("Collecting %s" % msg)

    if len(cmds) > 0:
        for cmd in cmds:
            channel.send(cmd)
            channel.send("\x0d")


def cleaning(value):
    value = value.strip().rstrip()
    value = " ".join(value.split())
    value = value.replace(' : ', '\t')
    value = value.replace(' | ', '\t')
    value = value.replace('| ', '')
    value = value.replace('|* ', '')
    value = value.replace(' |', '')
    value = value.replace('|', '\t')
    return value

## Collector definitions ##


def collectBMCData(cmd, msg):
    global channel

    print("Collecting %s ..." % msg)
    output = ''
    done = False
    channel.send("\x0d")
    channel.send(cmd)
    channel.send("\x0d")
    #time.sleep(1)
    time.sleep(sleepTime)

    while not done:
        channel.send("\x0d")
        time.sleep(sleepTime)
        buffer = channel.recv(4096)
        output += buffer.decode("utf-8")
        if re.search("(.*ipmitool>\ +$)", buffer.decode("utf-8")):
            done = True
    #time.sleep(1)
    time.sleep(sleepTime)
    return output


def collectLogs():
    global buffer
    global switch
    global collectingLogs
    print("Start collecting logs ...")

    # Collect the logs
    while collectingLogs:
        buffer = channel.recv(4096)
        switch += buffer.decode("utf-8")


def BMCCollector(id, outputFile):
    print("Starting BMC Collector ...")
    fru = collectBMCData("fru", "FRU")
    hpm = collectBMCData("hpm check", "HPM")
    lan = collectBMCData("lan print", "LAN")
    # Parsing Process
    parser(id, fru, "Board Serial", outputFile)
    parser(id, fru, "Board Product", outputFile)
    parser(id, fru, "Chassis Serial", outputFile, True)
    parser(id, fru, "Board Extra", outputFile)
    parser(id, hpm, "BMC", outputFile)
    parser(id, hpm, "FPGA", outputFile)
    parser(id, hpm, "BIOS", outputFile, True)
    parser(id, lan, "^IP Address Source\ +:", outputFile)
    parser(id, lan, "^IP Address\ +:", outputFile)
    parser(id, lan, "MAC Address", outputFile)
    parser(id, lan, "802.1q VLAN ID", outputFile)
    saveOutput(outputFile, "\r")


# File Operations
def getFileList(filename):
    obj = dict()
    with open(filename, 'r') as csvFile:
        reader = csv.reader(csvFile, delimiter=';')
        for row in reader:
            obj[row[0]] = row[1]

    csvFile.close()
    return obj


def saveOutput(filename, line):
    global currentHost
    if filename:
        with open(filename, 'a') as writeFile:
            writer = csv.writer(
                writeFile, delimiter=';', lineterminator='\n', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
            if isinstance(line, list):
                for l in line:
                    writer.writerow([currentHost + "\t" + l])
            else:
                writer.writerow([currentHost + "\t" + line])
        writeFile.close()


def report(filename, fail):
    print("Printing if PASS or FAIL ...")
    if filename:
        with open(filename, 'a') as writeFile:
            writer = csv.writer(
                writeFile, delimiter=';', lineterminator='\n', quotechar='\"', quoting=csv.QUOTE_MINIMAL)
            if fail:
                writer.writerow(["Test Result\tFAIL"])
            else:
                writer.writerow(["Test Result\tPASS"])
        writeFile.close()

# Application


def app(host, port, username, password, outputFile, keyfile):
    global collectingLogs
    global buffer
    global switch
    global channel
    global FAIL
    global currentHost

    # Variables
    buffer = ''
    switch = ''
    collectingLogs = True

    ssh = paramiko.SSHClient()
    ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
    if keyfile:
        ssh.connect(host, port=port, username=username,
                    key_filename=keyfile)
    else:
        ssh.connect(host, port=port, username=username, password=password)

    print("Connected to %s" % host)
    currentHost = str(host)
    print(currentHost)

    channel = ssh.invoke_shell()

    # Begin the SHMC collector
    navigateToSHMC()
    launchSHMCCommands()
    BMCCollector("0x20", outputFile)

    # collect nodes informations
    # 0x82 -> 0x92
    for x in range(0x82, 0x94, 0x02):
        navigateToBMC(hex(x))
        BMCCollector(hex(x), outputFile)

    channel.send("set targetaddr 0x20\0x0d")
    navigateToCLI()

    t1 = Thread(target=collectLogs)
    t2 = Thread(target=grabCommands)

    t1.start()
    t2.start()

    t1.join()
    t2.join()

    switchValidation(outputFile)

    report(outputFile, FAIL)


def main(argv):
    inputfile = ''
    outputfile = ''
    key_filename = ''

    print("----------INFO----------")
    try:
        opts, args = getopt.getopt(
            argv, "hi:o:k:", ["filename=", "output=", "key="])
    except getopt.GetoptError:
        print('script.py -i <inputfile> -o <outputfile> -k <ssh_key>')
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print('script.py -i <inputfile> -o <outputfile> -k <ssh_key>')
            sys.exit()
        elif opt in ("-i", "--filename"):
            inputfile = arg
            print("The hosts/ports will be loaded from : %s" % inputfile)
        elif opt in ("-k", "--key"):
            key_filename = arg
            print("The SSH key : %s" % key_filename)
        elif opt in ("-o", "--output"):
            outputfile = arg
            print("The logs will be saved : %s" % outputfile)
    print("----------INFO----------")

    # Prompt for ssh password
    username = input("Serial Terminal SSH Username: ")
    # keyfile = input("Path to private key: ")
    password = getpass.getpass()

    terminalList = dict()
    # Contants
    if inputfile:
        terminalList = getFileList(inputfile)

    if len(terminalList) == 0:
        host = input("SSH IP of the serial console: ")
        port = int(input("SSH Port of the serial console: "))
        app(host, port, username, password, outputfile, key_filename)

    for key, value in terminalList.items():
        host = key
        port = int(value)
        if not outputfile:
            outputfile = (host.replace('.', '-') + '-' + str(port) + ".log")
            print("The logs will be saved : %s" % outputfile)
        app(host, port, username, password, outputfile, key_filename)


if __name__ == "__main__":
    main(sys.argv[1:])

    print("Jobs complete")
