#!/bin/bash
# By: Simon Monette

# Variables declaration
opAr=($@)
ip=${opAr[0]}; comp=${opAr[1]}; slot=${opAr[2]}; cmd=(${opAr[@]:3})
ipmi="eval ipmi-kontron -I lanplus -H"
login="-U admin -P admin"
ipmip="$ipmi $ip $login"
rawmagic="0xB4 0x90 0x91 0x8B"

# Help section
usage(){
	printf '\n%s\n' "Version: 3.2.1"
	printf '%s\n\n' "usage: symtool <addr> | <comp> | <list> | <opt>"
	printf '%s\n' " addr -> IP address of the FRU ShMC"
	printf '%s\n\n' "      -> upgrade = Update script to new version"
	printf '%s\n' " comp -> hub    = Execute <opt> on ShMC"
	printf '%s\n' "      -> node   = Execute <opt> on node"
	printf '%s\n' "      -> all    = Execute <opt> on hub + node"
	printf '%s\n\n' "      -> [none] = Execute <opt [else]> on <addr>"
	printf '%s\n' " list -> On which specific component to run <opt> "
	printf '%s\n' "      -> all = auto use max value"
	printf '%s\n' "      -> 1,9 = to 1 and 9"
	printf '%s\n\n' "      -> 1-9 = from 1 to 9"
	printf '%s\n' " opt These are shorthand's for useful commands"
	printf '%s\n' "      -> ver  = Print HPM firmware version"
	printf '%s\n' "      -> id   = Print 'Product ID'"
	printf '%s\n' "      -> ssh  = Enable SSH"
	printf '%s\n' "      -> tty  = Enable serial console"
	printf '%s\n' "      -> chid = Write/read chassis ID in PDB"
	printf '%s\n' "      -> ipo  = Set BMC IP source to 'other'"
	printf '%s\n' "      -> ipd  = Set BMC IP source to 'DHCP'"
	printf '%s\n' "      -> ips  = Set BMC static IP configuration"
	printf '%s\n' "      -> iol  = Send command to IP of target"
	printf '%s\n' "      -> vlan  = Set VLAN ID of target"
	printf '%s\n' "      -> pxe  = Set target next boot device to PXE"
	printf '%s\n' "      -> utc  = Convert host time to UTC and set ShMC time."
	printf '%s\n' "      -> fan  = Set fans level, input is in percentage"
	printf '%s\n' "      -> failover = Force a switch-over"
	printf '%s\n' "      -> kill = kill node suspend power"
	printf '%s\n' "      -> upg  = Upgrade component, usage: upg 4003 kmdk.hpm all activate"
	printf '%s\n' "      -> bundle = Print bundle information"
	printf '%s\n' "      -> cpu = Send commande to node CPU 1|2|all"
	printf '%s\n' "      -> [else] = Execute [else] as a IPMI command"
}

# Trap exit and clear screen buffer
finish(){
	[ $buffer ] && echo -e "\e[?1049l"
}
trap finish EXIT

# Will print usage() if no argument is received
[ $# -lt 1 ] && usage && exit 1

# Self-update
selfUpdate(){
	update_url=http://10.30.2.27/job/INTEGRATION_KICKSTART_SYNC/lastStableBuild/artifact/symtool
	wget -NO $0 ${update_url}/$(basename $0)
	chmod +x $0
	exit 1
}
[ $ip = "upgrade" ] && selfUpdate

# Return FRU product id
partid(){
	part=$($bridge mc info 2> /dev/null| grep "Product ID"| grep -Eo '[0-9]{4}')
	[ "${#part}" != "0" ] && echo $part || echo "~~~~"
}

# Return FRU IP address
lanprint(){
	$bridge lan print| grep "IP Address  "| sed 's/.*: //'
}

# Set static IP
static(){
	if [ -z $subnet ]; then
		read -e -p $'\nInput default gateway: ' defgw
		read -e -i "255.255.255.0" -p "Input Subnet: " subnet
		# Find the subnet of the network
		IFS=. read -r ip1 ip2 ip3 ip4 <<< "$defgw"
		IFS=. read -r nm1 nm2 nm3 nm4 <<< "$subnet"
		sn1=$((ip1 & nm1))
		sn2=$((ip2 & nm2))
		sn3=$((ip3 & nm3))
		sn4=$((ip1 & nm4))
		[[ $nm1 -eq 255 ]] && sn1="$sn1." || sn1=""
		[[ $nm2 -eq 255 ]] && sn2="$sn2." || sn2=""
		[[ $nm3 -eq 255 ]] && sn3="$sn3." || sn3=""
		[[ $nm4 -eq 255 ]] && sn4="$sn4." || sn4=""
		network="$sn1$sn2$sn3$sn4"
	fi
	read -e -i "$network" -p $'\nInput '$type' '$slot' IP: ' ip
	$bridge lan set 1 ipsrc static > /dev/null
	$bridge lan set 1 ipaddr $ip > /dev/null
	$bridge lan set 1 netmask $subnet > /dev/null
	$bridge lan set 1 defgw ipaddr $defgw > /dev/null
}

# Return ipmitool contextual output, used as shorthand to bridge command to FRU
tools(){
	addr="$1"; type="$2"; cmd="${3}"
	bridge="$ipmip -m 32 -t $addr"
	case $cmd in
		"kill") part="not_needed" ;;
		*) part="$(partid)" ;;
	esac
	printf "[ $type $slot $part ]: "
	if [ "$part" = "~~~~" ]; then
		 echo "Slot empty"
	else
		case $cmd in
			"ip") printf '%s\n' $(lanprint) ;;
			"id") printf '%s\n' $part ;;
			"ipo") printf '%s\n' $($bridge lan set 1 ipsrc other) ;;
			"ipd") printf '%s\n' $($bridge lan set 1 ipsrc dhcp) ;;
			"ips") static ;;
			"iol") echo; $ipmi $(lanprint) $login ${cmd[@]:1} ;;
			"ver") printf '\n%s\n\n' "$($bridge hpm check 2> /dev/null| head -n -1)" ;;
			"ssh") $bridge raw 0x3E 0x15 $rawmagic ;;
			"tty") $bridge raw 0x3E 0x17 $rawmagic 0x01 ;;
			"utc") $bridge "sel time set '$(date -u +"%m/%d/%Y %H:%M:%S")'" ;;
			"pxe")	echo; $bridge chassis bootdev pxe
					$bridge power reset
					$bridge power on

			;;
			"vlan") echo; $bridge lan set 1 vlan id ${cmd[@]:1} ;;
			"chid")
				[[ ${cmd[@]:1} == "" ]] && $bridge raw 0x3e 0x21 0xc2 ||
				( [ $addr == "32" ] && $bridge raw 0x3e 0x20 0xc2 ${cmd[@]:1} )
			;;
			"fan")
				speed=$(echo "${cmd[@]:1}*2.55"| bc)
				printf -v speed "%x" "${speed%.*}"
				$bridge raw 0x3E 0x0F $rawmagic 0x8B 0x$speed
			;;
			"failover")
				id=$($ipmip raw 0x3e 0x62 $rawmagic 0x01 0x01)
				[ $id = "0e" ] && status="Master" || status="Standby"
				[ "$status" = "Master"  ] && $ipmip raw 0x3E 0x19 $rawmagic
				[ "$status" = "Standby" ] && $ipmip -m 0x10 -t 0x20 raw 0x3E 0x19 $rawmagic
				exit 1
			;;
			"kill")
				$ipmip raw 0x3e 0x62 $rawmagic 0x50 0x01 0x40
				$ipmip raw 0x3e 0x62 $rawmagic $(($addr - 49)) 0x01 0x84
			;;
			"upg")
				if [ ${cmd[1]} = $part ]; then
					node="$ip-$type$slot.upg"
					$ipmi $(lanprint) $login hpm upgrade ${cmd[@]:2} > "/tmp/$node" 2>&1 &
					pids="$pids $!"
					files="$files $node"
					echo "Upgrading $part"
				else echo "Will not update $part"
				fi
			;;
			"bundle")
				( [ $addr == "32" ] && printf '\n%s' "$($ipmip fru print 128| grep "Chassis Serial"| tr -d '\n' )" )
				strFRU="$($ipmi $(lanprint) $login fru print 0)"
				printf '\n%s\n' "$(grep 'Board Serial\|Board Part' <<< "$strFRU")"
				printf ' %s\n' "$($bridge lan print| grep "MAC A"| sed 's/  //')"
				printf '%s\n' "$($bridge hpm check 2> /dev/null| head -n -1)"
			;;
			"cpu"|"all")
				if [[ $part =~ ("4005"|"4009"|"8060") ]]; then
					[ ${cmd[0]} = "all" ] && cpu="all" || cpu=${cmd[1]}
					cmdbuff="${cmd[@]}"
					cmdCPU="${cmd[@]:2}"
					unset cmd
					ipmbCPU="$addr"
					echo
					[[ $cpu =~ ("1"|"all") ]] && slot=1 && tools "122 -b7 -T $ipmbCPU" "CPU " "$cmdCPU"
					[[ $cpu =~ ("2"|"all") ]] && slot=2 && tools "124 -b7 -T $ipmbCPU" "CPU " "$cmdCPU"
					cmd=($cmdbuff)
				else
					echo
					cmdbuff="${cmd[@]}"
					cmdCPU="${cmd[@]:2}"
					unset cmd
					slot=1 && tools $addr "CPU " "$cmdCPU"
					cmd=($cmdbuff)
				fi
			;;
			*) echo; $bridge "${cmd[@]}" ;;
		esac
	fi
	check=$(echo $?)
	[ "$addr" != "32" ] && [ $check = 1 ] && exit
}

# Run command for each item in list
execCMD(){
	list=$1; filter=$2; label=$3
	for slot in $list; do
		[ $filter = "node" ] && ipmb=$((128 + slot * 2))
		[ $filter = "hub"  ] && ipmb=$((48 - slot * 16))
		tools $ipmb $label ${cmd}
	done
}

# Range of nodes function
nodesRange(){
	range=$1
	if [ "$range" = "all" ]; then
		[ "$comp" = "node" ] && range="1-9"
		[ "$comp" =  "hub" ] && range="1-2"
	fi

	array=(${range//,/ })
	for index in "${!array[@]}"; do
		if [[ ${array[$index]} == *-* ]]; then
			value="${array[$index]//-/ }"
			array[$index]="$(seq $value)"
		fi
	done
	echo "${array[@]}"
}

# Main, will either bridge command to; all FRU, specific FRU or itself
echo
case $comp in
	"node") execCMD "$(nodesRange $slot)" $comp "Node" ;;
	"hub" ) execCMD "$(nodesRange $slot)" $comp "ShMC" ;;
	"all" ) cmd=(${opAr[@]:2})
			execCMD "$(seq 1 9)" "node" "Node"
			execCMD "$(seq 1 2)" "hub"  "ShMC" ;;
	*) cmd=(${opAr[@]:1}); tools "32" "self" ${cmd} ;;
esac

# Start background upgrade and display logs
if [[ $pids ]]; then
	echo -e "\e[?1049h" # Open screen buffer
	buffer=1
	while kill -0 $pids 2> /dev/null; do
		clear
		tail -n6 /tmp/$ip*.upg
		sleep 1
	done
	for file in $files; do mv "/tmp/$file" "/tmp/$(basename $file .upg).old"; done
fi

