import paramiko
import time
import getpass
import argparse
import re
import ipaddress
from threading import Thread
import sys
import getopt


def initialConnection(channel, verbose = False):
	tempBuffer = ''
	expected_prompts = {
		"(.*ipmitool>\ +$)": (True, "set targetaddr 0x20"),
		"(.*MSH8900\ +)": (False, "admin"),
		"(.*Username:\ +$)": (False, "admin"),
		"(.*Password:\ +$)": (False, "admin"),
		"(.*console.\ +$)": (False, "\x0d")
		}
	done = False
	counter = 0
	while not done:
		counter += 1
		buffer = channel.recv(4096)
		if verbose == True:
			print(buffer.decode("utf-8"))
		tempBuffer += buffer.decode("utf-8")
		for prompt in expected_prompts:
			if re.search(prompt, buffer.decode("utf-8")):
				channel.send(expected_prompts[prompt][1])
				channel.send("\x0d")
				time.sleep(2)
				done = expected_prompts[prompt][0]
		if done == False and counter == 5:
			channel.send("\x0d")
			time.sleep(2)
			channel.send("\x0d")
			counter = 0
	return tempBuffer

def runCommandIPMI(channel, cmd, verbose = False):
	tempBuffer = ''
	done = False
	channel.send("\x0d")
	channel.send(cmd)
	channel.send("\x0d")
	time.sleep(2)

	done = False
	while not done:
		buffer = channel.recv(4096)
		if verbose == True:
			print(buffer.decode("utf-8"))
		tempBuffer += buffer.decode("utf-8")
		if re.search("(.*ipmitool>\ +$)", buffer.decode("utf-8")):
			done = True
		else:
			channel.send("\x0d")
	time.sleep(2)

	return tempBuffer

def parseSerialOutput(needle,haystack,exclude = None):
	result=[]
	cleaned = haystack.split('\n')
	for value in cleaned:
		if re.search("(" + needle + ")", value):
			if exclude == None or not re.search("(" + exclude + ")", value):
				value = cleaning(value)
				result.append(value)

	result = [i.split('\t',1)[1] for i in result]
	return result


def cleaning(value):
	value = value.strip().rstrip()
	value = " ".join(value.split())
	value = value.replace(' : ', '\t')
	value = value.replace(' | ', '\t')
	value = value.replace('| ', '')
	value = value.replace('|* ', '')
	value = value.replace(' |', '')
	value = value.replace('|', '\t')
	return value


def hubnodeCheck(user, passwd, serial_IP, serial_port, verbose = False):

	# General Variables
	channel = None
	result = dict()
	
	# Create SSH session
	ssh = paramiko.SSHClient()
	ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
	# Try block on connect function for failed credentials
	try:
		ssh.connect(serial_IP, port=serial_port, username=user, password=passwd)
		print("Connected to %s" % serial_IP)
	except paramiko.AuthenticationException:
		print()
		print("Incorrect Password")
		exit()
		result['ERROR']=str("Authentication failed, please verify your credentials")
		return result

	# create SSH shell
	channel = ssh.invoke_shell()


	# Push commands to navigate serial connection to hubnode / SHMC
	channel.send("\x07")
	channel.send("0")
	channel.send("\x0d")
	time.sleep(2)


	runningBuffer = ''
	runningBuffer += initialConnection(channel,verbose)

	# Run Commands to get data into buffer output (variable runningBuffer)
	runningBuffer += runCommandIPMI(channel,'fru',verbose)
	runningBuffer += runCommandIPMI(channel,'hpm check',verbose)
	runningBuffer += runCommandIPMI(channel,'lan print',verbose)
	
	result["Board Serial"]=parseSerialOutput("Board Serial",runningBuffer)
	result["Board Product"]=parseSerialOutput("Board Product",runningBuffer)
	result["IP Address"]=parseSerialOutput("IP Address",runningBuffer,"Source")
	result["Chassis Serial"]=parseSerialOutput("Chassis Serial",runningBuffer)
	result["MAC Address"]=parseSerialOutput("MAC Address",runningBuffer)

	# remove duplicates from Chassis Serial response
	result["Chassis Serial"] = list(dict.fromkeys(result["Chassis Serial"]))


	ssh.close()
	print("Connection closed to %s" % serial_IP)

	return result;

# Create and set parser for arguments
parser = argparse.ArgumentParser(description='This script is for Kontron auditing only, used to gather basic information from hubnode serial interfaces.  It is designed to either target provided serial IP addresses or all serial connections in a standard Kontron rack deployment (10 chassis, first 20 IPs used on the TS).')
parser.add_argument('addresses', metavar='Hubnode-IP',default=[], nargs='*', help='Target Serial IP for a Kontron Hubnode')
parser.add_argument('-s', '--start', metavar='Starting-IP', type=str, help='This is a starting IP address, if used this expects the IP address of a terminal server.  Per our current design, this script will then execute tests againsts the next 20 IP addresses')
parser.add_argument('-v', '--verbose', action="store_true", default=False, help='Verbose Output; Print entire SSH buffer to stdout while script is running')
parser.add_argument('-u', dest='user', type=str, help='username')
parser.add_argument('-p', dest='passwd', type=str, help='password - FYI - cleartext passwords are bad')

args = parser.parse_args()
print()
if args.verbose:
	print('Verbose Mode Enabled')
	print('\n',str(args),'\n')

username = ''
password = ''


if args.user:
	username = args.user
else:
	username = input("Serial Terminal SSH Username: ")
if args.passwd:
	password = args.passwd
else:
	password = getpass.getpass()


results = dict()
print()
if args.start != None:
	# create starting IP as appropriate var type
	try:
		starting_ip = ipaddress.ip_address(args.start)
	except ValueError:
		print("ERROR: starting IP argument requires an IP address")
		exit()
	# Iterate through first 20 serial IPs
	for i in range(1,21):
		results[str(starting_ip+i)]=hubnodeCheck(username,password,str(starting_ip+i),22,args.verbose)

else:
	for target in args.addresses:
		results[target]=hubnodeCheck(username,password,target,22,args.verbose)


# Print out results
print()
# If verbose, also print out raw result dict
if args.verbose:
	print(results)
	print()

# print out results formated 'HubnodeS/N'<tab>'ChassisS/N'<tab>'IP'<tab>'
# Note that the outer IF/Else is to split between the two IP input modes
# and the inner if/else statement is to handle output for when chassis serial does not exist (standby hubnode)
if args.start != None:
	starting_ip = ipaddress.ip_address(args.start)
	for i in range(1,21):
		if len(results[str(starting_ip+i)]["Chassis Serial"]) >= 1:
	                #print(results[str(starting_ip+i)]["Board Serial"],",",results[str(starting_ip+i)]["Chassis Serial"],",",results[str(starting_ip+i)]["IP Address"])
			print("%s,%s,%s" % (results[str(starting_ip+i)]["Board Serial"][0],results[str(starting_ip+i)]["Chassis Serial"][0],results[str(starting_ip+i)]["IP Address"][0]))
		else:
	                #print(results[str(starting_ip+i)]["Board Serial"],",N/A,",results[str(starting_ip+i)]["IP Address"])
			print("%s,N/A,%s" % (results[str(starting_ip+i)]["Board Serial"][0],results[str(starting_ip+i)]["IP Address"][0]))
else:
	for target in args.addresses:
		if len(results[target]["Chassis Serial"]) >= 1:
	                #print(results[target]["Board Serial"][0],",",results[target]["Chassis Serial"][0],",",results[target]["IP Address"][0])
	                print("%s,%s,%s" % (results[target]["Board Serial"][0],results[target]["Chassis Serial"][0],results[target]["IP Address"][0]))
		else:
			#print(results[target]["Board Serial"][0],",N/A,",results[target]["IP Address"][0].)
			print("%s,N/A,%s" % (results[target]["Board Serial"][0],results[target]["IP Address"][0]))
print()
