#!/bin/bash
#change Directory to home directory
cd ~

#initialize values
Hosts="hosts.txt" # The file with the IP addresses
Log="output.log"  # Where the results will be stored
cmd="chassis power status"
delay=0
declare -a ipaddresses
debug=0
dc=""
rack=""
dctype="pop"
network=""

# parse options
while getopts ":i:o:hudrsU:P:N:Dm:wS:R:T:" opt; do
  case ${opt} in
    c ) cmd=$OPTARG
      ;;
    S ) dc=${OPTARG^^}
      ;;
    R ) rack=${OPTARG,,}
        rack="r$(printf '%02d' ${rack/"r"/} )"
      ;;
    m ) cmd="sdr entity 10"
      ;;
    i ) Hosts=$OPTARG
      ;;
    o ) Log=$OPTARG
      ;;
    u ) cmd="chassis power on"
      ;;
    d ) cmd="chassis power off"
      ;;
    T ) dctype=${OPTARG,,}
        if  [[ $dctype != "pop" ]] && [[ $dctype != "origin" ]]; then
	  echo "Invalid site type: '$OPTARG'. -t should either be pop or origin."
	  exit 1
        fi
      ;;
    r ) cmd="chassis power cycle"
      ;;
    s ) cmd="chassis power status"
      ;;
    U ) user=$OPTARG
      ;;
    w ) delay=$OPTARG
      ;;
    P ) pass=$OPTARG
      ;;
    N ) network=$OPTARG
      ;;
    D ) debug=1
      ;;
    h ) printf "./massipmitool.sh -i <path to file of host list> -l <path to log file> -[udroslPD]"
      exit 0
      ;;
    \? ) echo "Invalid option: $OPTARG" 1>&2
      exit 1
      ;;
    : )  echo "Invalid option: $OPTARG requires an argument" 1>&2
      exit 1
      ;;
  esac
done
shift $((OPTIND -1))

if  [ ! -z "${network}" ] || [ ! -z "${dc}" ]; then
  if [ ! -z $dc ] && [ ! -z $rack ] && [ ! -z $dctype ]; then
    read -p "Infoblox Username: " ibuser
    read -s -p "Infoblox Password: " ibpass
    echo""
    echo "Grabbing network from Infoblox"
    ibcred=$ibuser:$ibpass
    if [[ $dctype == "pop" ]]; then
      commentstr="$dc - $rack Management"
    elif [[ $dctype == "origin" ]]; then
      commentstr="$rack-ma01-ma02.${dc,,}"
    fi
    network=$(curl -k -u "$ibcred" -X GET 'https://infoblox.live-video.a2z.com/wapi/v2.11/network' -d comment="$commentstr" 2>/dev/null | jq -r '.[]|.network')
  fi
  printf "WARNING!!\nThis option sends command to entire network!\n"
  echo "Send command to $network?"
  select yn in "Yes" "No"; do
  case $yn in
    Yes ) echo "You have chosen to continue. It's too late to turn back now.";break;;
    No ) echo "You have chosen to stop here. Hope to see you again.";exit;;
  esac
  done
  prefix=$(ipcalc $network -p | cut -d "=" -f 2)
  maxip=$(ipcalc $network --maxaddr | cut -d "=" -f 2)
  minip=$(ipcalc $network --minaddr | cut -d "=" -f 2)
  if [ "${prefix}" = 24 ]; then
    minip=$(echo $minip | cut -d '.' -f 1).$(echo $minip | cut -d '.' -f 2).$(echo $minip | cut -d '.' -f 3).50
    maxip=$(echo $maxip | cut -d '.' -f 1).$(echo $maxip | cut -d '.' -f 2).$(echo $maxip | cut -d '.' -f 3).194
  elif [ "${prefix}" = 25 ]; then
    minip=$(echo $minip | cut -d '.' -f 1).$(echo $minip | cut -d '.' -f 2).$(echo $minip | cut -d '.' -f 3).140
    maxip=$(echo $maxip | cut -d '.' -f 1).$(echo $maxip | cut -d '.' -f 2).$(echo $maxip | cut -d '.' -f 3).235
  else
    echo "Prefix is not /24 or /25!" 1>&2
    exit 1
  fi
  printf "Prefix: %d\nMin IP: %s\nMax IP: %s\n" $prefix $minip $maxip
  echo "Checking which hosts are alive..."
  alivestr=$(fping -a -g $minip $maxip 2>/dev/null)
  alive=($alivestr)
  echo "Found ${#alive[@]} alive hosts."
fi

#check if host file exists, reads it into array
if [ "${#alive[@]}" = 0 ] && [[ ! -f ${Hosts} ]]; then
   echo $(pwd)\/$Hosts" does not exist!" 1>&2
   exit 1
elif [ "${#alive[@]}" = 0 ] && [ -f "$Hosts" ]; then
   echo "Checking which hosts are alive..."
   alivestr=$(fping -a < $Hosts 2>/dev/null )
   alive=($alivestr)
   echo "Found ${#alive[@]} alive hosts."
fi

#main loop
for b in "${alive[@]}"; do
   if [ "$debug" = 1 ]; then
      echo "Testing against ${b} command ${cmd}"
   else
      echo "Sending ${b} command ${cmd}" | tee -a $Log 2>&1
      # The -c 1 means send one packet, and the -t 1 means a 1 second timeout
      ipmitool -I lanplus -H ${b} -U $user -P $pass $cmd | tee -a $log 2>&1
   fi
done
