import sys, subprocess, threading, time, os, re
import mysql.connector
from pysnmp.entity.rfc3413.oneliner import cmdgen
tempArray={}

class snapshotSNMP(object):
	responseDict = {} # Populated while we are running
	hosts = []
	thread_count = 4
	ping_success = False
	lock = threading.Lock()

	def runCommand(self, host):
		self.responseDict[host] = {}
		if os.system("ping -c 1 " + host) == 0:
			self.ping_success = True
		else:
			if os.system("ping -c 4 " + host) == 0:
				self.ping_success = True
			else:
				self.ping_success = False
			#self.ping_success = False
		
		if self.ping_success == False:
			self.responseDict[host] = {'ping':False}
			
		if self.ping_success == True:
			self.responseDict[host] = {'ping':True}
			
			# instantiate snmp command class
			cmdGen = cmdgen.CommandGenerator()
			# run snmp command
			errorIndication, errorStatus, errorIndex, varBinds = cmdGen.getCmd(
					cmdgen.CommunityData('jtv'),
					cmdgen.UdpTransportTarget((host, 161)),
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.1',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.2',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.3',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.4',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.5',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.6',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.7',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.8',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.9',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.10',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.11',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.12',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.13',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.14',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.15',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.16',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.17',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.18',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.19',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.20',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.21',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.22',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.23',
					'.1.3.6.1.4.1.1718.3.2.3.1.16.1.1.24',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.1',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.2',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.3',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.4',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.5',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.6',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.7',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.8',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.9',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.10',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.11',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.12',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.13',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.14',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.15',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.16',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.17',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.18',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.19',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.20',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.21',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.22',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.23',
					'.1.3.6.1.4.1.1718.3.2.3.1.3.1.1.24',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.1',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.2',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.3',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.4',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.5',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.6',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.7',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.8',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.9',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.10',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.11',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.12',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.13',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.14',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.15',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.16',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.17',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.18',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.19',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.20',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.21',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.22',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.23',
					'.1.3.6.1.4.1.1718.3.2.3.1.13.1.1.24'
				)
			status=0
			if errorIndication:
				# add error to output dict
				self.responseDict[host]['SNMP Error']=({'ERROR':"Query Error",'message':str(errorIndication)})
			else:
				if errorStatus:
					# add error to output dict
					self.responseDict[host]['SNMP Error']=({'ERROR':"Query Error",'message':('%s at %s' % (
						errorStatus.prettyPrint(),
						errorIndex and varBinds[int(errorIndex)-1] or '?'
					))})
				else:
					# add OID key and result to output dict
					for key, val in varBinds:
						tempKey = ""
						if re.match(r'^1.3.6.1.4.1.1718.3.2.3.1.13',str(key)):
							tempKey="outletVoltage-"+str(str(key).split('.')[-1])
						elif re.match(r'^1.3.6.1.4.1.1718.3.2.3.1.16',str(key)):
							tempKey="outletPowerFactor-"+str(str(key).split('.')[-1])
						elif re.match(r'^1.3.6.1.4.1.1718.3.2.3.1.3',str(key)):
							tempKey="outletName-"+str(str(key).split('.')[-1])
						elif re.match(r'^1.3.6.1.4.1.1718.3.2.3.1.2',str(key)):
							tempKey="outletID-"+str(str(key).split('.')[-1])
						else:
							tempKey=key
						self.responseDict[host][str(tempKey)]=str(val)

	def popQueue(self):
		hostname = None
		self.lock.acquire()
		if self.hosts:
				hostname = self.hosts.pop().rstrip()
		self.lock.release()
		return hostname

	def deQueue(self):
		while True:
			hostname = self.popQueue()
			if not hostname:
				return None
			self.runCommand(hostname)

	def start(self):
		threads = []
		for i in range(self.thread_count):
			# add threads to the thread array
			t = threading.Thread(target=self.deQueue)
			t.start()
			threads.append(t)
		# Wait for all threads
		[ t.join() for t in threads ]
		return self.responseDict

if __name__=='__main__':

	#Check for arguments
	if len(sys.argv) != 3:
		print "Two arguments expected"
		exit()
		
	#Open first arugment as read-only input file
	input_file = open(sys.argv[1],"r")
	
	# instantiate class
	run = snapshotSNMP()
	run.thread_count = 36
	#run.hosts = cdu_list_20160418
	run.hosts = input_file.readlines()
	#run.hosts = ['pdu27b.sfo01.justin.tv']
	
	# start threaded processes
	final=run.start()
	
	#Open second argument as write-only output file
	output_file = open(sys.argv[2],"w")
	
	#print dict/json style result to output file
	output_file.write(str(final))
	
	# print result
	#print "\n\n\n\n"
	#print final
	print "\n\n\n\n"
	for host, value in final.iteritems():
		if value['ping']:
			print "Host "+host+" is up"			
		else:
			print "Host "+host+" is down"
			
	#for key, value in final['pdu27b.sfo01.justin.tv'].iteritems():
	#	print str(key)+" - "+str(value)

	possible_ct_issues = []
	for host, info in final.iteritems():
		tempFound = False
		if info['ping']:
			for key, value in info.iteritems():
				if re.match(r'^outletVoltage',str(key)) and value == '0':
					tempFound = True
				if re.match(r'^outletVoltage',str(key)) and value == '-1':
					tempFound = True
		if tempFound:
			possible_ct_issues.append(host)
					
	print "\n\n\n\n"
	print "Hosts that may have CT failures:"
	for host in possible_ct_issues:
		print host
		
		
		
		
		
		
		
		
		
		
#serverTech serverTech	1.3.6.1.4.1.1718
#sentry3 sentry3	1.3.6.1.4.1.1718.3
#systemGroup systemGroup	1.3.6.1.4.1.1718.3.1
#systemVersion systemVersion	1.3.6.1.4.1.1718.3.1.1
#systemPowerFactor systemPowerFactor	1.3.6.1.4.1.1718.3.1.10
#systemFeatures systemFeatures	1.3.6.1.4.1.1718.3.1.11
#systemFeatureKey systemFeatureKey	1.3.6.1.4.1.1718.3.1.12
#systemOutletSeqInterval systemOutletSeqInterval	1.3.6.1.4.1.1718.3.1.13
#systemOutletRebootDelay systemOutletRebootDelay	1.3.6.1.4.1.1718.3.1.14
#systemConfigModifiedCount systemConfigModifiedCount	1.3.6.1.4.1.1718.3.1.15
#systemNICSerialNumber systemNICSerialNumber	1.3.6.1.4.1.1718.3.1.2
#systemLocation systemLocation	1.3.6.1.4.1.1718.3.1.3
#systemTowerCount systemTowerCount	1.3.6.1.4.1.1718.3.1.4
#systemEnvMonCount systemEnvMonCount	1.3.6.1.4.1.1718.3.1.5
#systemTotalPower systemTotalPower	1.3.6.1.4.1.1718.3.1.6
#systemArea systemArea	1.3.6.1.4.1.1718.3.1.7
#systemWattsPerAreaUnit systemWattsPerAreaUnit	1.3.6.1.4.1.1718.3.1.8
#systemAreaUnit systemAreaUnit	1.3.6.1.4.1.1718.3.1.9
#sentry3Traps sentry3Traps	1.3.6.1.4.1.1718.3.100
#events events	1.3.6.1.4.1.1718.3.100.0
#towerStatusEvent towerStatusEvent	1.3.6.1.4.1.1718.3.100.0.1
#tempHumidSensorStatusEvent tempHumidSensorStatusEvent	1.3.6.1.4.1.1718.3.100.0.10
#tempHumidSensorTempEvent tempHumidSensorTempEvent	1.3.6.1.4.1.1718.3.100.0.11
#tempHumidSensorHumidEvent tempHumidSensorHumidEvent	1.3.6.1.4.1.1718.3.100.0.12
#contactClosureEvent contactClosureEvent	1.3.6.1.4.1.1718.3.100.0.13
#branchStatusEvent branchStatusEvent	1.3.6.1.4.1.1718.3.100.0.14
#branchLoadEvent branchLoadEvent	1.3.6.1.4.1.1718.3.100.0.15
#infeedStatusEvent infeedStatusEvent	1.3.6.1.4.1.1718.3.100.0.2
#infeedLoadEvent infeedLoadEvent	1.3.6.1.4.1.1718.3.100.0.3
#outletStatusEvent outletStatusEvent	1.3.6.1.4.1.1718.3.100.0.4
#outletLoadEvent outletLoadEvent	1.3.6.1.4.1.1718.3.100.0.5
#outletChangeEvent outletChangeEvent	1.3.6.1.4.1.1718.3.100.0.6
#envMonStatusEvent envMonStatusEvent	1.3.6.1.4.1.1718.3.100.0.7
#envMonWaterSensorEvent envMonWaterSensorEvent	1.3.6.1.4.1.1718.3.100.0.8
#envMonADCEvent envMonADCEvent	1.3.6.1.4.1.1718.3.100.0.9
#systemTables systemTables	1.3.6.1.4.1.1718.3.2
#towerTable towerTable	1.3.6.1.4.1.1718.3.2.1
#towerEntry towerEntry	1.3.6.1.4.1.1718.3.2.1.1
#towerIndex towerIndex	1.3.6.1.4.1.1718.3.2.1.1.1
#towerVACapacityUsed towerVACapacityUsed	1.3.6.1.4.1.1718.3.2.1.1.10
#towerActivePower towerActivePower	1.3.6.1.4.1.1718.3.2.1.1.11
#towerApparentPower towerApparentPower	1.3.6.1.4.1.1718.3.2.1.1.12
#towerPowerFactor towerPowerFactor	1.3.6.1.4.1.1718.3.2.1.1.13
#towerEnergy towerEnergy	1.3.6.1.4.1.1718.3.2.1.1.14
#towerLineFrequency towerLineFrequency	1.3.6.1.4.1.1718.3.2.1.1.15
#towerID towerID	1.3.6.1.4.1.1718.3.2.1.1.2
#towerName towerName	1.3.6.1.4.1.1718.3.2.1.1.3
#towerStatus towerStatus	1.3.6.1.4.1.1718.3.2.1.1.4
#towerInfeedCount towerInfeedCount	1.3.6.1.4.1.1718.3.2.1.1.5
#towerProductSN towerProductSN	1.3.6.1.4.1.1718.3.2.1.1.6
#towerModelNumber towerModelNumber	1.3.6.1.4.1.1718.3.2.1.1.7
#towerCapabilities towerCapabilities	1.3.6.1.4.1.1718.3.2.1.1.8
#towerVACapacity towerVACapacity	1.3.6.1.4.1.1718.3.2.1.1.9
#infeedTable infeedTable	1.3.6.1.4.1.1718.3.2.2
#infeedEntry infeedEntry	1.3.6.1.4.1.1718.3.2.2.1
#infeedIndex infeedIndex	1.3.6.1.4.1.1718.3.2.2.1.1
#infeedCapacity infeedCapacity	1.3.6.1.4.1.1718.3.2.2.1.10
#infeedVoltage infeedVoltage	1.3.6.1.4.1.1718.3.2.2.1.11
#infeedPower infeedPower	1.3.6.1.4.1.1718.3.2.2.1.12
#infeedApparentPower infeedApparentPower	1.3.6.1.4.1.1718.3.2.2.1.13
#infeedPowerFactor infeedPowerFactor	1.3.6.1.4.1.1718.3.2.2.1.14
#infeedCrestFactor infeedCrestFactor	1.3.6.1.4.1.1718.3.2.2.1.15
#infeedEnergy infeedEnergy	1.3.6.1.4.1.1718.3.2.2.1.16
#infeedReactance infeedReactance	1.3.6.1.4.1.1718.3.2.2.1.17
#infeedPhaseVoltage infeedPhaseVoltage	1.3.6.1.4.1.1718.3.2.2.1.18
#infeedPhaseCurrent infeedPhaseCurrent	1.3.6.1.4.1.1718.3.2.2.1.19
#infeedID infeedID	1.3.6.1.4.1.1718.3.2.2.1.2
#infeedCapacityUsed infeedCapacityUsed	1.3.6.1.4.1.1718.3.2.2.1.20
#infeedLineID infeedLineID	1.3.6.1.4.1.1718.3.2.2.1.21
#infeedLineToLineID infeedLineToLineID	1.3.6.1.4.1.1718.3.2.2.1.22
#infeedPhaseID infeedPhaseID	1.3.6.1.4.1.1718.3.2.2.1.23
#infeedVACapacity infeedVACapacity	1.3.6.1.4.1.1718.3.2.2.1.24
#infeedVACapacityUsed infeedVACapacityUsed	1.3.6.1.4.1.1718.3.2.2.1.25
#infeedName infeedName	1.3.6.1.4.1.1718.3.2.2.1.3
#infeedCapabilities infeedCapabilities	1.3.6.1.4.1.1718.3.2.2.1.4
#infeedStatus infeedStatus	1.3.6.1.4.1.1718.3.2.2.1.5
#infeedLoadStatus infeedLoadStatus	1.3.6.1.4.1.1718.3.2.2.1.6
#infeedLoadValue infeedLoadValue	1.3.6.1.4.1.1718.3.2.2.1.7
#infeedLoadHighThresh infeedLoadHighThresh	1.3.6.1.4.1.1718.3.2.2.1.8
#infeedOutletCount infeedOutletCount	1.3.6.1.4.1.1718.3.2.2.1.9
#outletTable outletTable	1.3.6.1.4.1.1718.3.2.3
#outletEntry outletEntry	1.3.6.1.4.1.1718.3.2.3.1
#outletIndex outletIndex	1.3.6.1.4.1.1718.3.2.3.1.1
#outletControlState outletControlState	1.3.6.1.4.1.1718.3.2.3.1.10
#outletControlAction outletControlAction	1.3.6.1.4.1.1718.3.2.3.1.11
#outletCapacity outletCapacity	1.3.6.1.4.1.1718.3.2.3.1.12
#outletVoltage outletVoltage	1.3.6.1.4.1.1718.3.2.3.1.13
#outletPower outletPower	1.3.6.1.4.1.1718.3.2.3.1.14
#outletApparentPower outletApparentPower	1.3.6.1.4.1.1718.3.2.3.1.15
#outletPowerFactor outletPowerFactor	1.3.6.1.4.1.1718.3.2.3.1.16
#outletCrestFactor outletCrestFactor	1.3.6.1.4.1.1718.3.2.3.1.17
#outletEnergy outletEnergy	1.3.6.1.4.1.1718.3.2.3.1.18
#outletWakeupState outletWakeupState	1.3.6.1.4.1.1718.3.2.3.1.19
#outletID outletID	1.3.6.1.4.1.1718.3.2.3.1.2
#outletPostOnDelay outletPostOnDelay	1.3.6.1.4.1.1718.3.2.3.1.20
#outletName outletName	1.3.6.1.4.1.1718.3.2.3.1.3
#outletCapabilities outletCapabilities	1.3.6.1.4.1.1718.3.2.3.1.4
#outletStatus outletStatus	1.3.6.1.4.1.1718.3.2.3.1.5
#outletLoadStatus outletLoadStatus	1.3.6.1.4.1.1718.3.2.3.1.6
#outletLoadValue outletLoadValue	1.3.6.1.4.1.1718.3.2.3.1.7
#outletLoadLowThresh outletLoadLowThresh	1.3.6.1.4.1.1718.3.2.3.1.8
#outletLoadHighThresh outletLoadHighThresh	1.3.6.1.4.1.1718.3.2.3.1.9
#envMonTable envMonTable	1.3.6.1.4.1.1718.3.2.4
#envMonEntry envMonEntry	1.3.6.1.4.1.1718.3.2.4.1
#envMonIndex envMonIndex	1.3.6.1.4.1.1718.3.2.4.1.1
#envMonADCLowThresh envMonADCLowThresh	1.3.6.1.4.1.1718.3.2.4.1.10
#envMonADCHighThresh envMonADCHighThresh	1.3.6.1.4.1.1718.3.2.4.1.11
#envMonTempHumidSensorCount envMonTempHumidSensorCount	1.3.6.1.4.1.1718.3.2.4.1.12
#envMonContactClosureCount envMonContactClosureCount	1.3.6.1.4.1.1718.3.2.4.1.13
#envMonID envMonID	1.3.6.1.4.1.1718.3.2.4.1.2
#envMonName envMonName	1.3.6.1.4.1.1718.3.2.4.1.3
#envMonStatus envMonStatus	1.3.6.1.4.1.1718.3.2.4.1.4
#envMonWaterSensorName envMonWaterSensorName	1.3.6.1.4.1.1718.3.2.4.1.5
#envMonWaterSensorStatus envMonWaterSensorStatus	1.3.6.1.4.1.1718.3.2.4.1.6
#envMonADCName envMonADCName	1.3.6.1.4.1.1718.3.2.4.1.7
#envMonADCStatus envMonADCStatus	1.3.6.1.4.1.1718.3.2.4.1.8
#envMonADCCount envMonADCCount	1.3.6.1.4.1.1718.3.2.4.1.9
#tempHumidSensorTable tempHumidSensorTable	1.3.6.1.4.1.1718.3.2.5
#tempHumidSensorEntry tempHumidSensorEntry	1.3.6.1.4.1.1718.3.2.5.1
#tempHumidSensorIndex tempHumidSensorIndex	1.3.6.1.4.1.1718.3.2.5.1.1
#tempHumidSensorHumidValue tempHumidSensorHumidValue	1.3.6.1.4.1.1718.3.2.5.1.10
#tempHumidSensorHumidLowThresh tempHumidSensorHumidLowThresh	1.3.6.1.4.1.1718.3.2.5.1.11
#tempHumidSensorHumidHighThresh tempHumidSensorHumidHighThresh	1.3.6.1.4.1.1718.3.2.5.1.12
#tempHumidSensorTempScale tempHumidSensorTempScale	1.3.6.1.4.1.1718.3.2.5.1.13
#tempHumidSensorTempRecDelta tempHumidSensorTempRecDelta	1.3.6.1.4.1.1718.3.2.5.1.14
#tempHumidSensorID tempHumidSensorID	1.3.6.1.4.1.1718.3.2.5.1.2
#tempHumidSensorName tempHumidSensorName	1.3.6.1.4.1.1718.3.2.5.1.3
#tempHumidSensorStatus tempHumidSensorStatus	1.3.6.1.4.1.1718.3.2.5.1.4
#tempHumidSensorTempStatus tempHumidSensorTempStatus	1.3.6.1.4.1.1718.3.2.5.1.5
#tempHumidSensorTempValue tempHumidSensorTempValue	1.3.6.1.4.1.1718.3.2.5.1.6
#tempHumidSensorTempLowThresh tempHumidSensorTempLowThresh	1.3.6.1.4.1.1718.3.2.5.1.7
#tempHumidSensorTempHighThresh tempHumidSensorTempHighThresh	1.3.6.1.4.1.1718.3.2.5.1.8
#tempHumidSensorHumidStatus tempHumidSensorHumidStatus	1.3.6.1.4.1.1718.3.2.5.1.9
#contactClosureTable contactClosureTable	1.3.6.1.4.1.1718.3.2.6
#contactClosureEntry contactClosureEntry	1.3.6.1.4.1.1718.3.2.6.1
#contactClosureIndex contactClosureIndex	1.3.6.1.4.1.1718.3.2.6.1.1
#contactClosureID contactClosureID	1.3.6.1.4.1.1718.3.2.6.1.2
#contactClosureName contactClosureName	1.3.6.1.4.1.1718.3.2.6.1.3
#contactClosureStatus contactClosureStatus	1.3.6.1.4.1.1718.3.2.6.1.4
#branchTable branchTable	1.3.6.1.4.1.1718.3.2.7
#branchEntry branchEntry	1.3.6.1.4.1.1718.3.2.7.1
#branchIndex branchIndex	1.3.6.1.4.1.1718.3.2.7.1.1
#branchID branchID	1.3.6.1.4.1.1718.3.2.7.1.2
#branchName branchName	1.3.6.1.4.1.1718.3.2.7.1.3
#branchCapabilities branchCapabilities	1.3.6.1.4.1.1718.3.2.7.1.4
#branchStatus branchStatus	1.3.6.1.4.1.1718.3.2.7.1.5
#branchLoadStatus branchLoadStatus	1.3.6.1.4.1.1718.3.2.7.1.6
#branchLoadValue branchLoadValue	1.3.6.1.4.1.1718.3.2.7.1.7
#branchLoadHighThresh branchLoadHighThresh	1.3.6.1.4.1.1718.3.2.7.1.8
#branchCapacity branchCapacity	1.3.6.1.4.1.1718.3.2.7.1.9
