# This is where your tfstate file will be stored.  This should meet the
# requirements of your team.
terraform {
  backend "s3" {
    # Match this in your .aws/credentials file
    profile = "twitch-datacenter-ops-aws" 
    bucket = "twitch-datacenter-ops-aws"
    key    = "tfstate/development/dco-syslog/terraform.tfstate"
    region = "us-west-2"
  }
}

# Rename the profile to match the account where you want to stand up
# this service.
provider "aws" {
    profile = "twitch-datacenter-ops-aws"
    region  = "us-west-2"
}

# Customize these variables.
variable "service"     {default = "dco-syslog"}
variable "environment" {default = "dev"}
# Change this in the prod version
variable "owner"       {default = "ryawilki@justin.tv"}
# This too
variable "owner_email" {default = "ryawilki@justin.tv"}

# Maybe customize these, too
data "aws_security_group" "sg" {
    name = "twitch_subnets"
    # This will need to be set if you have more than one VPC with a
    # twitch_subnets security group in it
    #vpc = "vpc-81db91e7"

}

# And possibly this if you have differently named subnets.  These work for most
# accounts at Twitch.
data "aws_subnet" "subnet_a" { tags { "Name" = "Private - us-west-2a" } }
data "aws_subnet" "subnet_b" { tags { "Name" = "Private - us-west-2b" } }
data "aws_subnet" "subnet_c" { tags { "Name" = "Private - us-west-2c" } }

# You shouldn't need to customize these unless you need functionality from `Advanced Usage`
# To get started, you can leave these alone and come back to it in the future.
module "syslog" {
    source = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/team-syslog.git?ref=v0.1.4"

    environment = "${var.environment}"
    security_groups = ["${data.aws_security_group.sg.id}"]
    subnet_ids = ["${data.aws_subnet.subnet_a.id}", "${data.aws_subnet.subnet_b.id}", "${data.aws_subnet.subnet_c.id}"]
    service = "${var.service}"
    owner = "${var.owner}"
    owner_email = "${var.owner_email}"
}

output "elb_fqdn"             {value = "${module.syslog.elb_fqdn}"}
output "log_bucket"           {value = "${module.syslog.log_bucket}"}
output "queue_account_number" {value = "${module.syslog.queue_account_number}"}
output "s3_bucket_name"       {value = "${module.syslog.s3_bucket_name}"}

