
This document provides a brief explanation about each step involved in Kontron rack buildout, which has encapsulated in the shell script in this repository. These steps can be executed only after pre-bootstrapping of those racks which does involve the following 

- Installation of vendor-provided build sheets into our store.
- Provision for fixed addresses in the Infoblox based on build sheet data.

Detailed steps are documented [here](https://docs.google.com/document/d/1u95JhZ-lwA9PSjgbKxjirt_LEZnCyCecXgAaprnDfwE/edit?usp=sharing)

Please open a DCO ticket for every bootstrapping process and create and attach a blocking ticket to this main ticket for every interruption which requires support from external teams.


### Defination of success and handover steps

DCO will be owner for execution of these bootstrapping steps. Upon successful execution of all following boostrapping steps, you should be able to see following 

-   provisioner rack report will. start showing all 180 hosts` https://provisioner.internal.justin.tv/web/racks/r<rack number>.<pop>` 
- all checks should in following steps with empty `errors[]` array
  - `kon_dco_step5.sh`
  - `kon_dco_step11.sh`
  - `kon_dco_step13.sh`
  - `kon_dco_step14.sh`



As a part of handoff to video operations, please open a jira in VIDOPS queue with following attachments 

- provisioner CSV report provided by the link below` https://provisioner.internal.justin.tv/web/racks/r<rack number>.<pop>` 
- output of the execution of steps `kon_dco_step5.sh`, `kon_dco_step11.sh`, `kon_dco_step13.sh`, `kon_dco_step14.sh` which as empty `errors[]`. 

NOTE:Please make sure that you do not share any credentials while uploading bootstrapping logs. It is better to use logs created by a script itself instead of copy pasting from console.  



### Konmari Rack Bootstrap
Each step represented by single shell script named `kon_dco_step<step number>.sh` encapsulating execution of several tasks. These steps has to be carried out in the following order

```
- Step 1
- Step 2
- Step 3
- Step 4
- Step 5
- Step 6
- Step 7
- Step 8
- Step 2 (repeat for sanity check)
- Step 4 (repeat for sanity check)
- Step 5 (repeat for sanity check and make sure there are no chassis serial number mismatches in the output)
- Step 9
- Step 10
- Step 11
- Step 12
- Step 13
- Step 14
- Step 15
```



#### Step 1: Kontron rack bootstrapping checklist


- Make sure you are running these commands from the jumphost in the screen session so you do not need to be glued to your laptop entire time during bootstrapping.

- Create a google doc to store all the output the commands.

-  Install relevent tools with following commands
```
        apt-get install kontron-infratools kontron-ipmitool
```

- Setup relevent credentials as an environment variable which are shared through 1pass Konmari vault.

```
        # Powerservice password used by IPMI service
        export  POWERSERVICE_PASS=XXXXXXXXXXXX


        # Guardian OAuth token used by various workflows
        # Visit https://oauth-broker.prod.vidops.internal.justin.tv/config to generate a token
        export OAUTH_BROKER_TOKEN=XXXXXXXXXXXXXXXXXXXXXXXXXX


        # Setup Kontron IPMI password
        export KONTRONAPI_PASS=XXXXXXXXXXXXXXXXXXXXXXXXXX
        

        # Setup IPMI Password
        export IPMI_PASS=XXXXXXXXXX
```

- For successful execution of these steps, make sure successful execution of every step before moving forward to the next step.

- Grab a coffee



#### Step 2: Look for existance for DNS entries pointing to BMCs of the rack. 

These DNS entries must exist in order to conduct rest of the steps.

```
wdjhn@dcops-3d3a63:~$ ./kon_dco_step2.sh --rack r423 --pop sjc02
mgmt-r423.ru01.s1.sjc02.justin.tv 10.24.113.52
mgmt-r423.ru01.s2.sjc02.justin.tv 10.24.113.53
mgmt-r423.ru01.s3.sjc02.justin.tv 10.24.113.54
mgmt-r423.ru01.s4.sjc02.justin.tv 10.24.113.55
mgmt-r423.ru01.s5.sjc02.justin.tv 10.24.113.56
mgmt-r423.ru01.s6.sjc02.justin.tv 10.24.113.57
mgmt-r423.ru01.s7.sjc02.justin.tv 10.24.113.58
mgmt-r423.ru01.s8.sjc02.justin.tv 10.24.113.59
mgmt-r423.ru01.s9.sjc02.justin.tv 10.24.113.60
mgmt-r423.ru03.h1.sjc02.justin.tv 10.24.113.61
mgmt-r423.ru03.h2.sjc02.justin.tv 10.24.113.62
mgmt-r423.ru03.s1.sjc02.justin.tv 10.24.113.63
mgmt-r423.ru03.s2.sjc02.justin.tv 10.24.113.64
mgmt-r423.ru03.s3.sjc02.justin.tv 10.24.113.65
mgmt-r423.ru03.s4.sjc02.justin.tv 10.24.113.66
mgmt-r423.ru03.s5.sjc02.justin.tv 10.24.113.67
mgmt-r423.ru03.s6.sjc02.justin.tv 10.24.113.68
mgmt-r423.ru03.s7.sjc02.justin.tv 10.24.113.69
mgmt-r423.ru03.s8.sjc02.justin.tv 10.24.113.70
mgmt-r423.ru03.s9.sjc02.justin.tv 10.24.113.71
mgmt-r423.ru07.h1.sjc02.justin.tv 10.24.113.72
mgmt-r423.ru07.h2.sjc02.justin.tv 10.24.113.73
mgmt-r423.ru07.s1.sjc02.justin.tv 10.24.113.74
mgmt-r423.ru07.s2.sjc02.justin.tv 10.24.113.75
mgmt-r423.ru07.s3.sjc02.justin.tv 10.24.113.76
mgmt-r423.ru07.s4.sjc02.justin.tv 10.24.113.77
mgmt-r423.ru07.s5.sjc02.justin.tv 10.24.113.78

```



#### Step 3: Deprecated

Move on to Step 4

#### Step 4: Align the hubnodes

Align the hubnodes where hubnode in the first slot is the primary. All remaining automation runs on this assumption.

```
wdjhn@dcops-3d3a63:~$ ./kon_dco_step4.sh --rack r423 --pop sjc02
Host forcing to switch alighment
mgmt-r423.ru03.h2.sjc02.justin.tv forcing to switch alighment
mgmt-r423.ru07.h2.sjc02.justin.tv forcing to switch alighment
mgmt-r423.ru09.h2.sjc02.justin.tv forcing to switch alighment
mgmt-r423.ru13.h2.sjc02.justin.tv forcing to switch alighment
mgmt-r423.ru15.h2.sjc02.justin.tv forcing to switch alighment
mgmt-r423.ru19.h2.sjc02.justin.tv forcing to switch alighment
mgmt-r423.ru21.h2.sjc02.justin.tv forcing to switch alighment
mgmt-r423.ru25.h2.sjc02.justin.tv forcing to switch alighment
mgmt-r423.ru27.h2.sjc02.justin.tv forcing to switch alighment
```


#### Step 5: Buildsheet verification

Verify IPMI fru data against vendor provided buildsheet data using workflows. These workflow based verification provide JSON output. In the case of failure, output will have `errors[]`, which you must report to Vidops team for further investigation. During successful execution, `errors[]` are absent.

NOTE: If you are running this on the brand new chassis then you might see errors during first execution of Step 5 which will get fixed after firmware upgarde as a part of Step 6,7 and 8.  In that case, please re-run Step 4 and 5 after successful completion of Step 8 before moving forward with Step 9.

```
wdjhn@dcops-3d3a63:~$ ./kon_dco_step5.sh --rack r423 --pop sjc02
sjc02 r423 ru07 buildsheet_service validation sjc02 r423 ru09 buildsheet_service validation sjc02 r423 ru01 buildsheet_service validation sjc02 r423 ru03 buildsheet_service validation sjc02 r423 ru13 buildsheet_service validation sjc02 r423 ru21 buildsheet_service validation sjc02 r423 ru15 buildsheet_service validation sjc02 r423 ru19 buildsheet_service validation sjc02 r423 ru27 buildsheet_service validation sjc02 r423 ru25 buildsheet_service validation ...............................................................................................................................{
  "execution_arn": "arn:aws:states:us-west-2:277437172290:execution:machinebot_buildsheet_service_production_fad607eeca30c261:50eb3d21-9580-4116-be76-cc8b655694b0",
  "validation_request": {
    "hardware_location": {
      "pop": "sjc02",
      "rack": "r423",
      "rackUnit": 19
    },
    "workflow_name": "buildsheet_service",
    "hardware_type": "kontron"
  },
  "status": "SUCCEEDED",
  "start_date": "2019-12-04T23:01:23Z",
  "stop_date": "2019-12-04T23:13:02Z",

<snip/>
```

More about this [workflow](https://docs.google.com/document/d/1Pj2Uzcf1fr9JZ9f5Q8kc2L6FN3AzYZ0rMvVOxJYQN2k/edit#heading=h.9doksxx3izcm).



#### Step 6: Prepare Kontron chassis for firmware upgarde

This step will upload latest approved Kontron firmware to the all chassis in the rack through HTTP APIs. Prepend commad with `KONTRONAPI_PASS='admin'` while running on the brand new chassis which has not gone through password resets (Step 10) yet. 

```
wdjhn@dcops-3d3a63:~$ KONTRONAPI_PASS='admin'  ./kon_dco_step6.sh --rack r423 --pop sjc02


Reusing /tmp/kon_fw_upload/symkloud-bundle-current.zip after validating checksum
Reusing /tmp/kon_fw_upload/symkloud-bundle-current.zip after validating checksum
Uploading to hub node mgmt-r423.ru25.h1.sjc02.justin.tv, it will take a few minutes to return once upload has completed.
Reusing /tmp/kon_fw_upload/symkloud-bundle-current.zip after validating checksum
  % Total    % Received % Xferd  Average Speed   Time    Time     Time  Current
                                 Dload  Upload   Total   Spent    Left  Speed
  0     0    0     0    0     0      0      0 --:--:-- --:--:-- --:--:--     0Uploading to hub node mgmt-r423.ru19.h1.sjc02.justin.tv, it will take a few minutes to return once upload has completed.
  % Total    % Received % Xferd  Average Speed   Time    Time     Time  Current
                                 Dload  Upload   Total   Spent    Left  Speed
  0     0    0     0    0     0      0      0 --:--:-- --:--:-- --:--:--     0Reusing /tmp/kon_fw_upload/symkloud-bundle-current.zip after validating checksum
Uploading to hub node mgmt-r423.ru15.h1.sjc02.justin.tv, it will take a few minutes to return once upload has completed.
  % Total    % Received % Xferd  Average Speed   Time    Time     Time  Current
                                 Dload  Upload   Total   Spent    Left  Speed
  0     0    0     0    0     0      0      0 --:--:-- --:--:-- --:--:--     0Reusing /tmp/kon_fw_upload/symkloud-bundle-current.zip after validating checksum
Reusing /tmp/kon_fw_upload/symkloud-bundle-current.zip after validating checksum
Reusing /tmp/kon_fw_upload/symkloud-bundle-current.zip after validating checksum
Uploading to hub node mgmt-r423.ru09.h1.sjc02.justin.tv, it will take a few minutes to return once upload has completed.
Reusing /tmp/kon_fw_upload/symkloud-bundle-current.zip after validating checksum
  % Total    % Received % Xferd  Average Speed   Time    Time     Time  Current
                                 Dload  Upload   Total   Spent    Left  Speed
  0     0    0     0    0     0      0      0 --:--:-- --:--:-- --:--:--


<snip/>
```

#### Step 7: Trigger firmware upgrade
This step will trigger firmware upgrade on all the chassis in the rack. It triggers through non-blocking REST API call and we have to wait for upgrade to finish which is happening in the background before moving on to next step. Give 3 to 4 hours for firmware upgrade to complete before moving forward with Step 8. 

Smilar to step 6, prepend commad with `KONTRONAPI_PASS='admin'` while running on the brand new chassis which has not gone through password resets (Step 10) yet. In this case, also run Step 4 and 5 again for the sanity check before moving to Step 8.


```
wdjhn@dcops-3d3a63:~$ KONTRONAPI_PASS='admin'  ./kon_dco_step7.sh --rack r423 --pop sjc02

Update started succesfully on sjc02.r423.ru01.


Update started succesfully on sjc02.r423.ru03.

Update started succesfully on sjc02.r423.ru07.

Update started succesfully on sjc02.r423.ru09.

Update started succesfully on sjc02.r423.ru13.

Update started succesfully on sjc02.r423.ru15.

Update started succesfully on sjc02.r423.ru19.

Update started succesfully on sjc02.r423.ru21.

Update started succesfully on sjc02.r423.ru25.

Update started succesfully on sjc02.r423.ru27.
```

#### Step 8: Sled Hard reset 
This step will hard resets all the sleds in the rack, make sure you run this command on the non-production rack as it shuts down all the sleds to M1 state.

```
wdjhn@dcops-3d3a63:~$ ./kon_dco_step8.sh --rack r423 --pop sjc02
!!!
WARNING THIS COMMAND WILL IMPACT THE SLED AND BOTH PAYLOADS
BE SURE SLEDS ARE DRAINED AND IN PREBOOT
!!!

!!!
WARNING THIS COMMAND WILL IMPACT THE SLED AND BOTH PAYLOADS
BE SURE SLEDS ARE DRAINED AND IN PREBOOT
!!!
sjc02.r423.ru13.s1 hard reset
!!!

WARNING THIS COMMAND WILL IMPACT THE SLED AND BOTH PAYLOADS
BE SURE SLEDS ARE DRAINED AND IN PREBOOT
!!!
sjc02.r423.ru19.s1 hard reset

<snip/>
```


#### Step 9: SEL reset and datetime setup
This step will clear SEL entries  which are  populated in the vendor facilities and gives us a blank slate for future troubleshooting messages. 

This step will also reset chassis date time to UTC timezone values.

```
wdjhn@dcops-3d3a63:~$ ./kon_dco_step9.sh --rack r423 --pop sjc02
mgmt-r423.ru09.h1.sjc02.justin.tv SEL date set to 2019-12-05T19:13:01Z UTC
mgmt-r423.ru15.h1.sjc02.justin.tv SEL date set to 2019-12-05T19:13:01Z UTC
mgmt-r423.ru07.h1.sjc02.justin.tv SEL date set to 2019-12-05T19:13:01Z UTC
mgmt-r423.ru03.h1.sjc02.justin.tv SEL date set to 2019-12-05T19:13:01Z UTC
mgmt-r423.ru13.h1.sjc02.justin.tv SEL date set to 2019-12-05T19:13:01Z UTC
mgmt-r423.ru19.h1.sjc02.justin.tv SEL date set to 2019-12-05T19:13:01Z UTC
mgmt-r423.ru21.h1.sjc02.justin.tv SEL date set to 2019-12-05T19:13:01Z UTC
mgmt-r423.ru27.h1.sjc02.justin.tv SEL date set to 2019-12-05T19:13:01Z UTC
mgmt-r423.ru25.h1.sjc02.justin.tv SEL date set to 2019-12-05T19:13:01Z UTC
mgmt-r423.ru13.h1.sjc02.justin.tv SEL log reset
mgmt-r423.ru09.h1.sjc02.justin.tv SEL log reset
mgmt-r423.ru15.h1.sjc02.justin.tv SEL log reset
mgmt-r423.ru03.h1.sjc02.justin.tv SEL log reset




<snip/>
```


#### Step 10: Reset passwords
This step reset IPMI password and hub node API password for the production use. 

Note: Any chassis which has resetted password can skip requirement of `KONTRONAPI_PASS='admin'` in Step 6 and 7.

```
wdjhn@dcops-3d3a63:~$ ./kon_dco_step10.sh --rack r423 --pop sjc02
Updating API credentials mgmt-r423.ru03.h1.sjc02.justin.tv
mgmt-r423.ru03.h1.sjc02.justin.tv: {"status":"Success", "code": 0, "message": ""}
Updating IPMI credentials mgmt-r423.ru03.s1.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru03.s2.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru03.s3.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru03.s4.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru03.s5.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru03.s6.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru03.s7.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru03.s8.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru03.s9.sjc02.justin.tv :
Updating API credentials mgmt-r423.ru07.h1.sjc02.justin.tv
mgmt-r423.ru07.h1.sjc02.justin.tv: {"status":"Success", "code": 0, "message": ""}
Updating IPMI credentials mgmt-r423.ru07.s1.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru07.s2.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru07.s3.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru07.s4.sjc02.justin.tv :
Updating IPMI credentials mgmt-r423.ru07.s5.sjc02.justin.tv :


<snip/>
```



#### Step 11: Chassis bootstrap verification
This workflow based verification will check for 
- firmware versions
- SEL date time in UTC
- Hubnode alignment
- Production credentials for IPMI and API

```
wdjhn@dcops-3d3a63:~$ ./kon_dco_step11.sh --rack r423 --pop sjc02
sjc02 r423 ru07 chassis_bootstrap validation sjc02 r423 ru09 chassis_bootstrap validation sjc02 r423 ru13 chassis_bootstrap validation sjc02 r423 ru15 chassis_bootstrap validation sjc02 r423 ru03 chassis_bootstrap validation sjc02 r423 ru21 chassis_bootstrap validation sjc02 r423 ru25 chassis_bootstrap validation sjc02 r423 ru19 chassis_bootstrap validation sjc02 r423 ru27 chassis_bootstrap validation .....................................................................................................................{
  "execution_arn": "arn:aws:states:us-west-2:277437172290:execution:machinebot_chassis_bootstrap_production_75f7b69212e6f3f1:6130e1fc-1f98-4837-a1b8-d645b5d0984c",
  "validation_request": {
    "hardware_location": {
      "pop": "sjc02",
      "rack": "r423",
      "rackUnit": 19
    },
    "workflow_name": "chassis_bootstrap",
    "hardware_type": "kontron"
  },
  "status": "SUCCEEDED",
  "start_date": "2019-12-05T19:25:23Z",
  "stop_date": "2019-12-05T19:38:07Z",
  "internal_state_machine_execution": {
    "activity_tasks": [
      {
        "name": "firmwareCheck",
        "activity_task_status": "success",
        "activity_type": "validate"
      },
      {
        "name": "SELLogDateTimeCheck",
        "activity_task_status": "success",
        "activity_type": "remediate"
      },
      {
        "name": "HubnodeAlignmentCheck",
        "activity_task_status": "success",
        "activity_type": "validate"
      },


<snip/>
```

More about this [workflow](https://docs.google.com/document/d/1Pj2Uzcf1fr9JZ9f5Q8kc2L6FN3AzYZ0rMvVOxJYQN2k/edit#heading=h.aqxgyp5zq13).



#### Step 12: Sled wake up

This will bring up payloads on the individual sled online to boot into preboot image. This is when individual Kontron hosts checks-in to provisioner.

```
wdjhn@dcops-3d3a63:~$ ./kon_dco_step12.sh --rack r423 --pop sjc02
sjc02.r423.ru09.s1 wake
sjc02.r423.ru07.s1 wake
sjc02.r423.ru27.s1 wake
sjc02.r423.ru13.s1 wake
sjc02.r423.ru03.s1 wake
sjc02.r423.ru19.s1 wake
sjc02.r423.ru25.s1 wake
sjc02.r423.ru15.s1 wake
sjc02.r423.ru21.s1 wake
sjc02.r423.ru15.s2 wake
sjc02.r423.ru07.s2 wake
sjc02.r423.ru25.s2 wake
sjc02.r423.ru27.s2 wake
sjc02.r423.ru21.s2 wake
sjc02.r423.ru19.s2 wake
sjc02.r423.ru09.s2 wake
sjc02.r423.ru13.s2 wake
sjc02.r423.ru03.s2 wake
sjc02.r423.ru27.s3 wake


<snip/>
```

#### Step 13: Chassis Verification
As payloads are up, this workflow can verify additional things like
-  CPU temparature
-  FAN speed 
-  M states of sled and payloads

```
wdjhn@dcops-3d3a63:~$  ./kon_dco_step13.sh --rack r423 --pop sjc02
sjc02 r423 ru03 chassis_verification validation sjc02 r423 ru07 chassis_verification validation sjc02 r423 ru09 chassis_verification validation sjc02 r423 ru13 chassis_verification validation sjc02 r423 ru15 chassis_verification validation sjc02 r423 ru19 chassis_verification validation sjc02 r423 ru21 chassis_verification validation sjc02 r423 ru25 chassis_verification validation sjc02 r423 ru27 chassis_verification validation ..........................................................................................{
  "execution_arn": "arn:aws:states:us-west-2:277437172290:execution:machinebot_chassis_verification_production_99ee9e060588ab08:2ffb5dc3-c855-4c53-8544-e219f0398482",
  "validation_request": {
    "hardware_location": {
      "pop": "sjc02",
      "rack": "r423",
      "rackUnit": 15
    },
    "workflow_name": "chassis_verification",
    "hardware_type": "kontron"
  },
  "status": "SUCCEEDED",
  "start_date": "2019-12-05T20:34:12Z",
  "stop_date": "2019-12-05T20:43:54Z",
  "internal_state_machine_execution": {
    "activity_tasks": [
      {
        "name": "DNSCheck",
        "activity_task_status": "success",
        "activity_type": "validate"
      },
      {
        "name": "HubnodeAlignmentCheck",
        "activity_task_status": "success",
        "activity_type": "validate"
      },
      {
        "name": "HealthStatus",
        "activity_task_status": "success",
        "activity_type": "validate"
      },
      {
        "name": "HubnodeAPIPing",
        "activity_task_status": "success",
        "activity_type": "validate"
      },
      {
        "name": "CPUTemp",
        "activity_task_status": "success",
        "activity_type": "validate"
      },
      {
        "name": "FanSpeed",
        "activity_task_status": "success",
        "activity_type": "validate"
      },


<snip/>
```

More about this [workflow](https://docs.google.com/document/d/1Pj2Uzcf1fr9JZ9f5Q8kc2L6FN3AzYZ0rMvVOxJYQN2k/edit#heading=h.hwtyvbe6xefj)

#### Step 14: Verify provisioner entries for hosts

This workflow based verification looks for the successful check-in of the host in the provisioner. Successful of this verification is the clear indicator that all hosts in the Kontron are ready for the handover.

```
wdjhn@dcops-3d3a63:~$ time ./kon_dco_step14.sh --rack r423 --pop sjc02
sjc02 r423 ru03 sled_bringup validation sjc02 r423 ru09 sled_bringup validation sjc02 r423 ru21 sled_bringup validation sjc02 r423 ru07 sled_bringup validation sjc02 r423 ru13 sled_bringup validation sjc02 r423 ru15 sled_bringup validation sjc02 r423 ru19 sled_bringup validation sjc02 r423 ru25 sled_bringup validation sjc02 r423 ru27 sled_bringup validation .........................................................................{
  "execution_arn": "arn:aws:states:us-west-2:277437172290:execution:machinebot_sled_bringup_production_3ed02bbb9d3d789b:9644a9c4-0260-4ce6-97f9-584ca5977ca7",
  "validation_request": {
    "hardware_location": {
      "pop": "sjc02",
      "rack": "r423",
      "rackUnit": 3
    },
    "workflow_name": "sled_bringup",
    "hardware_type": "kontron"
  },
  "status": "SUCCEEDED",
  "start_date": "2019-12-05T20:50:19Z",
  "stop_date": "2019-12-05T20:57:36Z",
  "internal_state_machine_execution": {
    "activity_tasks": [
      {
        "name": "ProvisionerDataValidation",
        "activity_task_status": "success",
        "activity_type": "validate"
      }
    ]
  }
}
{
  "execution_arn": "arn:aws:states:us-west-2:277437172290:execution:machinebot_sled_bringup_production_3ed02bbb9d3d789b:c919a1fd-f0fa-4372-8af2-07b5ddd688b9",
  "validation_request": {
    "hardware_location": {
      "pop": "sjc02",
      "rack": "r423",
      "rackUnit": 15
    },
    "workflow_name": "sled_bringup",
    "hardware_type": "kontron"
  },
  "status": "SUCCEEDED",
  "start_date": "2019-12-05T20:50:20Z",
  "stop_date": "2019-12-05T20:57:47Z",
  "internal_state_machine_execution": {
    "activity_tasks": [
      {


<snip/>
```

More about this [workflow](https://docs.google.com/document/d/1Pj2Uzcf1fr9JZ9f5Q8kc2L6FN3AzYZ0rMvVOxJYQN2k/edit#heading=h.sakbjfamyyo7)

#### Step 15: Sync buildsheet data with provisioner

Before handover, we sync buildsheet location data to provisioner.
```
wdjhn@dcops-3d3a63:~$ ./kon_dco_step15.sh --rack r423 --pop sjc02
sjc02 r423 ru03 provisioner_sync validation .{
  "execution_arn": "arn:aws:states:us-west-2:277437172290:execution:machinebot_provisioner_sync_production_3d76da6420871d0e:74f5d9aa-fac5-4414-8daa-9ae6b999c42e",
  "validation_request": {
    "hardware_location": {
      "pop": "sjc02",
      "rack": "r423",
      "rackUnit": 3
    },
    "workflow_name": "provisioner_sync",
    "hardware_type": "kontron"
  },
  "status": "SUCCEEDED",
  "start_date": "2019-12-05T21:04:21Z",
  "stop_date": "2019-12-05T21:04:39Z",
  "internal_state_machine_execution": {
    "activity_tasks": [
      {
        "name": "ProvisionerSync",
        "activity_task_status": "success",
        "activity_type": "remediate"
      }
    ]
  }
}
sjc02 r423 ru07 provisioner_sync validation .{
  "execution_arn": "arn:aws:states:us-west-2:277437172290:execution:machinebot_provisioner_sync_production_3d76da6420871d0e:77fd48b1-6f5c-4e48-87c4-7f1695f3e6f9",
  "validation_request": {
    "hardware_location": {
      "pop": "sjc02",
      "rack": "r423",
      "rackUnit": 7
    },
    "workflow_name": "provisioner_sync",


<snip/>
```

### Troubleshooting tips 
Any of the workflow verification done by `kon_dco_step5.sh`, `kon_dco_step11.sh`, `kon_dco_step13.sh`, `kon_dco_step14.sh` with issues in `errors[]` can be resolve with following guidelines.

- If any step execution errors out with following string as a part of error message
```
expected ip of hub node 1 and got ip of h2
```
then rerun step4 on that rack to fix hubnode alignment.
If this error keeps repeating then open ticket with vidops to detect failed hubnodes and put that in RMA workflow.

- After 2nd time execution of `kon_dco_step5.sh`, look for error message similar to following 
```
"message": "serial mismatch between buildsheet and FRU for hostname mgmt-r405.ru07.s7.lhr05.justin.tv"
```
If you see this message then open a ticket with vidops for the buildsheet fix.






### Execution on single chassis 
All above steps can be executed on the single chassis with `--rack_unit` parameters for RMA handling purposes.

```
ts$ ./kon_dco_step2.sh --rack r209 --pop lhr05 --rack_unit ru27


Step 2: Look for existance for DNS entries pointing to BMCs of the rack.

These DNS entries must exist in order to conduct rest of the steps.


mgmt-r209.ru27.h1.lhr05.justin.tv 10.32.21.149
mgmt-r209.ru27.h2.lhr05.justin.tv 10.32.21.150
mgmt-r209.ru27.s1.lhr05.justin.tv 10.32.21.151
mgmt-r209.ru27.s2.lhr05.justin.tv 10.32.21.152
mgmt-r209.ru27.s3.lhr05.justin.tv 10.32.21.153
mgmt-r209.ru27.s4.lhr05.justin.tv 10.32.21.154
mgmt-r209.ru27.s5.lhr05.justin.tv 10.32.21.155
mgmt-r209.ru27.s6.lhr05.justin.tv 10.32.21.156
mgmt-r209.ru27.s7.lhr05.justin.tv 10.32.21.157
mgmt-r209.ru27.s8.lhr05.justin.tv 10.32.21.158
mgmt-r209.ru27.s9.lhr05.justin.tv 10.32.21.159
```

## Reference 
- [Kontron Rack buildout automation](https://docs.google.com/document/d/1Pj2Uzcf1fr9JZ9f5Q8kc2L6FN3AzYZ0rMvVOxJYQN2k/edit#heading=h.peal5eevf9vi)
- [Rack 422 and 423 setup](https://docs.google.com/document/d/1BHAtokV5P7XH-GpOk4Z3WOQdShz_D1--J19MTkSQ43E/edit#)
- [DCO runbook for rack buildout](https://docs.google.com/document/d/1CO6FvETK90ejndVudX_ex1-tp7E0o62O0T33r-drIF4/edit#)




