#!/usr/bin/env bash

SCRIPT_PATH=${0%/*} 


source "${SCRIPT_PATH}"/kon_dco_arg.source

exec > >(tee -ia ${BASH_SOURCE}-${DATE}.log)
exec 2> >(tee -ia ${BASH_SOURCE}-${DATE}.log >&2)


cat <<EOF

Step 10: Reset passwords for Kontron Hub node API and IPMI.


EOF

RACK=${_arg_rack}
POP=${_arg_pop}

for RU in "${array_RU[@]}"
do
	kon_apipass_update  --pop $POP --rack $RACK --rack_unit ${RU}
	kon_ipmipass_update --pop $POP --rack $RACK --rack_unit ${RU}
done

