#!/usr/bin/env bash

SCRIPT_PATH=${0%/*} 


source "${SCRIPT_PATH}"/kon_dco_arg.source

exec > >(tee -ia ${BASH_SOURCE}-${DATE}.log)
exec 2> >(tee -ia ${BASH_SOURCE}-${DATE}.log >&2)


cat <<EOF

Step 12: Wake up the payloads in the entire rack.


EOF

RACK=${_arg_rack}
POP=${_arg_pop}

for SLD in s1 s2 s3 s4 s5 s6 s7 s8 s9
do
    for RU in "${array_RU[@]}"
    do
        kon_wake_sled --rack $RACK --pop $POP --rack_unit $RU --sled_number $SLD --hub_number h1 &
    done
    wait < <(jobs -p)
done

