#!/usr/bin/env bash

SCRIPT_PATH=${0%/*} 


source "${SCRIPT_PATH}"/kon_dco_arg.source

exec > >(tee -ia ${BASH_SOURCE}-${DATE}.log)
exec 2> >(tee -ia ${BASH_SOURCE}-${DATE}.log >&2)

cat <<EOF

Step 13: As sleds are up, this workflow will verify their M states along with
FAN and CPU temprature.

This command will provide JSON output.

In the case of failure, output will have errors[], which you must report to
Vidops team for further investigation.

EOF

RACK=${_arg_rack}
POP=${_arg_pop}

for RU in "${array_RU[@]}"
do
	kon_wf_chassis_verification --pop $POP --rack $RACK --rack_unit $RU &
done
wait < <(jobs -p)

