#!/usr/bin/env bash

SCRIPT_PATH=${0%/*} 



source "${SCRIPT_PATH}"/kon_dco_arg.source

exec > >(tee -ia ${BASH_SOURCE}-${DATE}.log)
exec 2> >(tee -ia ${BASH_SOURCE}-${DATE}.log >&2)


cat <<EOF


Step 2: Look for existance for DNS entries pointing to BMCs of the rack.  

These DNS entries must exist in order to conduct rest of the steps.


EOF

RACK=${_arg_rack}
POP=${_arg_pop}

for RU in "${array_RU[@]}"
do
    for SLD in h1 h2 s1 s2 s3 s4 s5 s6 s7 s8 s9
    do
	echo -n "mgmt-$RACK.ru$RU.$SLD.$POP.justin.tv "
	echo `dig +short mgmt-$RACK.ru${RU}.$SLD.$POP.justin.tv`
    done
done
