#!/usr/bin/env bash

SCRIPT_PATH=${0%/*} 


source "${SCRIPT_PATH}"/kon_dco_arg.source

exec > >(tee -ia ${BASH_SOURCE}-${DATE}.log)
exec 2> >(tee -ia ${BASH_SOURCE}-${DATE}.log >&2)

cat <<EOF

Step 5: Verify IPMI fru data against vendor provided buildsheet.

EOF

RACK=${_arg_rack}
POP=${_arg_pop}

for RU in "${array_RU[@]}"
do
	kon_wf_buildsheet_service --pop $POP --rack $RACK --rack_unit $RU  &
done
wait < <(jobs -p)

