#!/usr/bin/env bash

SCRIPT_PATH=${0%/*} 


source "${SCRIPT_PATH}"/kon_dco_arg.source

exec > >(tee -ia ${BASH_SOURCE}-${DATE}.log)
exec 2> >(tee -ia ${BASH_SOURCE}-${DATE}.log >&2)

cat <<EOF

Step 6: Prepare Kontron chassis for the firmware upgrade.

EOF

RACK=${_arg_rack}
POP=${_arg_pop}

for RU in "${array_RU[@]}"
do
	   kon_fw_upload --rack=$RACK --rack_unit=$RU --pop=$POP --hub_number=1 &
done
wait < <(jobs -p)
