#!/usr/bin/env bash

SCRIPT_PATH=${0%/*} 


source "${SCRIPT_PATH}"/kon_dco_arg.source

exec > >(tee -ia ${BASH_SOURCE}-${DATE}.log)
exec 2> >(tee -ia ${BASH_SOURCE}-${DATE}.log >&2)

cat <<EOF

Step 7: Trigger firmware upgrade.

Give 3 to 4 hours for firmware upgrade to complete before moving forward with step 8.

EOF

RACK=${_arg_rack}
POP=${_arg_pop}

for RU in "${array_RU[@]}"
do
	   kon_fw_update --rack=$RACK --rack_unit=$RU --pop=$POP --hub_number=1 --force
done

