#!/usr/bin/env bash

SCRIPT_PATH=${0%/*} 


source "${SCRIPT_PATH}"/kon_dco_arg.source


function yes_no  {
 
        local Q=$1
        echo "$Q : [YES/n] "
        read ANS
 
 
        if [ $ANS = 'YES' ]
        then
                return 1
        fi

	return 0
 
}




RACK=${_arg_rack}
POP=${_arg_pop}

cat <<EOF

Step 8: Hard reset all the chassis.

WARNING: This command will shutdown all the chassis in the rack, you MUST make
sure that rack ${RACK}.${POP} is NOTE in the production serving live traffic.


EOF


yes_no 'Do you want to proceed with the hard reset?'
if [ $? -eq 0 ]
then
	echo "Aborting step 8."
        exit
fi


for SLD in s1 s2 s3 s4 s5 s6 s7 s8 s9
do
    for RU in "${array_RU[@]}"
    do
        printf 'y' | kon_hard_reset_sled --rack $RACK --pop $POP --rack_unit $RU --sled_number $SLD --hub_number h1 &
    done
    wait < <(jobs -p)
done
