#!/usr/bin/env bash

SCRIPT_PATH=${0%/*} 


source "${SCRIPT_PATH}"/kon_dco_arg.source

exec > >(tee -ia ${BASH_SOURCE}-${DATE}.log)
exec 2> >(tee -ia ${BASH_SOURCE}-${DATE}.log >&2)

cat <<EOF

Step 9: Reset SEL logs and datetime for the chassis.


EOF

RACK=${_arg_rack}
POP=${_arg_pop}

for RU in "${array_RU[@]}"
do
	   kon_sel_resets --rack=$RACK --rack_unit=$RU --pop=$POP  &
done
wait < <(jobs -p)
