#!/bin/bash

# Download config file and update ports

for var in $@; do
    if [[ $var == "--local-usb" ]]; then
        configLocalUSB=true
    fi
    if [[ $var == "--local-storage" ]]; then
        configLocalStorage=true
    fi
done



echo
echo "============================================="
if [[ configLocalUSB == true || configLocalStorage == true ]]; then
    echo "= Utilizing info file locally ==============="
fi
if [[ configLocalUSB != true && configLocalStorage != true ]]; then
    ipAddress=`ifconfig eth0 | grep -Eo 'inet (addr:)?([0-9]*\.){3}[0-9]*' | grep -Eo '([0-9]*\.){3}[0-9]*' | grep -v '127.0.0.1'`
    echo "= Found IP address: $ipAddress =============="
    echo "= Downloading info file for above IP ========"
fi
echo "============================================="
echo
if [[ configLocalUSB != true && configLocalStorage != true ]]; then
    wget -P /etc/config/ ftp://anonymous:password@dcops01.sjc02.justin.tv/config_info_sheet/twitch_$ipAddress
fi

if [[ configLocalUSB == true || configLocalStorage == true ]]; then
    echo -n "Input name of config file (example: twitch_10.27.70.200): "
    read infoShortName
fi

if [[ configLocalUSB == true ]]; then
    cp /var/mnt/storage.usb/$infoShortName /etc/config/$infoShortName
    infoFileName="/etc/config/$infoShortName"
elif [[ configLocalStorage == true ]]; then
    cp /var/mnt/storage.sd/$infoShortName /etc/config/$infoShortName
    infoFileName="/etc/config/$infoShortName"
else
    infoFileName="/etc/config/twitch_$ipAddress"
fi

while read -r line || [[ -n "$line" ]]; do
    recordType=$(echo $line | cut -d ':' -f 1)
    case $recordType in
        ip)
            if [[ configLocalUSB == true || configLocalStorage == true ]]; then
                echo "Setting IP address..."
                config -s config.interfaces.wan.mode=static \
                    -s config.interfaces.wan.address=$(echo $line | cut -d ':' -f 2-) \
                    -s config.interfaces.wan.dns1=10.254.0.3 \
                    -s config.interfaces.wan.netmask=255.255.255.0 # MAY CAUSE ISSUES IN FUTURE
                ipTemp=$(echo $line | cut -d ':' -f 2-)
            else
                if [[ $ipAddress == $(echo $line | cut -d ':' -f 2-) ]]; then
                    echo "IP Address Match"
                    ipTemp=$ipAddress
                else
                    echo "ALERT, Downloaded file does not match IP address of machine!"
                    exit
                fi
            fi
            ;;
        gw)
            if [[ configLocalUSB == true || configLocalStorage == true ]]; then
                echo "Setting gateway address..."
                config -s config.interfaces.wan.gateway=$(echo $line | cut -d ':' -f 2-)
            else
                gwAddress=$(netstat -rn  | grep UG | awk '{print $2}')
                if [[ $gwAddress == $(echo $line | cut -d ':' -f 2-) ]]; then
                    echo "Gateway Address Match"
                else
                    echo "ALERT, Downloaded file does not match IP address of machine!"
                    exit
                fi
            fi
            ;;
    esac
done < $infoFileName

if [[ configLocalUSB == true || configLocalStorage == true ]]; then
    echo -n "Applying opengear config........."
    config -r ipconfig >/dev/null 2>&1
    echo "DONE"
fi

echo
echo "============================================="
echo "= Applying Device Specific Settings ========="
echo "============================================="
echo
while read -r line || [[ -n "$line" ]]; do
    recordType=$(echo $line | cut -d ':' -f 1)
    case $recordType in
        name)
            deviceName=$(echo $line | cut -d ':' -f 2-)
            echo "Setting name to $deviceName"
            config -s config.system.name=$deviceName
            echo "Creating temp hosts file"
            echo "$ipTemp $deviceName" > /etc/config/twitch_hosts
            ;;
        desc)
            deviceDesc=$(echo $line | cut -d ':' -f 2-)
            echo "setting system description to $deviceDesc"
            config -s config.system.location="$deviceDesc"
            ;;
        serial)
            portNumber=$(echo $line | cut -d ':' -f 2)
            portIPAddress=$(echo $line | cut -d ':' -f 3)
            portLabel=$(echo $line | cut -d ':' -f 9)
            config -s config.ports.port${portNumber}.interfaces.wan=$portIPAddress/24 \
                -s config.ports.port${portNumber}.ssh=$(echo $line | cut -d ':' -f 4) \
                -s config.ports.port${portNumber}.speed=$(echo $line | cut -d ':' -f 5) \
                -s config.ports.port${portNumber}.charsize=$(echo $line | cut -d ':' -f 6) \
                -s config.ports.port${portNumber}.parity=$(echo $line | cut -d ':' -f 7) \
                -s config.ports.port${portNumber}.stop=$(echo $line | cut -d ':' -f 8) \
                -s config.ports.port${portNumber}.flowcontrol=None \
                -s config.ports.port${portNumber}.mode=portmanager \
                -s config.ports.port${portNumber}.loglevel=2 \
                -s config.ports.port${portNumber}.pinout=X2 \
                -s config.ports.port${portNumber}.protocol=RS232 \
                -s config.ports.port${portNumber}.syslog.facility=Default \
                -s config.ports.port${portNumber}.syslog.priority=Default \
                -s config.ports.port${portNumber}.terminal=vt220
            if [[ $portLabel ]]; then 
                config -s config.ports.port${portNumber}.label=$portLabel
                echo "$portIPAddress $portLabel" >> /etc/config/twitch_hosts
                echo "Configuring serial port s$portNumber with label $portLabel"
            else
                config -s config.ports.port${portNumber}.label=s$portNumber
                echo "$portIPAddress s$portNumber" >> /etc/config/twitch_hosts
                echo "Configuring serial port s$portNumber"
            fi
    esac
done < $infoFileName
echo && echo "Example port config....."
config -g config.ports.port1
echo "Updating host file"
cp /etc/config/twitch_hosts /etc/config/hosts