#!/bin/bash

for var in $@; do
	if [[ $var == "--local" ]]; then
    	configLocalUSB=true
    fi
    if [[ $var == "--local-usb" ]]; then 
    	configLocalUSB=true
    fi
    if [[ $var == "--local-storage" ]]; then
    	configLocalStorage=true
    fi
done

if [[ $configLocalUSB == true || $configLocalStorage == true]]; then
	configLocal=true
fi

# Download Scripts from FTP

if [[ $configLocal != true ]]; then
	echo
	echo "============================================="
	echo "= Downloading Twitch Scripts ================"
	echo "============================================="
	echo
	wget -P /etc/config/ ftp://anonymous:password@dcops01.sjc02.justin.tv/operation-caesar/opengear/scripts/twitch_scripts.sh
	/bin/bash /etc/config/twitch_scripts.sh
fi

# Download device specific values from FTP and check

echo
echo "============================================="
echo "= Applying Base Configuration ==============="
echo "============================================="
echo
if [[ $configLocal != true ]]; then
	/bin/bash /etc/config/twitch_base.sh
elif [[ $configLocalUSB == true ]]; then
	/bin/bash /etc/config/twitch_base.sh --local-usb
elif [[ $configLocalStorage == true ]]; then
	/bin/bash /etc/config/twitch_base.sh --local-storage
fi


# Configure user groups

echo
echo "============================================="
echo "= Setting Up User Groups ===================="
echo "============================================="
echo
/bin/bash /etc/config/twitch_groups.sh
# if [[ $configLocal != true ]]; then
# 	/bin/bash /etc/config/twitch_groups.sh
# else
# 	/bin/bash /etc/config/twitch_groups.sh --local
# fi

# Update users

echo
echo "============================================="
echo "= Updating Users ============================"
echo "============================================="
echo
if [[ $configLocal != true ]]; then
	/bin/bash /etc/config/twitch_users.sh
elif [[ $configLocalUSB == true ]]; then
	/bin/bash /etc/config/twitch_users.sh --local-usb
elif [[ $configLocalStorage == true ]]; then
	/bin/bash /etc/config/twitch_users.sh --local-storage


# Run general configuration

echo
echo "============================================="
echo "= Confirming Miscellaneous Settings ========="
echo "============================================="
echo
/bin/bash /etc/config/twitch_misc.sh
# if [[ $configLocal != true ]]; then
# 	/bin/bash /etc/config/twitch_misc.sh
# else
# 	/bin/bash /etc/config/twitch_misc.sh --local
# fi

# Update users

if [[ $configLocal != true ]]; then
	echo
	echo "============================================="
	echo "= Connecting to lighthouse =================="
	echo "============================================="
	echo
	/bin/bash /etc/config/twitch_cms.sh
fi


# Force initial backup (final step)

if [[ $configLocal != true ]]; then
	echo
	echo "============================================="
	echo "= Force Backup - Final step ================="
	echo "============================================="
	echo
	/bin/bash /etc/config/twitch_backup.sh
fi
