#!/bin/bash
# Arguments...
#    #-v         : verbose mode
#    --initial  : also updates user groups (obsolete due to group script)
#    --audit    : audits users based on mast user list, checking for unexpected users
# Expected format for each line of user list from FTP is: <username> <group> <ssh key>

for var in $@; do
#    if [[ $var == "-v" ]]; then verbose=true; fi
	if [[ $var == "--audit" ]]; then
	    audit=true
	fi
done


# audit users
if [[ $audit == true ]]; then
    if [[ -f /etc/config/twitch_opengear_users ]]; then
        echo "Removing old user list"
        rm /etc/config/twitch_opengear_users
    fi
    wget -P /etc/config/ ftp://anonymous:password@dcops01.sjc02.justin.tv/operation-caesar/opengear/scripts/twitch_authorized >/dev/null 2>$1
    echo "Downloaded twitch user list from FTP"
    userCount=`config -g config.users.total`
    userCount=${userCount#config.users.total}
    counter=2
    while [ $counter -le $userCount ]; do
            found=false
            localUser=$(config -g config.users.user$counter.username | cut -d ' ' -f 2-)
            while read -r line || [[ -n "$line" ]]; do
                listUser=$(echo $line | cut -d ' ' -f 1)
                if [[ $localUser == $listUser ]]; then
                    found=true
                fi
            done < /etc/config/twitch_opengear_users
            if [[ $found == false ]]; then
                echo "Found extraneous user: $localUser"
            fi
            let counter=counter+1
    done
    exit
fi

# remove user list and temp root keys if already esists

# remove user list and temp root keys if already esists
echo -n "Deleting stale auth files.... "
if [[ -f /etc/config/twitch_authorized ]]; then
    rm /etc/config/twitch_authorized
fi
if [[ -f /etc/config/ssh_authorized_keys.tmp ]]; then
    rm /etc/config/ssh_authorized_keys.tmp
fi
echo "DONE"

# download latest user list from FTP

echo -n "Downloading twitch user list....."
wget -P /etc/config/ ftp://anonymous:password@dcops01.sjc02.justin.tv/operation-caesar/opengear/scripts/twitch_authorized #>/dev/null 2>&1
echo "DONE"

# iterate through user list pulling appart usernames, groups, and keys

touch /etc/config/ssh_authorized_keys.tmp
while read -r line || [[ -n "$line" ]]; do
    username=$(echo $line | cut -d ' ' -f 1)
    group=$(echo $line | cut -d ' ' -f 2 | cut -d ' ' -f 2-)
    key=$(echo $line | cut -d ' ' -f 3-)
    exists=$(id -u $username > /dev/null 2>&1; echo $?)
    if [[ $exists == 1 ]]; then
        # user does not exist, create user
        echo "User $username not found - Please ensure this user exists on terminal server infrastructure"
    fi
    echo -n "Updating key for user: $username"
    config -s config.users.user19.disabled=off
    echo $key > /etc/config/users/$username/.ssh/authorized_keys
    if [[ $group == "dcops" ]]; then
        echo " (with root)"
        echo $key >> /etc/config/ssh_authorized_keys.tmp
    else
        echo
    fi
done < /etc/config/twitch_authorized
mv /etc/config/ssh_authorized_keys.tmp /etc/config/ssh_authorized_keys

# set all users to key only auth
userCount=`config -g config.users.total`
userCount=${userCount#config.users.total}
counter=2
echo -n "Enabling and forcing key auth on all users...."
while [ $counter -le $userCount ]; do
        config -s config.users.user$counter.ssh_pubkey_only=on \
        	-d config.users.user$counter.disabled
        let counter=counter+1
done
echo "DONE"

#apply config
echo -n "Applying opengear config........."
config -a >/dev/null 2>&1
echo "DONE"
