#!/bin/bash


# set SysLog

echo -n "Configuring Syslog..............."
config -s config.syslog.server.hostname=dcops01.sjc02.justin.tv \
	-s config.syslog.server.port=514
echo "DONE"

# set NTP

echo -n "Configuring NTP.................."
config -s config.system.timezone=Etc/GMT \
	-s config.ntp.enabled=on \
	-s config.ntp.servers.server1.address=ntp1.internal.justin.tv \
	-s config.ntp.servers.server1.key_id=0 \
	-s config.ntp.servers.server2.address=ntp2.internal.justin.tv \
	-s config.ntp.servers.server2.key_id=0 \
	-s config.ntp.servers.total=2
echo "DONE"

# set SNMP

echo -n "Configuring SNMP................."
config -s config.services.snmp.enabled=on \
	-s config.services.snmp.protocol=UDP \
	-s config.services.snmp.roauthprotocol=SHA \
	-s config.services.snmp.rocommunity=jtv \
	-s config.services.snmp.roprivprotocol=DES \
	-s config.services.snmp.roseclevel=noauth \
	-s config.services.snmp.rwcommunity=N8ucDURGJu5z
echo "DONE"

# set HTTPS only

echo -n "Configuring HTTPS only..........."
config -s config.services.http.enabled=off
echo "DONE"

# set key auth only for ssh

echo -n "Setting Key Only SSH............."
sed -i "s/#PasswordAuthentication yes/PasswordAuthentication no/g" /etc/config/sshd_config
sed -i "s/#ChallengeResponseAuthentication yes/ChallengeResponseAuthentication no/g" /etc/config/sshd_config
echo "DONE"

# apply configuration

echo -n "Applying opengear config........."
config -a >/dev/null 2>&1
echo "DONE"
