#!/bin/bash
# Arguments...
#    --audit    : audits users based on mast user list, checking for unexpected users
# Expected format for each line of user list from FTP is: <username> <group> <ssh key>

for var in $@; do
    if [[ $var == "--audit" ]]; then
        audit=true
    fi
    if [[ $var == "--local" ]]; then
        configLocalUSB=true
    fi
    if [[ $var == "--local-usb" ]]; then
        configLocalUSB=true
    fi
    if [[ $var == "--local-storage" ]]; then
        configLocalStorage=true
    fi
done


# audit users
# note - needs network connectivity
if [[ $audit == true ]]; then
    if [[ -f /etc/config/twitch_authorized ]]; then
        echo "Removing old user list"
        rm /etc/config/twitch_authorized
    fi
    wget -P /etc/config/ ftp://anonymous:password@dcops01.sjc02.justin.tv/operation-caesar/opengear/scripts/twitch_authorized >/dev/null 2>$1
    echo "Downloaded twitch user list from FTP"
    userCount=`config -g config.users.total`
    userCount=${userCount#config.users.total}
    counter=2
    while [ $counter -le $userCount ]; do
            found=false
            localUser=$(config -g config.users.user$counter.username | cut -d ' ' -f 2-)
            while read -r line || [[ -n "$line" ]]; do
                listUser=$(echo $line | cut -d ' ' -f 1)
                #echo "testing $localUser against $listUser"
                if [[ $localUser == $listUser ]]; then
                    found=true
                fi
            done < /etc/config/twitch_authorized
            if [[ $found == false ]]; then
                echo "Found extraneous user: $localUser"
            fi
            let counter=counter+1
    done
    exit
fi

# remove user list and temp root keys if already esists

if [[ -f /etc/config/twitch_authorized ]]; then
    rm /etc/config/twitch_authorized
fi
if [[ -f /etc/config/ssh_authorized_keys.tmp ]]; then
    rm /etc/config/ssh_authorized_keys.tmp
fi
echo "DONE"

# download latest user list from FTP
if [[ $configLocalUSB == true ]]; then
    cp /var/mnt/storage.usb/twitch_authorized /etc/config/twitch_authorized
elif [[ $configLocalStorage == true ]]; then
    cp /var/mnt/storage.sd/twitch_authorized /etc/config/twitch_authorized
else
    echo -n "Downloading twitch user list....."
    wget -P /etc/config/ ftp://anonymous:password@dcops01.sjc02.justin.tv/operation-caesar/opengear/scripts/twitch_authorized >/dev/null 2>&1
    echo "DONE"
fi

# iterate through user list pulling appart usernames, groups, and keys

touch /etc/config/ssh_authorized_keys.tmp
while read -r line || [[ -n "$line" ]]; do
    username=$(echo $line | cut -d ' ' -f 1)
    group=$(echo $line | cut -d ' ' -f 2 | cut -d ' ' -f 2-)
    key=$(echo $line | cut -d ' ' -f 3-)
    exists=$(id -u $username > /dev/null 2>&1; echo $?)
    if [[ $exists == 1 ]]; then
        # user does not exist, create user
        echo "Creating new user: $username"
        prefix=$(config --list-base config.users --list-add)
        config -s $prefix.username=$username \
            -s $prefix.groups.group1=$group
            -s $prefix.groups.group2=users
        if [[ $group == "dcops" ]]; then
            config -s $prefix.groups.group3=admin
        fi
        config -s $prefix.password='$1$s4lt1e$4TmD7ANKGtbISf1A/jy14.'
        echo -n "Applying user config............."
        config -r users >/dev/null 2>&1
        echo "DONE"
    fi
    echo -n "Updating key for user: $username"
    echo $key > /etc/config/users/$username/.ssh/authorized_keys
    if [[ $group == "dcops" ]]; then
        echo " (with root)"
        echo $key >> /etc/config/ssh_authorized_keys.tmp
    else
        echo
    fi
done < /etc/config/twitch_authorized

#inlcude lighthouse root pub key
echo "ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAQEAxMMuDrRVBIOiK0cKLljblekre/ZsynJaOJ8l3cGlcq2H6L/IDOQDkREGn8cFHi0sHCaPNQpdwW+UiFsONUY2XH43UOU+1Xn9Y7f9KwgtDKCCra46UkRhpIzvgtgKwfVTuP5QGPBlQwJwMtLLoLq4ve/RzTKWF9mouLIe3SfE1NZZo3HJ8URpk8/DRgcI5iC9U0e0k6+bLnHSY790d2SkXu3gB1rsvQCsuxw60O13nyVb3tNn8dlEkGTivQM/vppNxp04zAERa4LCA1GV9PQ9EXL2WAJIwtZD06Gq7KjXD7zTg/7C7aO+S5tnX9bonNLdMCKOYhTS3dhYMPruODZQ3Q== nagios@lighthouse" >> /etc/config/ssh_authorized_keys.tmp
mv /etc/config/ssh_authorized_keys.tmp /etc/config/ssh_authorized_keys

# set all users to key only auth
userCount=`config -g config.users.total`
userCount=${userCount#config.users.total}
counter=2
echo -n "Forcing key auth on all users...."
while [ $counter -le $userCount ]; do
        config -s config.users.user$counter.ssh_pubkey_only=on
        let counter=counter+1
done
echo "DONE"

#apply config
echo -n "Applying opengear config........."
config -a >/dev/null 2>&1
echo "DONE"
