import pexpect, sys, argparse, getpass, subprocess, threading


class threadedCommand(object):
	statusDict = {'success':[],'failure':{}}
	hosts = []
	thread_count = 4
	lock = threading.Lock()
	username = None
	password = None
	command = 'ostat all'
	ssh_newkey = 'Are you sure you want to continue connecting \(yes\/no\)? '

	# function runs command
	def runCommand(self,host):
		success = [False,"Error: Unknown Failure"];
		try:
			#start SSH session
			sshSession = pexpect.spawn('ssh %s@%s' % (self.username,host))
			responseIndex = sshSession.expect([self.ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)

			# accept new ssh key
			if responseIndex == 0:
				sshSession.sendline('yes')
				# re-run expect to process failure or password
				responseIndex=sshSession.expect([self.ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)

			# respond to password request
			if responseIndex == 1:
				sshSession.sendline(self.password)
			elif responseIndex == 2:
				success = [False,"Error: Password Request error, found EOF"];

			sshSession.expect("Switched CDU: ")
			sshSession.sendline(self.command)
			responseIndex = sshSession.expect(['Command successful','Invalid'])

			if responseIndex == 0: #Command completed successfully
				success = [True];
			elif responseIndex == 1:
				success = [False,"Error: Command Failure on Device"];

		except pexpect.TIMEOUT:
			success = [False,"Error: Timeout"];
		except (pexpect.EOF, pexpect.TIMEOUT), e:
			success = [False,"Error: General Error with PExpect"];
		return success

	def popQueue(self):
		hostname = None
		self.lock.acquire()
		if self.hosts:
			hostname = self.hosts.pop()
		self.lock.release()
		return hostname

	def deQueue(self):
		while True:
			hostname = self.popQueue()
			if not hostname:
				return None

			# place hostnames in appropraite dict keys upon run
			response=self.runCommand(hostname)
			if response[0]:
				self.statusDict['success'].append(hostname)
			elif not response[0]:
				self.statusDict['failure'][hostname]=response[1]

	def start(self):
		threads = []
		for i in range(self.thread_count):
			t = threading.Thread(target=self.deQueue)
			t.start()
			threads.append(t)
		[t.join() for t in threads]
		return self.statusDict

if __name__=='__main__':

	try:
		parser = argparse.ArgumentParser() #Use argparse for arguments/flags
		parser.add_argument('username', help='Radius Username')
		args = parser.parse_args()

		userPass = getpass.getpass()

		hostnameList=['pdu2a.sjc02.justin.tv','pdu2b.sjc02.justin.tv','pdu11a.sjc02.justin.tv','pdu11b.sjc02.justin.tv']
		commandString = 'ostat all'

		print '\nTesting script with the following hosts:'
		for element in hostnameList:
			print element
		print '\n'

		run = threadedCommand()
		run.threaded_count = 4
		run.hosts = hostnameList
		run.username = args.username
		run.password = userPass
		run.command = commandString

		print run.start()
	except (KeyboardInterrupt, SystemExit):
		print "\n\nExit Command Recieved\n"
