import pexpect, sys, argparse, getpass, re

parser = argparse.ArgumentParser() #Use argparse for arguments/flags
parser.add_argument('username', help='Radius Username')
parser.add_argument('filename', help='File Name of hostname list, one per line')
args = parser.parse_args()

userPass = getpass.getpass()

# Value for New Key request
ssh_newkey = 'Are you sure you want to continue connecting \(yes\/no\)? '
command = 'ostat all'

with open(args.filename,'r') as file:
	for hostname in file:

		print "\n========================================\n\n"+hostname

		try:
			try:
				sshSession = pexpect.spawn('ssh %s@%s' % (args.username,hostname))
				#sshSession.logfile = sys.stdout
				responseIndex = sshSession.expect([ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)
				#sshSession.timeout = 30
				#print "set timout to 20sec"

				# accept new ssh key
				if responseIndex == 0:
					sshSession.sendline('yes')
					# re-run expect to process failure or password
					responseIndex=sshSession.expect([ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)

				# respond to password request
				if responseIndex == 1:
					sshSession.sendline(userPass)
					#sshSession.expect(pexpect.EOF)
				elif responseIndex == 2:
					#raise MyException("Error logging into device")
					print "error in password request, found EOF"

				sshSession.expect("Switched CDU: ")
				sshSession.sendline(command)
				responseIndex = sshSession.expect(['Command successful','Invalid'])

				if responseIndex == 0: #Command completed successfully
					queryResult=sshSession.before
					sshSession.sendline('exit')
				elif responseIndex == 1:
					print 'Failure to complete command'

			except pexpect.TIMEOUT:
				print "timeout error"

		except (pexpect.EOF, pexpect.TIMEOUT), e:
			print "Error running expect."

		resultByLine = queryResult.split('\n')
		for line in resultByLine:
			values=line.split()
			if len(values) > 1:
				if re.compile('^\.([A,B,C]){1,2}([0-9]){1,2}$').match(values[0]):
					print "    "+str(values[0])+" ("+str(values[2])+")  -  "+str(values[1])