import pexpect, sys, argparse, getpass, re

parser = argparse.ArgumentParser() #Use argparse for arguments/flags
parser.add_argument('username', help='Radius Username')
parser.add_argument('filename', help='File Name of hostname list, one per line')
args = parser.parse_args()

userPass = getpass.getpass()

# Value for New Key request
ssh_newkey = 'Are you sure you want to continue connecting \(yes\/no\)? '
command = 'ostat all'

with open(args.filename,'r') as file:
	for entry in file:
		tempValues = entry.split(',')

		hostname = tempValues[4]

		print "processing host "+hostname

		try:
			try:
				sshSession = pexpect.spawn('ssh %s@%s' % (args.username,hostname))
				#sshSession.logfile = sys.stdout
				responseIndex = sshSession.expect([ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)
				#sshSession.timeout = 30
				#print "set timout to 20sec"

				# accept new ssh key
				if responseIndex == 0:
					sshSession.sendline('yes')
					# re-run expect to process failure or password
					responseIndex=sshSession.expect([ssh_newkey,'[pP]assword:',pexpect.EOF], timeout=120)

				# respond to password request
				if responseIndex == 1:
					sshSession.sendline(userPass)
					#sshSession.expect(pexpect.EOF)
				elif responseIndex == 2:
					#raise MyException("Error logging into device")
					print "error in password request, found EOF"

				tracker = 1
				for outletIndex in range(6,14):
					sshSession.expect("Switched CDU: ")
					sshSession.sendline("set outlet name .AA"+str(tracker)+" "+tempValues[outletIndex])
					print tempValues[outletIndex]
					tracker+=1

				tracker = 1
				for outletIndex in range(14,22):
					sshSession.expect("Switched CDU: ")
					sshSession.sendline("set outlet name .AB"+str(tracker)+" "+tempValues[outletIndex])
					print tempValues[outletIndex]
					tracker+=1

				tracker = 1
				for outletIndex in range(22,30):
					sshSession.expect("Switched CDU: ")
					sshSession.sendline("set outlet name .AC"+str(tracker)+" "+tempValues[outletIndex])
					print tempValues[outletIndex]
					tracker+=1

			except pexpect.TIMEOUT:
				print "timeout error"

		except (pexpect.EOF, pexpect.TIMEOUT), e:
			print "Error running expect."