#!/bin/bash
# Usage: $0 <csv>
# This script is designed run an expect script to change
# temp limits across many CDUs in serial.
#
# Expected format of each line of the CSV is:
# <FQDN_of_CDU>,<High_Temp_Value_in_F>,<Low_Temp_Value_in_F>\n


###############################################################################
## Config #####################################################################
###############################################################################
EXPECT="./expect.sh"

###############################################################################
## Initial Checks #############################################################
###############################################################################
# Check argument count
if [ "$#" -ne 1 ]; then
    echo
    echo "Incorrect number of parameters"
    echo "Expected use: $0 <filesName>"
    echo
    exit
fi
echo && echo "Checking for file..."
# Check for file presence
FILE=$1
if [ ! -f $FILE ]; then
    echo
    echo "File $FILE does not exist"
    echo "Expected use: $0 <fileName>"
    echo
fi

###############################################################################
## Main Script ################################################################
###############################################################################
if [ -f $EXPECT ]; then
    # Read in username
    echo
    echo "Enter credentials for CDU testing..."
    echo
    echo -n "Username: "
    read USER
    # Read in password
    echo -n "Password: "
    read -s PASSW
    echo


    # Read in new default password
    echo -n "Password: "
    read -s PASSDEFAULT
    echo


    # Use specified file, processing for each line with contents placed into array
    while IFS=',' read -ra CDU; do
        # set array variables to readable var names
        ipAddress=${CDU[0]}
        #FQDN=${CDU[0]}
        #HIGHTEMP=${CDU[1]}
        #LOWTEMP=${CDU[2]}
        # run expect script
        $EXPECT "$ipAddress" "$USER" "$PASSW" "$PASSDEFAULT" &
        #$EXPECT "$ipAddress" "placeholder" "placeholder" "$USER" "$PASSW" &
    done < $FILE
    echo
else
    echo
    echo "Expect script not found: $EXPECT"
    echo
fi
