# Operation Mongoose (dashboard)
###DCOps Dashboard
General purpose Dashboard and API for inventory and task automation for the Datacenter Operations Team

###App Configuration File (~/.mongooserc)
This application utilizes an rc file to gather runtime configuaration information.
The rc file should be located in the home directory of the user initiating the application.

example:
<pre><code>
[WEBAPP]
listen_address: 0.0.0.0
listen_port: 80
debug: True
threaded: True
csrf_key: key
app_key: key

[DATABASE]
duth_database_uri: mysql://username:password@localhost/database_name
data_database_username: username
data_database_password: password
data_database_dbname database_name
mgdb_database_host: database_host
mgdb_database_dbname: database_name
mgdb_database_username: username
mgdb_database_password: password

[LDAP]
ldap_uri: ldaps://ldap-vip.internal.justin.tv:636/
ldap_protocol: 3
</code></pre>
Note: if utilizing a non-ephemeral port, the application must be started with sudo permissions

###Database Scheme
<pre><code>
CREATE TABLE `device` (
  `deviceID` int(11) NOT NULL AUTO_INCREMENT,
  `rackID` int(11) NOT NULL,
  `deviceTypeID` int(11) NOT NULL,
  `parentDeviceID` int(11) DEFAULT NULL,
  `deviceName` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `deviceSequence` varchar(64) CHARACTER SET latin1 DEFAULT NULL,
  `deviceSerial` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `purchaseDate` date DEFAULT NULL,
  `costInitial` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `decayRate` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `deviceNote` varchar(256) CHARACTER SET latin1 DEFAULT NULL,
  `deviceEnd` varchar(64) CHARACTER SET latin1 DEFAULT NULL,
  `deviceStatus` varchar(64) CHARACTER SET latin1 DEFAULT NULL,
  `uStart` int(11) DEFAULT NULL,
  PRIMARY KEY (`deviceID`),
  UNIQUE KEY `deviceName` (`deviceName`),
  KEY `rackID` (`rackID`),
  KEY `deviceTypeID` (`deviceTypeID`),
  KEY `parentDeviceID` (`parentDeviceID`),
  CONSTRAINT `device_ibfk_1` FOREIGN KEY (`rackID`) REFERENCES `rack` (`rackID`),
  CONSTRAINT `device_ibfk_2` FOREIGN KEY (`deviceTypeID`) REFERENCES `deviceType` (`deviceTypeID`),
  CONSTRAINT `device_ibfk_3` FOREIGN KEY (`parentDeviceID`) REFERENCES `device` (`deviceID`)
) ENGINE=InnoDB AUTO_INCREMENT=2316 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `deviceType` (
  `deviceTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `deviceRole` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `deviceMake` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `deviceModel` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `deviceTypeNote` varchar(256) CHARACTER SET latin1 DEFAULT NULL,
  `deviceTypeName` varchar(128) CHARACTER SET latin1 NOT NULL,
  `softwareVersion` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `uHeight` int(11) DEFAULT NULL,
  PRIMARY KEY (`deviceTypeID`),
  UNIQUE KEY `deviceTypeName` (`deviceTypeName`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `interface` (
  `intID` int(11) NOT NULL AUTO_INCREMENT,
  `deviceID` int(11) NOT NULL,
  `intType` varchar(128) CHARACTER SET latin1 NOT NULL,
  `connectorType` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `intName` varchar(128) CHARACTER SET latin1 NOT NULL,
  `intPosition` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `ipv4address` int(11) DEFAULT NULL,
  `ipv4Subnet` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `ipv4Gateway` int(11) DEFAULT NULL,
  `lastCleaned` date DEFAULT NULL,
  `intWattage` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `intLabel` varchar(256) CHARACTER SET latin1 DEFAULT NULL,
  `intNote` varchar(256) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`intID`),
  KEY `deviceID` (`deviceID`),
  CONSTRAINT `interface_ibfk_1` FOREIGN KEY (`deviceID`) REFERENCES `device` (`deviceID`)
) ENGINE=InnoDB AUTO_INCREMENT=6795 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `location` (
  `locationID` int(11) NOT NULL AUTO_INCREMENT,
  `locationCode` varchar(128) CHARACTER SET latin1 NOT NULL,
  `codeVersion` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `hostingProvider` varchar(256) CHARACTER SET latin1 DEFAULT NULL,
  `cageInformation` varchar(256) CHARACTER SET latin1 DEFAULT NULL,
  `contactPhone` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `contactEmail` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `amazonEntity` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `physicalAddress` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `locationNotes` varchar(256) CHARACTER SET latin1 DEFAULT NULL,
  `locationStatus` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `gMapAddress` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `gFolderID` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `powerChartLink` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `tempChartLink` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `humidityChartLink` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `voltageChartLink` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`locationID`),
  UNIQUE KEY `locationCode` (`locationCode`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `rack` (
  `rackID` int(11) NOT NULL AUTO_INCREMENT,
  `locationID` int(11) NOT NULL,
  `uCount` varchar(128) CHARACTER SET latin1 NOT NULL,
  `outsideHeight` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `outsideWidth` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `outsideDepth` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `rackNotes` varchar(256) CHARACTER SET latin1 DEFAULT NULL,
  `rackName` varchar(128) CHARACTER SET latin1 NOT NULL,
  `twitch_room` varchar(256) CHARACTER SET latin1 DEFAULT NULL,
  `provider_room` varchar(256) CHARACTER SET latin1 DEFAULT NULL,
  `rackStatus` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `providerRackName` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `powerFeedA` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `powerFeedB` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `powerFeedC` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `powerFeedD` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `rackSecNotes` varchar(228) CHARACTER SET latin1 DEFAULT NULL,
  `rackMakeInfo` varchar(228) CHARACTER SET latin1 DEFAULT NULL,
  `rackSubnet` varchar(20) CHARACTER SET latin1 DEFAULT NULL,
  `rackSequenceNo` varchar(10) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`rackID`),
  KEY `rack_ibfk_1` (`locationID`),
  CONSTRAINT `rack_ibfk_1` FOREIGN KEY (`locationID`) REFERENCES `location` (`locationID`)
) ENGINE=InnoDB AUTO_INCREMENT=1103 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
</code></pre>
