import ConfigParser
from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from flask_login import LoginManager
from flask_triangle import Triangle
from os.path import expanduser

# Setup Configuration Parser, and read from home directory
Config = ConfigParser.ConfigParser()
Config
Config.read(str(expanduser("~"))+"/.mongooserc")
#print str(expanduser("~"))


# Config parse helper function
def ConfigSectionMap(section):
    dict1 = {}
    options = Config.options(section)
    #print options
    for option in options:
        try:
            dict1[option] = Config.get(section, option)
            if dict1[option] == -1:
                DebugPrint("skip: %s" % option)
        except:
            print("exception on %s!" % option)
            dict1[option] = None
    return dict1

# Set variables based off of configuration file
# [WEBAPP]
hostAddress = ConfigSectionMap("WEBAPP")['listen_address']
port = int(ConfigSectionMap("WEBAPP")['listen_port'])
debug = bool(ConfigSectionMap("WEBAPP")['debug'])
threaded = bool(ConfigSectionMap("WEBAPP")['threaded'])
csrf_key = ConfigSectionMap("WEBAPP")['csrf_key']
app_key = ConfigSectionMap("WEBAPP")['app_key']
test = ConfigSectionMap("WEBAPP")['test']

# [DATABASE]
auth_database_uri = ConfigSectionMap("DATABASE")['auth_database_uri']
data_database_username = ConfigSectionMap("DATABASE")['data_database_username']
data_database_password = ConfigSectionMap("DATABASE")['data_database_password']
data_database_dbname = ConfigSectionMap("DATABASE")['data_database_dbname']
mgdb_database_host = ConfigSectionMap("DATABASE")['mgdb_database_host']
mgdb_database_dbName = ConfigSectionMap("DATABASE")['mgdb_database_dbname']
mgdb_database_username = ConfigSectionMap("DATABASE")['mgdb_database_username']
mgdb_database_password = ConfigSectionMap("DATABASE")['mgdb_database_password']

# [LDAP]
LDAP_URI = ConfigSectionMap("LDAP")['ldap_uri']
LDAP_protocol = str(ConfigSectionMap("LDAP")['ldap_protocol'])

# [IPMI]
ipmi_username = ConfigSectionMap("IPMI")['ipmi_username']
ipmi_password = ConfigSectionMap("IPMI")['ipmi_password']

# [TOOLING]
openGear_pub = ConfigSectionMap("TOOLING")['opengear_pub']
openGear_priv = ConfigSectionMap("TOOLING")['opengear_priv']

# create flask application
app = Flask(__name__)
Triangle(app)

# load 
app.config['SQLALCHEMY_DATABASE_URI'] = auth_database_uri
app.config['WTF_CSRF_SECRET_KEY'] = csrf_key
app.config['LDAP_PROVIDER_URL'] = LDAP_URI
app.config['LDAP_PROTOCOL_VERSION'] = LDAP_protocol
db = SQLAlchemy(app)

app.secret_key = app_key

login_manager = LoginManager()
login_manager.init_app(app)
login_manager.login_view = 'login'

from my_app.auth.views import auth
app.register_blueprint(auth)

from my_app.api.APIv2 import *
app.register_blueprint(api_r)

from my_app.data.views import data
app.register_blueprint(data)

from my_app.tools.views import tools
app.register_blueprint(tools)

db.create_all()
