import ldap
from flask_wtf import Form
from wtforms import TextField, PasswordField
from wtforms.validators import InputRequired
from my_app import db, app, data_database_username, \
    data_database_password, data_database_dbname, mgdb_database_host, \
    mgdb_database_dbName, mgdb_database_username, mgdb_database_password
 
 
def get_ldap_connection():
    conn = ldap.initialize(app.config['LDAP_PROVIDER_URL'])
    return conn

def search_by_uid(uid, ldap_conn):
    uid_filter = '(uid={})'.format(uid)
    users = ldap_conn.search_s('dc=justin,dc=tv', ldap.SCOPE_SUBTREE, uid_filter)
    if not users:
        return None, None
    return users.pop()

def getGroups(username):
    conn = get_ldap_connection()
    groups_list = []
    user_dn, user_data = search_by_uid(username,conn)
    group_filter = '(&(cn=*)(uniqueMember={}))'.format(user_dn)
    group_result = conn.search_s(
        "ou=Groups,{}".format('dc=justin,dc=tv'),
        ldap.SCOPE_SUBTREE,
        group_filter
    )
    if len(group_result) > 0:
        for group in group_result:
            group_name = group[1]['cn'][0]
            groups_list.append(group_name)
        print str(groups_list)
        return groups_list
    return []


####
#### Note: User model does not take into account changing LDAP groups.
####   This will need to be addressed in future versions.
####

class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String(100))
    sshPubKey = db.Column(db.String(1024))
    groups_list = db.Column(db.String(256))
    groups_readable = db.Column(db.String(256))


    def __init__(self, username, password, groups):
        self.username = username
        self.groups_list = str(groups)
        self.groups_readable = str(', '.join(groups))

    @staticmethod
    def try_login(username, password):
        conn = get_ldap_connection()
        user_dn, user_data = search_by_uid(username,conn)
        print user_dn
        print user_data
        conn.simple_bind_s(user_dn, str(password))

    def is_authenticated(self):
        print "Authed"
        return True
 
    def is_active(self):
        return True

    @staticmethod
    def is_admin(self):
        if 'team-dcops' in self.groups_list:
            return True
        return False
 
    def is_anonymous(self):
        return False
 
    def get_id(self):
        return unicode(self.id)
 
 
class LoginForm(Form):
    username = TextField('Username', [InputRequired()])
    password = PasswordField('Password', [InputRequired()])

class userSettingsForm(Form):
    sshKey = TextField('SSH Key')
