import sys
import ldap
from flask import request, render_template, flash, redirect, \
    url_for, Blueprint, g
from flask_login import current_user, login_user, \
    logout_user, login_required
from my_app import login_manager, db, data_database_username, \
    data_database_password, data_database_dbname, mgdb_database_host, \
    mgdb_database_dbName, mgdb_database_username, mgdb_database_password
from my_app.auth.models import User, LoginForm, getGroups, userSettingsForm

import mysql.connector
from flask import Flask, render_template, request, redirect, json, jsonify, send_from_directory

auth = Blueprint('auth', __name__)
 
 
@login_manager.user_loader
def load_user(id):
    return User.query.get(int(id))
 
 
@auth.before_request
def get_current_user():
    g.user = current_user
 
 
@auth.route('/')
@auth.route('/home')
def home():
    return render_template('home.html')
 
 
@auth.route('/login', methods=['GET', 'POST'])
def login():

    if current_user.is_authenticated:
        flash('You are already logged in.','warning')
        return redirect(url_for('auth.home'))
 
    form = LoginForm(request.form)
 
    if request.method == 'POST' and form.validate():
        username = request.form.get('username')
        password = request.form.get('password')
 
        try:
            User.try_login(username, password)
        except ldap.INVALID_CREDENTIALS:
            flash(
                'Invalid username or password. Please try again.',
                'danger')
            return render_template('login.html', form=form)
 
        user = User.query.filter_by(username=username).first()
 
        if not user:
            #groups = User.getGroups(username)
            user = User(username, password, getGroups(username))
            db.session.add(user)
            db.session.commit()
        login_user(user)
        flash('You have successfully logged in.', 'success')
        return redirect(url_for('auth.home'))
 
    if form.errors:
        flash(form.errors, 'danger')
 
    return render_template('login.html', form=form)
 
@auth.route('/logout')
@login_required
def logout():
    logout_user()
    return redirect(url_for('auth.home'))

@auth.route('/user_settings', methods=['GET', 'POST'])
def user_settings():
    if current_user.is_authenticated:

        form = userSettingsForm(request.form)

        if request.method == 'POST' and form.validate():
            
            current_user.sshPubKey=request.form.get('sshKey')
            db.session.commit()

        return render_template('user_settings.html',form=form)

    flash('Incorrect Permissions to Access Page','danger')
    return redirect(url_for('auth.home'))

@auth.route('/edit_pop')
def edit_pop():
    if current_user.is_authenticated:
        print "Edit Pop Page - User:" + str(current_user.username)
        readDevice = request.values.get('deviceName')
        if readDevice is not None:
            deviceDict={'testKey':'testValue'}
            return render_template('edit_pop.html',deviceInfo=deviceDict)
        flash('No Device Selected','warning')
        return redirect(url_for('auth.pop'))
    flash('Incorrect Permissions to Access Page','danger')
    return redirect(url_for('auth.home'))


@auth.route('/api/read',methods=['GET','POST'])
def api_read():
    if current_user.is_authenticated:
        readType = request.values.get('item')
        readSite = request.values.get('site')
        readName = request.values.get('name')
        readSelect = request.values.get('sel')
        cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
        cursor = cnx.cursor(dictionary=True)
        try:
            if readType == 'pop':
                query = ("SELECT locationCode, physicalAddress, hostingProvider, cageInformation FROM location")
            elif readType == 'pop_all':
                query = ("SELECT * FROM location WHERE locationCode=\"" + readSite + "\"")

            # triggers for rack reads without selections
            elif readType == 'rack' and readSelect is None:
                query = ("SELECT rackName " \
                    + "FROM rack JOIN location " \
                    + "ON rack.locationID=location.locationID")

            # triggers for rack reads with selections
            elif readType == 'rack' and readSelect is not None:
                query = ("SELECT " + readSelect \
                    + " FROM rack JOIN location " \
                    + "ON rack.locationID=location.locationID")

            # triggers for device reads 
            elif readType == 'dcopsDevice' and readSelect is not None:
                query = ("SELECT deviceName FROM device")

            # triggers for devices with a specific name being searched
            elif readType == 'dcopsDevice' and readName is not None:
                query = ("SELECT device.deviceName as 'name', INET_NTOA(interface.ipv4address) as 'ip', \
                    location.locationCode as 'location', rack.rackName as 'rack', \
                    device.devicePosition as 'position', \
                    deviceType.software as 'software_version', \
                    device.note as 'notes' \
                    FROM device \
                    JOIN interface on device.deviceID=interface.deviceID \
                    JOIN deviceType on device.deviceTypeID=deviceType.deviceTypeID \
                    JOIN rack on device.rackID=rack.rackID \
                    JOIN location on rack.locationID=location.locationID \
                    WHERE interface.intType='logical:mgmt' \
                    AND device.deviceName= '" + readName + "'")

            elif readType == 'dcopsDevice':
                query = ("SELECT device.deviceName AS 'name', INET_NTOA(interface.ipv4address) AS 'mgmtIP' FROM device JOIN interface ON device.deviceID=interface.deviceID WHERE interface.intType='logical:mgmt'")

            # triggers for invalid query requests                
            else:
                return "ERROR: invalid argument(s) - invalid query"    
            cursor.execute(query)
        except mysql.connector.errors.ProgrammingError:
            print "ERROR: invalid argument(s) - query attempt failure"
            print query
            return "ERROR: invalid argument(s) - query attempt failure"
        data = cursor.fetchall()
        cursor.close()
        cnx.close()
        # return a json formatted result from the query
        return jsonify(result=data)
    return "NOT AUTHENTICATED"

@auth.route('/api/read_server',methods=['GET'])
def returnServers():
    cnx = mysql.connector.connect(user=mgdb_database_username,password=mgdb_database_password,database=mgdb_database_dbName,host=mgdb_database_host)
    cursor = cnx.cursor(dictionary=True)
    try:
        query = ("SELECT devices.name as 'name', " \
            + "device_parameters.value as 'serial', "\
            + "intAddresses.label as 'intLabel', "\
            + "intAddresses.macaddress as 'intMAC', "\
            + "INET_NTOA(intAddresses.ip) as 'intAddress', "\
            + "ipmiAddresses.macaddress as 'ipmiMAC', " \
            + "INET_NTOA(ipmiAddresses.ip) as 'ipmiAddress' "\
            + "FROM devices "\
            + "JOIN ip_addresses AS intAddresses "\
            + "ON devices.id=intAddresses.device_id "\
            + "JOIN ip_addresses AS ipmiAddresses "\
            + "ON devices.id=ipmiAddresses.device_id "\
            + "JOIN device_parameters "\
            + "ON devices.id=device_parameters.device_id "\
            + "WHERE ipmiAddresses.label='ipmi' "\
            + "AND intAddresses.label!='ipmi' " \
            + "AND device_parameters.name='serial_no'")
        cursor.execute(query)
    except mysql.connector.errors.ProgrammingError:
        return "ERROR: invalid argument(s) - query failure"
    # return a json formatted result from the query
    return jsonify(result=cursor.fetchall())
    cursor.close()
    cnx.close()

@auth.route('/api/write',methods=['GET','POST'])
def api_write():
    if current_user.is_authenticated:
        print "Write API - User:" + str(current_user.username)
        if current_user.is_admin(current_user):
            # Method should be "update" or "create"
            writeMethod = request.values.get('method')
            # Subject is the data type and assumed table name in the DB
            writeSubject = request.values.get('subject')
            writeID=0
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)
            try:
                if writeMethod == 'update':
                    #generate ID field based off of device type
                    writeSubjectID = str(writeSubject) + "ID"
                    #create list type variable from updateValues recieved in request
                    writeKeyList = request.values.get('updateValues').split(",")
                    #remove ID field from list
                    del writeKeyList[writeKeyList.index(writeSubjectID)]
                    #generate comma deliniated string based off of key list
                    writeKeyString = ",".join(writeKeyList)
                    #save ID value for given subject
                    writeSubjectValue = request.values.get(writeSubjectID)
                    writeID=writeSubjectValue
                    add_string = str("UPDATE " + writeSubject + " SET ")
                    add_data = {}
                    x=0
                    for key in writeKeyList:
                        #if request.values.get(key):
                        add_data[key]=request.values.get(key)
                        if x > 0:
                            add_string+=", "
                        #add_string+=(str(key)+"=\""+str(request.values.get(key)))
                        add_string+=(str(key)+"=%("+str(key)+")s")
                        x+=1
                    add_string+=str(" WHERE " + str(writeSubjectID) + "=" + str(writeSubjectValue))
                elif writeMethod == 'new':
                    writeSubjectID = str(writeSubject) + "ID"
                    writeKeyList = request.values.get('updateValues').split(",")
                    writeKeyString = ",".join(writeKeyList)
                    add_string = str("INSERT INTO " + writeSubject + " (" + writeKeyString + ") VALUES (")
                    add_data = {}
                    x=0
                    for key in writeKeyList:
                        #if request.values.get(key):
                        ###########
                        # Commented out to adjustment for ID frilds on front-end
                        # this also ensure appropriate lookups are made for additions
                        ###########
                        #if key='deviceName':
                        #    add_data[key]="(SELECT deviceID FROM device WHERE deviceName='" + request.values.get(key) +"')"
                        #elif key='rackName':
                        #else:
                        ############
                        add_data[key]=request.values.get(key)
                        if x > 0:
                            add_string+=", "
                        #add_string+=(str(key)+"=\""+str(request.values.get(key)))
                        add_string+="%("+str(key)+")s"
                        x+=1
                    add_string+=str(")")
                else:
                    return jsonify(result={'success':False,'message':'ERROR: invalid argument(s) - invalid query'})
                
                ###################################
                # Query Most Likely Failing Due to the string format... 
                # example string: UPDATE rack SET rackName="r01", rackStatus="current", providerRackName="D35 - please verify ", provider_room="room50-zone2", rackNotes="key access" WHERE rackID=679
                # string works in mysql terminal but not when generated as the "add_string" variable
                # reference docs: http://dev.mysql.com/doc/connector-python/en/connector-python-example-cursor-transaction.html
                ###################################
                
                cursor.execute(add_string,add_data)

                if writeMethod != 'update':
                    writeID = cursor.lastrowid

                ####### user for "add" method
                #query=("SELECT * FROM "+ writeSubject + " WHERE " + writeSubject +"ID=" + str(writeID))
                #cursor.execute(query)
                cnx.commit()
            
            except mysql.connector.errors.ProgrammingError:
                print query
                return jsonify(result={'success':False,'message':'ERROR: invalid argument(s) - query attempt failure'})
            cursor.close()
            cnx.close()
            # return a json formatted result from the query
            return jsonify(result={'success':True,'message':'Possible Success, Not Verified - writeID=' + str(writeID)})
            #return jsonify(result=cursor.fetchall())
        return "USER DOES NOT HAVE PRIVILEDGES TO COMPLETE THIS ACTION"
    return "NOT AUTHENTICATED"
