import sys
import ldap
import mysql.connector
from flask import Flask, json, jsonify, send_from_directory, request, render_template, flash, redirect, url_for, Blueprint, g
from flask_login import current_user
from my_app import login_manager, data_database_username, \
    data_database_password, data_database_dbname, mgdb_database_host, \
    mgdb_database_dbName, mgdb_database_username, mgdb_database_password
from flask_wtf import Form
from wtforms import TextField, validators, RadioField, StringField, BooleanField, SubmitField, TextAreaField, SelectField
from wtforms.validators import DataRequired, InputRequired


data = Blueprint('data', __name__)

class popEditForm(Form):
    username = TextField('Username',default="test")
    locationCode = TextField('Site Name')
    locationStatus = TextField('Site Status')
    hostingProvider = TextField('Hosting Provider')
    physicalAddress = TextField('Physical Address')
    contactEmail = TextField('Contact Email')
    contactPhone = TextField('Contact Phone No')
    cageInformation = TextField('Cage Information')
    amazonEntity = TextField('Amazon Entity')
    locationNotes = TextField('Location Notes')
    gFolderID = TextField('Google Folder ID')
    gMapAddress = TextField('Location Coordinates')
    tempChartLink = TextField('Temp Chart Link')
    humidityChartLink = TextField('Humidity Chart Link')
    powerChartLink = TextField('Power Chart Link')

class intEditForm(Form):
    deviceID = SelectField('Device')
    intType = SelectField(
        'Interface Type',
        choices=[
            ('None','None'),
            ('name', 'value'),
            ('logical:mgmt', 'logical:mgmt'),
            ('physical:data', 'physical:data'),
            ('logical:data', 'logical:data'),
            ('physical:power', 'physical:power'),
            ('physical:outlet', 'physical:outlet'),
            ('physical:console', 'physical:console'),
            ('physical:serial', 'physical:serial')
        ]
    )
    connectorType = SelectField(
        'Connector Type',
        choices=[
            ('None','None'),
            ('LC','LC'),
            ('SC','SC'),
            ('MTP','MTP'),
            ('C20','C20'),
            ('C16','C16'),
            ('C14','C14'),
            ('RJ45','RJ45')
        ]
    )
    intName = TextField('Interface Name')
    intPosition = SelectField(
        'Interface Position',
        choices=[
            ('None','None'),
            ('face', 'device face'),
            ('rear', 'device rear')
        ]
    )
    ipv4address = TextField('IPv4 Address')
    ipv4Subnet = TextField('IPv4 Subnet')
    ipv4Gateway = TextField('IPv4 Gateway')
    lastCleaned = TextField('Last Cleaned')
    intVoltage = TextField('Voltage')
    intLabel = TextField('Interface Label')
    intNote = TextField('Interface Notes')


@data.route('/')
@data.route('/home', methods=['get'])
def home():
    cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
    cursor = cnx.cursor(dictionary=True)
    version = request.values.get('include')
    includeBol = False;
    if version:
        if "upcomming" in version:
            query = (
                "SELECT locationCode,gMapAddress FROM location WHERE gMapAddress!='None'" + \
                " AND ( locationStatus='current' " + \
                " OR locationStatus='upcomming')")
            includeBol = True;
    else:
        query = ("SELECT locationCode,gMapAddress FROM location WHERE gMapAddress!='None' AND locationStatus='current'")
    try:
        cursor.execute(query)
        popRawData=cursor.fetchall()
    except: 
        cursor.close()
        cnx.close()
        flash('ERRROR: '+str(sys.exc_info()),'danger')
        return render_template('home.html')
    popInfoDict = {}
    for siteValue in popRawData:
        popInfoDict[siteValue['locationCode']]=siteValue['gMapAddress']
    return render_template('home.html', popDict=popInfoDict, includeBol=includeBol)

@data.route('/info_panel', methods=['get'])
def info_panel():
    cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
    cursor = cnx.cursor(dictionary=True)
    query = ("SELECT locationCode,gMapAddress FROM location WHERE gMapAddress!='None' AND locationStatus='current'")
    try:
        cursor.execute(query)
        popRawData=cursor.fetchall()
    except: 
        cursor.close()
        cnx.close()
        flash('ERRROR: '+str(sys.exc_info()),'danger')
        return render_template('home.html')
    popInfoDict = {}
    for siteValue in popRawData:
        popInfoDict[siteValue['locationCode']]=siteValue['gMapAddress']

    backboneLinkList = [
        [popInfoDict['SFO01'],popInfoDict['SJC02']],
        [popInfoDict['SFO01'],popInfoDict['IAD02']],
        [popInfoDict['SFO01'],popInfoDict['SJC01']],
        [popInfoDict['SFO01'],popInfoDict['DFW01']],
        [popInfoDict['SFO01'],popInfoDict['LAX01']],
        [popInfoDict['SFO01'],popInfoDict['SEA01']],
        [popInfoDict['LAX01'],popInfoDict['HKG01']],
        [popInfoDict['LAX01'],popInfoDict['SJC01']],
        [popInfoDict['LAX01'],popInfoDict['TYO02']],
        [popInfoDict['LAX01'],popInfoDict['DFW01']],
        [popInfoDict['SJC02'],popInfoDict['SJC01']],
        [popInfoDict['SEA01'],popInfoDict['SJC01']],
        [popInfoDict['SEA01'],popInfoDict['SBN01']],
        [popInfoDict['SEA01'],popInfoDict['ORD02']],
        [popInfoDict['SEA01'],popInfoDict['TYO02']],
        [popInfoDict['SJC01'],popInfoDict['ORD02']],
        [popInfoDict['SJC01'],popInfoDict['SYD01']],
        [popInfoDict['TYO01'],popInfoDict['TYO02']],
        [popInfoDict['TYO02'],popInfoDict['SEL01']],
        [popInfoDict['HKG01'],popInfoDict['SEL01']],
        [popInfoDict['HKG01'],popInfoDict['TYO02']],
        [popInfoDict['HKG01'],popInfoDict['SJC01']],
        [popInfoDict['ORD02'],popInfoDict['JFK03']],
        [popInfoDict['ORD02'],popInfoDict['IAD02']],
        [popInfoDict['ORD02'],popInfoDict['DFW01']],
        [popInfoDict['SBN01'],popInfoDict['JFK03']],
        [popInfoDict['JFK03'],popInfoDict['JFK01']],
        [popInfoDict['JFK03'],popInfoDict['IAD02']],
        [popInfoDict['IAD02'],popInfoDict['DFW01']],
        [popInfoDict['IAD02'],popInfoDict['MIA02']],
        [popInfoDict['IAD02'],popInfoDict['JFK01']],
        [popInfoDict['IAD02'],popInfoDict['AMS01']],
        [popInfoDict['IAD02'],popInfoDict['LHR01']],
        [popInfoDict['JFK01'],popInfoDict['AMS01']],
        [popInfoDict['JFK01'],popInfoDict['LHR01']],
        [popInfoDict['LHR02'],popInfoDict['LHR01']],
        [popInfoDict['LHR02'],popInfoDict['CDG01']],
        [popInfoDict['LHR02'],popInfoDict['FRA01']],
        [popInfoDict['CDG01'],popInfoDict['FRA01']],
        [popInfoDict['CDG01'],popInfoDict['AMS01']],
        [popInfoDict['LHR01'],popInfoDict['AMS01']],
        [popInfoDict['AMS01'],popInfoDict['FRA01']],
        [popInfoDict['AMS01'],popInfoDict['ARN01']],
        [popInfoDict['AMS01'],popInfoDict['WAW01']],
        [popInfoDict['FRA01'],popInfoDict['ARN01']],
        [popInfoDict['FRA01'],popInfoDict['PRG01']],
        [popInfoDict['DFW01'],popInfoDict['MIA02']],
        [popInfoDict['PRG01'],popInfoDict['WAW01']]

    ]
    return render_template('info_panel.html', popDict=popInfoDict, backboneLinkList=backboneLinkList)

@data.route('/map', methods=['get'])
def map():
    cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
    cursor = cnx.cursor(dictionary=True)
    query = ("SELECT locationCode,gMapAddress FROM location WHERE gMapAddress!='None' AND locationStatus='current'")
    try:
        cursor.execute(query)
        popRawData=cursor.fetchall()
    except: 
        cursor.close()
        cnx.close()
        flash('ERRROR: '+str(sys.exc_info()),'danger')
        return render_template('home.html')
    popInfoDict = {}
    for siteValue in popRawData:
        popInfoDict[siteValue['locationCode']]=siteValue['gMapAddress']

    backboneLinkList = [
        [popInfoDict['SFO01'],popInfoDict['SJC02']],
        [popInfoDict['SFO01'],popInfoDict['IAD02']],
        [popInfoDict['SFO01'],popInfoDict['SJC01']],
        [popInfoDict['SFO01'],popInfoDict['DFW01']],
        [popInfoDict['SFO01'],popInfoDict['LAX01']],
        [popInfoDict['SFO01'],popInfoDict['SEA01']],
        [popInfoDict['LAX01'],popInfoDict['HKG01']],
        [popInfoDict['LAX01'],popInfoDict['SJC01']],
        [popInfoDict['LAX01'],popInfoDict['TYO02']],
        [popInfoDict['LAX01'],popInfoDict['DFW01']],
        [popInfoDict['SJC02'],popInfoDict['SJC01']],
        [popInfoDict['SEA01'],popInfoDict['SJC01']],
        [popInfoDict['SEA01'],popInfoDict['SBN01']],
        [popInfoDict['SEA01'],popInfoDict['ORD02']],
        [popInfoDict['SEA01'],popInfoDict['TYO02']],
        [popInfoDict['SJC01'],popInfoDict['ORD02']],
        [popInfoDict['SJC01'],popInfoDict['SYD01']],
        [popInfoDict['TYO01'],popInfoDict['TYO02']],
        [popInfoDict['TYO02'],popInfoDict['SEL01']],
        [popInfoDict['HKG01'],popInfoDict['SEL01']],
        [popInfoDict['HKG01'],popInfoDict['TYO02']],
        [popInfoDict['HKG01'],popInfoDict['SJC01']],
        [popInfoDict['ORD02'],popInfoDict['JFK03']],
        [popInfoDict['ORD02'],popInfoDict['IAD02']],
        [popInfoDict['ORD02'],popInfoDict['DFW01']],
        [popInfoDict['SBN01'],popInfoDict['JFK03']],
        [popInfoDict['JFK03'],popInfoDict['JFK01']],
        [popInfoDict['JFK03'],popInfoDict['IAD02']],
        [popInfoDict['IAD02'],popInfoDict['DFW01']],
        [popInfoDict['IAD02'],popInfoDict['MIA02']],
        [popInfoDict['IAD02'],popInfoDict['JFK01']],
        [popInfoDict['IAD02'],popInfoDict['AMS01']],
        [popInfoDict['IAD02'],popInfoDict['LHR01']],
        [popInfoDict['JFK01'],popInfoDict['AMS01']],
        [popInfoDict['JFK01'],popInfoDict['LHR01']],
        [popInfoDict['LHR02'],popInfoDict['LHR01']],
        [popInfoDict['LHR02'],popInfoDict['CDG01']],
        [popInfoDict['LHR02'],popInfoDict['FRA01']],
        [popInfoDict['CDG01'],popInfoDict['FRA01']],
        [popInfoDict['CDG01'],popInfoDict['AMS01']],
        [popInfoDict['LHR01'],popInfoDict['AMS01']],
        [popInfoDict['AMS01'],popInfoDict['FRA01']],
        [popInfoDict['AMS01'],popInfoDict['ARN01']],
        [popInfoDict['AMS01'],popInfoDict['WAW01']],
        [popInfoDict['FRA01'],popInfoDict['ARN01']],
        [popInfoDict['FRA01'],popInfoDict['PRG01']],
        [popInfoDict['DFW01'],popInfoDict['MIA02']],
        [popInfoDict['PRG01'],popInfoDict['WAW01']]
    ]
    return render_template('map.html', popDict=popInfoDict, backboneLinkList=backboneLinkList)

@data.route('/device')
def device():
    return render_template('device.html')

@data.route('/pop')
def pop():
    return render_template('pop.html')

@data.route('/server')
def server():
    return render_template('server.html')

@data.route('/rack')
def rack():
    return render_template('rack.html')

@data.route('/pop_details', methods=['GET', 'POST'])
def pop_details():
    # if current_user.is_authenticated:
    #     #try:
    #     # Gather device name from argument
    #     locationName = request.values.get('name')

    #     # Gather device specific information and provide to template
    #     cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
    #     cursor = cnx.cursor(dictionary=True)

    #     query = ("SELECT * FROM location WHERE locationCode='"+str(locationName)+"'")
    #     try:
    #         cursor.execute(query)
    #         popTempDict=cursor.fetchall()[0]
    #     except: 
    #         cursor.close()
    #         cnx.close()
    #         print "ERROR:", sys.exc_info()
    #         flash('ERRROR: POP Not Found','danger')
    #         return redirect(url_for('data.pop'))

    #     # Create form
    #     form = popEditForm(request.form)


    #     # add in ?site={{popTempDict['locationCode']}} to html to ensure the GET also takes place
    #     if request.method == 'POST' and form.validate():
    #         postData={}

    #         # Temporary so I can remember that the locationID is already gathered previously
    #         locationID = popTempDict['locationID']

    #         # Create dict off of POST data
    #         try:
    #             if str(request.form.get('locationID')) != str(popTempDict['locationID']):
    #                 flash('Error in edit pop data, expected ID and Code data for POP '+str(popTempDict['locationCode']), 'danger')
    #             postData['locationCode'] = request.form.get('locationCode')
    #             postData['locationStatus'] = request.form.get('locationStatus')
    #             postData['hostingProvider'] = request.form.get('hostingProvider')
    #             postData['physicalAddress'] = request.form.get('physicalAddress')
    #             postData['contactEmail'] = request.form.get('contactEmail')
    #             postData['contactPhone'] = request.form.get('contactPhone')
    #             postData['cageInformation'] = request.form.get('cageInformation')
    #             postData['amazonEntity'] = request.form.get('amazonEntity')
    #             postData['locationNotes'] = request.form.get('locationNotes')
    #             postData['gFolderID']  = request.form.get('gFolderID')
    #             postData['gMapAddress'] = request.form.get('gMapAddress')
    #             postData['tempChartLink'] = request.form.get('tempChartLink')
    #             postData['humidityChartLink'] = request.form.get('humidityChartLink')
    #             postData['powerChartLink'] = request.form.get('powerChartLink')
    #         except:
    #             flash('Error in edit pop data', 'danger')

    #         # generate string for mysql update
    #         add_string = str("UPDATE location SET ")
    #         x=0
    #         for key,value in postData.iteritems():
    #             if x > 0:
    #                 add_string+=", "
    #             #add_string+=(str(key)+"=\""+str(request.values.get(key)))
    #             add_string+=(str(key)+"=%("+str(key)+")s")
    #             x+=1
    #         add_string+=str(" WHERE locationID=" + str(popTempDict['locationID']))
    #         try:
    #             # execute mysql insert and comit insert
    #             cursor.execute(add_string,postData)
    #             cnx.commit()
    #             flash('Updated '+postData['locationCode']+' pop in database', 'success')

    #             # Re-Gather location information
    #             newQuery = ("SELECT * FROM rack WHERE locationID="+str(popTempDict['locationID']))
    #             try:
    #                 cursor.execute(newQuery)
    #                 rackInfoDict=cursor.fetchall()
    #             except: 
    #                 cursor.close()
    #                 cnx.close()
    #                 print "ERROR:", sys.exc_info()
    #                 flash('ERRROR: POP Gether POP Details','danger')
    #                 return redirect(url_for('data.pop'))
    #         except:
    #             flash('Error with database write', 'danger')

    #     query = ("SELECT * FROM location WHERE locationCode='"+str(locationName)+"'")
    #     try:
    #         cursor.execute(query)
    #         popInfoDict=cursor.fetchall()[0]
    #     except: 
    #         cursor.close()
    #         cnx.close()
    #         print "ERROR:", sys.exc_info()
    #         flash('ERRROR: POP Not Found','danger')
    #         return redirect(url_for('data.pop'))

    #     # Gather rack information for pop and provide to template
    #     query = ("SELECT * FROM rack WHERE locationID="+str(popInfoDict['locationID']))
    #     try:
    #         cursor.execute(query)
    #         rackInfoDict=cursor.fetchall()
    #     except: 
    #         cursor.close()
    #         cnx.close()
    #         print "ERROR:", sys.exc_info()
    #         flash('ERRROR: POP Gether POP Details','danger')
    #         return redirect(url_for('data.pop'))

        

    #     # Close MYSQL connector
    #     cursor.close()
    #     cnx.close()

    #     if form.errors:
    #         flash(form.errors, 'danger')

    #     # Return template with gathered information
    #     return render_template('pop_details.html', form=form,popInfoDict=popInfoDict, rackInfoDict=rackInfoDict)
    #     #except:
    #     #    print "ERROR:", sys.exc_info()
    #     #    flash(('ERRROR: '+str(sys.exc_info())),'danger')
    #     #    return redirect(url_for('data.pop'))
    # flash('Authentication Required','danger')
    # return redirect(url_for('data.home'))

    if current_user.is_authenticated:

        #try:
        # Gather device name from argument
        locationCode_get = request.values.get('site').upper()


        cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
        cursor = cnx.cursor(dictionary=True)

        print "LOCATION CODE: " + str(locationCode_get)

        query = ("SELECT locationID,locationCode FROM location")
        try:
            cursor.execute(query)
            locationList=cursor.fetchall()
        except: 
            cursor.close()
            cnx.close()
            print "ERROR:", sys.exc_info()
            flash('ERRROR: Rack Not Found','danger')
            #return redirect(url_for('data.rack'))

        locationDict={}
        for entry in locationList:
            locationDict[entry['locationCode']]=entry['locationID']
        if locationCode_get not in locationDict:
            flash('ERRROR: Rack Not Found','danger')
            #return redirect(url_for('data.rack'))


        query = ("SELECT * FROM location WHERE locationID="+str(locationDict[locationCode_get]))
        try:
            cursor.execute(query)
            tempResponse=cursor.fetchall()
            if len(tempResponse) != 1:
                flash('ERRROR: POP Not Found','danger')
                #return redirect(url_for('data.rack'))
            else:
                locationInfoDict=tempResponse[0]
        except: 
            cursor.close()
            cnx.close()
            print "ERROR:", sys.exc_info()
            flash('ERRROR: POP Not Found','danger')
            #return redirect(url_for('data.rack'))

        # Gather device information for rack and provide to template
        query = ("SELECT rackName,uCount,rackSubnet,rackNotes,rackStatus FROM rack WHERE locationID="+str(locationDict[locationCode_get]))
        cursor.execute(query)
        rackInfoArrayDict=cursor.fetchall()
        cursor.close()
        cnx.close()

        # Return template with gathered information
        return render_template('pop_details.html',locationDict=locationDict,locationCode=locationCode_get,rackInfoDict=rackInfoArrayDict)
    flash('Authentication Required','danger')
    return redirect(url_for('data.home'))

@data.route('/layout_test', methods=['GET'])
def layout_test():
    if current_user.is_authenticated:

        #try:
        # Gather device name from argument
        locationCode_get = request.values.get('site').upper()
        rackName_get = request.values.get('rack')

        # Gather device specific information and provide to template
        cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
        cursor = cnx.cursor(dictionary=True)
        query = ("SELECT locationID,locationCode FROM location")
        try:
            cursor.execute(query)
            locationList=cursor.fetchall()
        except: 
            cursor.close()
            cnx.close()
            print "ERROR:", sys.exc_info()
            flash('ERRROR: Rack Not Found','danger')
            return redirect(url_for('data.rack'))

        locationDict={}
        for entry in locationList:
            locationDict[entry['locationCode']]=entry['locationID']
        if locationCode_get not in locationDict:
            flash('ERRROR: Rack Not Found','danger')
            return redirect(url_for('data.rack'))


        query = ("SELECT * FROM rack WHERE rackName='"+str(rackName_get)+"' and locationID="+str(locationDict[locationCode_get]))
        try:
            cursor.execute(query)
            tempResponse=cursor.fetchall()
            if len(tempResponse) != 1:
                flash('ERRROR: Rack Not Found','danger')
                return redirect(url_for('data.rack'))
            else:
                rackInfoDict=tempResponse[0]
        except: 
            cursor.close()
            cnx.close()
            print "ERROR:", sys.exc_info()
            flash('ERRROR: Rack Not Found','danger')
            return redirect(url_for('data.rack'))

        # Gather device information for rack and provide to template
        query = ("SELECT deviceName,deviceSerial,device.deviceTypeID AS deviceTypeID,uStart,uHeight FROM device JOIN deviceType ON device.deviceTypeID=deviceType.deviceTypeID WHERE rackID="+str(rackInfoDict['rackID']))
        cursor.execute(query)
        deviceInfoArrayDict=cursor.fetchall()


        deviceTempDict={}
        for deviceElement in deviceInfoArrayDict:
            deviceTempDict[deviceElement['uStart']]={'deviceName':deviceElement['deviceName'],'uHeight':deviceElement['uHeight']}
        deviceLayoutDict={}
        uLevelCounter=1
        while uLevelCounter <= int(rackInfoDict['uCount']):
            if uLevelCounter in deviceTempDict:
                startingU=int(uLevelCounter)
                chassisHeightCounter=int(deviceTempDict[uLevelCounter]['uHeight'])
                while chassisHeightCounter > 0:
                    if chassisHeightCounter > 1:
                        deviceLayoutDict[uLevelCounter]={'deviceName':'empty','uHeight':0}
                        uLevelCounter+=1
                    elif chassisHeightCounter == 1:
                        deviceLayoutDict[uLevelCounter]=deviceTempDict[startingU]
                        uLevelCounter+=1
                    chassisHeightCounter-=1
            else:
                deviceLayoutDict[uLevelCounter]={'deviceName':'empty','uHeight':1}
                uLevelCounter+=1

        counterReverse=int(rackInfoDict['uCount'])
        finalLayout={}
        for x in range(1,int(rackInfoDict['uCount'])+1):
            finalLayout[x]=deviceLayoutDict[counterReverse]
            finalLayout[x]['uLevel']=counterReverse
            counterReverse-=1


        # Gather device types and provide to template
        query = ("SELECT deviceTypeID,deviceTypeName,deviceRole,deviceMake,deviceModel," \
            + "deviceTypeNote,softwareVersion,uHeight FROM deviceType")
        cursor.execute(query)
        deviceTypesAvailable=cursor.fetchall()
        cursor.close()
        cnx.close()
        deviceTypeDict={}
        for entry in deviceTypesAvailable:
            tempList=[
                entry['deviceRole'],
                entry['deviceTypeName'],
                entry['deviceMake'],
                entry['deviceModel'],
                entry['deviceTypeNote'],
                entry['softwareVersion'],
                entry['uHeight']
            ]
            deviceTypeDict[entry['deviceTypeID']]=tempList

        # Return template with gathered information
        return render_template('layout_test.html',rackInfoDict=rackInfoDict,deviceTypeDict=deviceTypeDict,deviceLayoutDict=deviceLayoutDict,finalLayout=finalLayout)
        # except:
        #     cursor.close()
        #     cnx.close()
        #     print "ERROR:", sys.exc_info()
        #     flash(('ERRROR: '+str(sys.exc_info())),'danger')
        #     return redirect(url_for('data.device'))
    flash('Authentication Required','danger')
    return redirect(url_for('data.home'))

@data.route('/rack_details', methods=['GET'])
def rack_details():
    if current_user.is_authenticated:

        #try:
        # Gather device name from argument
        locationCode_get = request.values.get('site').upper()
        rackName_get = request.values.get('rack')

        # Gather device specific information and provide to template
        cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
        cursor = cnx.cursor(dictionary=True)
        query = ("SELECT locationID,locationCode FROM location")
        try:
            cursor.execute(query)
            locationList=cursor.fetchall()
        except: 
            cursor.close()
            cnx.close()
            print "ERROR:", sys.exc_info()
            flash('ERRROR: Rack Not Found','danger')
            return redirect(url_for('data.rack'))

        locationDict={}
        for entry in locationList:
            locationDict[entry['locationCode']]=entry['locationID']
        if locationCode_get not in locationDict:
            flash('ERRROR: Rack Not Found','danger')
            return redirect(url_for('data.rack'))


        query = ("SELECT * FROM rack WHERE rackName='"+str(rackName_get)+"' and locationID="+str(locationDict[locationCode_get]))
        try:
            cursor.execute(query)
            tempResponse=cursor.fetchall()
            if len(tempResponse) != 1:
                flash('ERRROR: Rack Not Found','danger')
                return redirect(url_for('data.rack'))
            else:
                rackInfoDict=tempResponse[0]
        except: 
            cursor.close()
            cnx.close()
            print "ERROR:", sys.exc_info()
            flash('ERRROR: Rack Not Found','danger')
            return redirect(url_for('data.rack'))

        # Gather device information for rack and provide to template
        query = ("SELECT deviceName,deviceSerial,device.deviceTypeID AS deviceTypeID,uStart,uHeight FROM device JOIN deviceType ON device.deviceTypeID=deviceType.deviceTypeID WHERE rackID="+str(rackInfoDict['rackID']))
        cursor.execute(query)
        deviceInfoArrayDict=cursor.fetchall()

        deviceTempDict={}
        for deviceElement in deviceInfoArrayDict:
            deviceTempDict[deviceElement['uStart']]={'deviceName':deviceElement['deviceName'],'uHeight':deviceElement['uHeight']}
        deviceLayoutDict={}
        uLevelCounter=1
        while uLevelCounter <= int(rackInfoDict['uCount']):
            if uLevelCounter in deviceTempDict:
                startingU=int(uLevelCounter)
                chassisHeightCounter=int(deviceTempDict[uLevelCounter]['uHeight'])
                while chassisHeightCounter > 0:
                    if chassisHeightCounter > 1:
                        deviceLayoutDict[uLevelCounter]={'deviceName':'empty','uHeight':0}
                        uLevelCounter+=1
                    elif chassisHeightCounter == 1:
                        deviceLayoutDict[uLevelCounter]=deviceTempDict[startingU]
                        uLevelCounter+=1
                    chassisHeightCounter-=1
            else:
                deviceLayoutDict[uLevelCounter]={'deviceName':'empty','uHeight':1}
                uLevelCounter+=1

        counterReverse=int(rackInfoDict['uCount'])
        finalLayout={}
        for x in range(1,int(rackInfoDict['uCount'])+1):
            finalLayout[x]=deviceLayoutDict[counterReverse]
            finalLayout[x]['uLevel']=counterReverse
            counterReverse-=1

        # Gather device types and provide to template
        query = ("SELECT deviceTypeID,deviceTypeName,deviceRole,deviceMake,deviceModel," \
            + "deviceTypeNote,softwareVersion,uHeight FROM deviceType")
        cursor.execute(query)
        deviceTypesAvailable=cursor.fetchall()
        cursor.close()
        cnx.close()
        deviceTypeDict={}
        for entry in deviceTypesAvailable:
            tempList=[
                entry['deviceRole'],
                entry['deviceTypeName'],
                entry['deviceMake'],
                entry['deviceModel'],
                entry['deviceTypeNote'],
                entry['softwareVersion'],
                entry['uHeight']
            ]
            deviceTypeDict[entry['deviceTypeID']]=tempList

        # Return template with gathered information
        return render_template('rack_details.html',locationDict=locationDict,locationCode=locationCode_get,rackInfoDict=rackInfoDict,deviceInfoArrayDict=deviceInfoArrayDict,
            deviceTypeDict=deviceTypeDict,finalLayout=finalLayout)
        # except:
        #     cursor.close()
        #     cnx.close()
        #     print "ERROR:", sys.exc_info()
        #     flash(('ERRROR: '+str(sys.exc_info())),'danger')
        #     return redirect(url_for('data.device'))
    flash('Authentication Required','danger')
    return redirect(url_for('data.home'))

@data.route('/device_details', methods=['GET'])
def device_details():
    if current_user.is_authenticated:

        #try:
        # Gather device name from argument
        deviceName = request.values.get('name')

        # Gather device specific information and provide to template
        cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
        cursor = cnx.cursor(dictionary=True)
        query = ("SELECT * FROM device WHERE deviceName='"+str(deviceName)+"'")
        cursor.execute(query)
        try:
            deviceInfoDict=cursor.fetchall()[0]
        except: 
            cursor.close()
            cnx.close()
            print "ERROR:", sys.exc_info()
            flash('ERRROR: Device Not Found','danger')
            return redirect(url_for('data.device'))

        # Gather interface information for device and provide to template
        query = ("SELECT intID,intName,intLabel,intType,intNote,INET_NTOA(ipv4address) AS ipv4address FROM interface WHERE deviceID="+str(deviceInfoDict['deviceID']))
        cursor.execute(query)
        intInfoArrayDict=cursor.fetchall()


        # Gather locaiton codes and provide to template
        query = ("SELECT locationCode,locationID FROM location")
        cursor.execute(query)
        locationsAvailable=cursor.fetchall()
        locationDict={}
        for entry in locationsAvailable:
            locationDict[entry['locationID']]=entry['locationCode']

        # Gather rack codes and provide to template
        query = ("SELECT locationID,rackID,rackName FROM rack")
        cursor.execute(query)
        racksAvailable=cursor.fetchall()
        rackDict={}
        for entry in racksAvailable:
            tempList=[entry['locationID'],entry['rackName']]
            rackDict[entry['rackID']]=tempList

        # Gather device type roles and provide to template
        query = ("SELECT DISTINCT(deviceRole) AS deviceRole FROM deviceType")
        cursor.execute(query)
        deviceRoleAvailable=cursor.fetchall()
        deviceRoleList=[]
        for entry in deviceRoleAvailable:
            deviceRoleList.append(entry['deviceRole'])

        # Gather device types and provide to template
        query = ("SELECT deviceTypeID,deviceTypeName,deviceRole,deviceMake,deviceModel," \
            + "deviceTypeNote,softwareVersion,uHeight FROM deviceType")
        cursor.execute(query)
        deviceTypesAvailable=cursor.fetchall()
        cursor.close()
        cnx.close()
        deviceTypeDict={}
        for entry in deviceTypesAvailable:
            tempList=[
                entry['deviceRole'],
                entry['deviceTypeName'],
                entry['deviceMake'],
                entry['deviceModel'],
                entry['deviceTypeNote'],
                entry['softwareVersion'],
                entry['uHeight']
            ]
            deviceTypeDict[entry['deviceTypeID']]=tempList

        # Establish interface types and provide to template
        intTypeList=['logical:mgmt',
            'physical:data',
            'logical:data',
            'physical:power',
            'physical:outlet',
            'physical:console',
            'physical:serial'
            ]

        if not deviceInfoDict['deviceSerial'] or (deviceInfoDict['deviceSerial'] == 'UNKNOWN'):
            if current_user.is_admin(current_user):
                flash('Please Set Serial Number For This Device','warning')
            # else:
            #     flash('Serial Number Not Set For This Device','warning')

        # Return template with gathered information
        return render_template('device_details.html',deviceInfoDict=deviceInfoDict,locationDict=locationDict,rackDict=rackDict,
            deviceRoleList=deviceRoleList,deviceTypeDict=deviceTypeDict,intTypeList=intTypeList,intInfoArrayDict=intInfoArrayDict)
        # except:
        #     cursor.close()
        #     cnx.close()
        #     print "ERROR:", sys.exc_info()
        #     flash(('ERRROR: '+str(sys.exc_info())),'danger')
        #     return redirect(url_for('data.device'))
    flash('Authentication Required','danger')
    return redirect(url_for('data.home'))

@data.route('/interface_details', methods=['GET', 'POST'])
def interface_details():
    if current_user.is_authenticated:

        try:
            # Gather device name from argument
            intID = request.values.get('intID')
            #print request.form
            form = intEditForm(request.form)

            # Gather device specific information and provide to template
            cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
            cursor = cnx.cursor(dictionary=True)

            # Gather interface information
            query = ("SELECT " + \
                "intID," + \
                "deviceID," + \
                "intType," + \
                "connectorType," + \
                "intName," + \
                "intPosition," + \
                "INET_NTOA(ipv4address) AS ipv4address," + \
                "INET_NTOA(ipv4Subnet) AS ipv4Subnet," + \
                "INET_NTOA(ipv4Gateway) AS ipv4Gateway," + \
                "lastCleaned," + \
                "intVoltage," + \
                "intLabel," + \
                "intNote " + \
                "FROM interface " + \
                "WHERE intID="+str(intID))
           
            try:
                cursor.execute(query)
                intInfoDict=cursor.fetchall()[0]
            except: 
                cursor.close()
                cnx.close()
                print "ERROR:", sys.exc_info()
                flash('ERRROR: Interface Not Found','danger')
                return redirect(url_for('data.device'))


            # get list of all devices (names and IDs)
            query = ("SELECT deviceName,deviceID from device")
            try:
                cursor.execute(query)
                deviceInfoRaw=cursor.fetchall()
            except: 
                cursor.close()
                cnx.close()
                print "ERROR:", sys.exc_info()
                flash('ERRROR: Interface Not Found','danger')
                return redirect(url_for('data.device'))


            # convert array of dictionaries to format used by wtform
            deviceInfoList = []
            for entry in deviceInfoRaw:
                deviceInfoList.append((str(entry["deviceID"]),str(entry["deviceName"])))
            
            # convert array of dictionaries to dictionary to provide to template
            deviceOptDict = {}
            for entry in deviceInfoRaw:
                deviceOptDict[entry["deviceID"]]=entry["deviceName"]


            # create choice list for devices (generated each time )
            form.deviceID.choices = deviceInfoList
            form.deviceID.default = intInfoDict["deviceID"]

            query = ("SELECT deviceName from device where deviceID='"+str(intInfoDict["deviceID"])+"'")
            try:
                cursor.execute(query)
                deviceName=cursor.fetchall()[0]["deviceName"]
            except: 
                cursor.close()
                cnx.close()
                print "ERROR:", sys.exc_info()
                flash('ERRROR: Interface Not Found','danger')
                return redirect(url_for('data.device'))
                
            intInfoDict["deviceName"]=deviceName
            #print intInfoDict

            ###############################
            ## Created dicts of choices  ##
            ## for select fields due to  ##
            ## issues setting 'selected' ##
            ## options via wtform        ##
            ###############################

            # create dicts of option data
            positionOptDict = {
                'None':'None',
                'face':'device face',
                'rear':'device rear'
            }
            typeOptDict = {
                'None':'None',
                'name':'value',
                'logical:mgmt':'logical:mgmt',
                'physical:data':'physical:data',
                'logical:data':'logical:data',
                'physical:power':'physical:power',
                'physical:outlet':'physical:outlet',
                'physical:console':'physical:console',
                'physical:serial':'physical:serial'
            }
            connectorOptDict = {
                'None':'None',
                'LC':'LC',
                'SC':'SC',
                'MTP':'MTP',
                'C20':'C20',
                'C16':'C16',
                'C14':'C14',
                'RJ45':'RJ45'
            }


            #### form.validate() produces odd interation error - unsure how this behaves differently than the popEditForm class
            #### determined this was because the form.validate() was run before 

            # add in ?intID={{intInfoDict['intID']}} to html to ensure the GET also takes place
            if request.method == 'POST' and form.validate():
                #print "working... I think"

                postData={}
                try:
                    if str(intID) != str(intInfoDict['intID']):
                            flash('Error in edit int data, expected ID  '+str(intInfoDict['intID']), 'danger')
                    postData["intID"] = request.form.get('intID')
                    postData["deviceID"] = request.form.get('deviceID')
                    postData["intType"] = request.form.get('intType')
                    postData["connectorType"] = request.form.get('connectorType')
                    postData["intName"] = request.form.get('intName')
                    postData["intPosition"] = request.form.get('intPosition')
                    postData["ipv4address"] = request.form.get('ipv4address')
                    postData["ipv4Subnet"] = request.form.get('ipv4Subnet')
                    postData["ipv4Gateway"] = request.form.get('ipv4Gateway')
                    postData["intVoltage"] = request.form.get('intVoltage')
                    postData["intLabel"] = request.form.get('intLabel')
                    postData["intNote"] = request.form.get('intNote')
                except:
                    flash('Error in edit int data', 'danger')

                # generate string for mysql update
                add_string = str("UPDATE interface SET ")
                x=0
                for key,value in postData.iteritems():
                    if x > 0:
                        add_string+=", "
                    #add_string+=(str(key)+"=\""+str(request.values.get(key)))
                    if (key == 'ipv4address') or (key=='ipv4Subnet') or (key=='ipv4Gateway'):
                        add_string+=(str(key)+"=INET_ATON(+%("+str(key)+")s")+")"
                    else:
                        add_string+=(str(key)+"=%("+str(key)+")s")
                    x+=1
                add_string+=str(" WHERE intID=" + str(intID))
                try:
                    # execute mysql insert and comit insert
                    cursor.execute(add_string,postData)
                    cnx.commit()
                    flash('Updated '+postData['intID']+' interface in database', 'success')

                    # Re-Gather location information
                    newQuery = ("SELECT " + \
                        "intID," + \
                        "deviceID," + \
                        "intType," + \
                        "connectorType," + \
                        "intName," + \
                        "intPosition," + \
                        "INET_NTOA(ipv4address) AS ipv4address," + \
                        "INET_NTOA(ipv4Subnet) AS ipv4Subnet," + \
                        "INET_NTOA(ipv4Gateway) AS ipv4Gateway," + \
                        "lastCleaned," + \
                        "intVoltage," + \
                        "intLabel," + \
                        "intNote " + \
                        "FROM interface " + \
                        "WHERE intID="+str(intID))
                    try:
                        cursor.execute(newQuery)
                        intInfoDict=cursor.fetchall()[0]
                    except: 
                        cursor.close()
                        cnx.close()
                        print "ERROR:", sys.exc_info()
                        flash('ERRROR: Issue Gathering Interface Details','danger')
                        return redirect(url_for('data.pop'))

                    query = ("SELECT deviceName,deviceID from device")
                    try:
                        cursor.execute(query)
                        deviceInfoRaw=cursor.fetchall()
                    except: 
                        cursor.close()
                        cnx.close()
                        print "ERROR:", sys.exc_info()
                        flash('ERRROR: Interface Not Found','danger')
                        return redirect(url_for('data.device'))


                    # convert array of dictionaries to format used by wtform
                    deviceInfoList = []
                    for entry in deviceInfoRaw:
                        deviceInfoList.append((str(entry["deviceID"]),str(entry["deviceName"])))
                    
                    # convert array of dictionaries to dictionary to provide to template
                    deviceOptDict = {}
                    for entry in deviceInfoRaw:
                        deviceOptDict[entry["deviceID"]]=entry["deviceName"]


                    # create choice list for devices (generated each time )
                    form.deviceID.choices = deviceInfoList
                    form.deviceID.default = intInfoDict["deviceID"]

                    query = ("SELECT deviceName from device where deviceID='"+str(intInfoDict["deviceID"])+"'")
                    try:
                        cursor.execute(query)
                        deviceName=cursor.fetchall()[0]["deviceName"]
                    except: 
                        cursor.close()
                        cnx.close()
                        print "ERROR:", sys.exc_info()
                        flash('ERRROR: Interface Not Found','danger')
                        return redirect(url_for('data.device'))
                        
                    intInfoDict["deviceName"]=deviceName
                except:
                    flash('Error with database write', 'danger')
            if form.errors:
                flash(form.errors, 'danger')
                return redirect(url_for('data.interface_detials')+"?intID="+str(intID))


            cursor.close()
            cnx.close()

            # Return template with gathered information
            return render_template('interface_details.html',form=form,intInfoDict=intInfoDict,deviceOptDict=deviceOptDict,
                positionOptDict=positionOptDict,typeOptDict=typeOptDict,connectorOptDict=connectorOptDict)
        except:
            # cursor.close()
            # cnx.close()
            print "ERROR:", sys.exc_info()
            flash(('ERRROR: '+str(sys.exc_info())),'danger')
            return redirect(url_for('data.device'))
    flash('Authentication Required','danger')
    return redirect(url_for('data.home'))

@data.route('/add_pop')
def add_pop():
    if current_user.is_authenticated:
        print "Add Pop Page - User:" + str(current_user.username)
        flash('Add POP Page Not Yet Implemented','warning')
        return redirect(url_for('data.pop'))
    flash('Incorrect Permissions to Access Page','danger')
    return redirect(url_for('data.home'))


@data.route('/add_rack')
def add_rack():
    if current_user.is_authenticated:
        print "Add Rack Page - User:" + str(current_user.username)
        flash('Add Rack Page Not Yet Implemented','warning')
        return redirect(url_for('data.rack'))
    flash('Incorrect Permissions to Access Page','danger')
    return redirect(url_for('data.home'))



@data.route('/add_device')
def add_device():
    if current_user.is_authenticated:
        if current_user.is_admin(current_user):
            print "Add Device Page - User:" + str(current_user.username)
            try:
                # Gather locaiton codes and provide to template
                cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
                cursor = cnx.cursor(dictionary=True)
                query = ("SELECT locationCode,locationID FROM location")
                cursor.execute(query)
                locationsAvailable=cursor.fetchall()
                cursor.close()
                cnx.close()
                locationDict={}
                for entry in locationsAvailable:
                    locationDict[entry['locationID']]=entry['locationCode']

                # Gather rack codes and provide to template
                cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
                cursor = cnx.cursor(dictionary=True)
                query = ("SELECT locationID,rackID,rackName FROM rack")
                cursor.execute(query)
                racksAvailable=cursor.fetchall()
                cursor.close()
                cnx.close()
                rackDict={}
                for entry in racksAvailable:
                    tempList=[entry['locationID'],entry['rackName']]
                    rackDict[entry['rackID']]=tempList

                # Gather device type roles and provide to template
                cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
                cursor = cnx.cursor(dictionary=True)
                query = ("SELECT DISTINCT(deviceRole) AS deviceRole FROM deviceType")
                cursor.execute(query)
                deviceRoleAvailable=cursor.fetchall()
                cursor.close()
                cnx.close()
                deviceRoleList=[]
                for entry in deviceRoleAvailable:
                    deviceRoleList.append(entry['deviceRole'])

                # Gather device types and provide to template
                cnx = mysql.connector.connect(user=data_database_username,password=data_database_password,database=data_database_dbname)
                cursor = cnx.cursor(dictionary=True)
                query = ("SELECT deviceTypeID,deviceTypeName,deviceRole FROM deviceType")
                cursor.execute(query)
                deviceTypesAvailable=cursor.fetchall()
                cursor.close()
                cnx.close()
                deviceTypeDict={}
                for entry in deviceTypesAvailable:
                    tempList=[entry['deviceRole'],entry['deviceTypeName']]
                    deviceTypeDict[entry['deviceTypeID']]=tempList

                # Establish interface types and provide to template
                intTypeList=['logical:mgmt',
                    'physical:data',
                    'physical:power',
                    'physical:outlet',
                    'physical:console',
                    'physical:serial'
                    ]


                flash('WARNING: Under Developement - Back-End Not Working For This Page','warning')
                # Return template with gathered information
                return render_template('add_device.html',locationDict=locationDict,rackDict=rackDict,
                    deviceRoleList=deviceRoleList,deviceTypeDict=deviceTypeDict,intTypeList=intTypeList)
            except:
                print "ERROR:", sys.exc_info()
                flash(('ERRROR:'+str(sys.exc_info())),'danger')
                return redirect(url_for('data.pop'))
        flash('Incorrect Permissions to Access Page','danger')
        return redirect(url_for('data.home'))
    flash('Authentication Required','danger')
    return redirect(url_for('data.home'))
