# import general
import datetime, sys, socket, httplib, time, io, csv
# import postgresql tool - psycopg2
import psycopg2
# import from flask
from flask import Flask, request, render_template, flash, redirect, \
    url_for, json, jsonify, Blueprint, g , send_from_directory
from flask import Flask, render_template, request, redirect, json, jsonify, send_from_directory, \
    flash, url_for, Blueprint, g, Response, make_response, request
from flask_restful import reqparse, abort, Api, Resource
# import from this app
from my_app import app, data_database_username
from werkzeug.utils import secure_filename
 
stagingInvApiBlueprint = Blueprint('stagingInvApiBlueprint', __name__)
api = Api(app)

# API Sub-Functions

def make_dict_with_serial(serial_var,query_vars,source_list):
    query_list = query_vars.split(",")
    result_dict = {}
    for element in source_list:
        tempDict = dict(zip(query_list, element))
        result_dict[tempDict[serial_var]] = {key: value for key, value in tempDict.items() if key != serial_var}
    return result_dict

def addItem(vendor,partNumber,description):
    try:
        conn = psycopg2.connect("dbname='dco_data' user='testUser' host='dco-aurora.cfrhjljbpdy8.us-west-2.rds.amazonaws.com' port='5432' password='6w2#1!n4TKnLmUOvm'")
    except:
        return jsonify(error="Unable to connect to database")
    #cur = conn.cursor()
    cursor = conn.cursor()
    insertString = "INSERT INTO sundry_items (vendor,part_number,description) VALUES (%(vendor)s, %(part_number)s, %(description)s)"
    valuesDict={
        'vendor':vendor,
        'part_number':partNumber,
        'description':description
    }
    try:
        cursor.execute(insertString,valuesDict)
        print "Added New Item"
        conn.commit()
        print "Commited"
        print cursor.lastrowid
        return {'complete':True,'result':cursor.lastrowid}
    except:
        cursor.close()
        conn.close()
        error=str(sys.exc_info())
        print 'ERROR: ' + error
        return {'complete':False,'error':error}

def addInventoryItem(table,values_dict):
    try:
        conn = psycopg2.connect("dbname='dco_data' user='testUser' host='dco-aurora.cfrhjljbpdy8.us-west-2.rds.amazonaws.com' port='5432' password='6w2#1!n4TKnLmUOvm'")
    except:
        return jsonify(error="Unable to connect to database")
    cursor = conn.cursor()
    addString = "INSERT INTO " + str(table) + " ("
    keyString=""
    x=0
    for key,value in values_dict.iteritems():
        if (value != 'None') and (value is not None):
            # add commas 
            if x > 0:
                addString+=", "
                keyString+=", "
            # add key to input field set
            addString+=str(key)
            # add values substitution fields based on keys (adjusting for IP formatting with INET)
            if (key == 'ipv4Address') or (key=='ipv4Gateway'):
                keyString+="INET_ATON(%("+str(key)+")s)"
            else:
                keyString+="%("+str(key)+")s"
            x+=1
    addString+=") VALUES ("
    addString+=str(keyString)
    addString+=")"
    try:
        cursor.execute(addString,values_dict)
        conn.commit()
        return cursor.lastrowid
    except:
        cursor.close()
        conn.close()
        print 'ERROR: ' + str(sys.exc_info())
        return 0

def getSiteInventoryList(siteName):
    try:
        conn = psycopg2.connect("dbname='dco_data' user='testUser' host='dco-aurora.cfrhjljbpdy8.us-west-2.rds.amazonaws.com' port='5432' password='6w2#1!n4TKnLmUOvm'")
    except:
        return jsonify(error="Unable to connect to database")
    siteName=siteName.upper()
    cur = conn.cursor()
    query_columns = "sundry_stock.item_id as item_id,vendor,part_number,description,quantity_current,quantity_expected,order_threshold,notes"
    query_table = "sundry_stock"
    query_join_1_table = "sites"
    query_join_1_on = "sundry_stock.site_id=sites.site_id"
    query_join_2_table = "sundry_items"
    query_join_2_on = "sundry_stock.item_id=sundry_items.item_id"
    query_where = "sites.site_code='"+siteName+"'"
    query = ("SELECT "+query_columns+" FROM "+query_table \
        +" JOIN "+query_join_1_table+" ON "+query_join_1_on \
        +" JOIN "+query_join_2_table+" ON "+query_join_2_on \
        +" WHERE "+query_where)
    try:
        cur.execute(query)
    except:
        return jsonify(error="Unable to query for "+siteName)
    keyList=("item_id","vendor","part_number","description","quantity_current","quantity_expected","order_threshold","notes")
    returnList=[]
    for item in cur.fetchall():
        tempDict={}
        for index in range(7):
            tempDict[keyList[index]]=item[index]
        returnList.append(tempDict)
    return returnList

def getItemsList():
    try:
        conn = psycopg2.connect("dbname='dco_data' user='testUser' host='dco-aurora.cfrhjljbpdy8.us-west-2.rds.amazonaws.com' port='5432' password='6w2#1!n4TKnLmUOvm'")
    except:
        print "ERROR: Unable to connect to database"
    cur = conn.cursor()
    query_columns = "item_id,vendor,description,part_number"
    query_table = "sundry_items"
    query = ("SELECT "+query_columns+" FROM "+query_table)
    try:
        cur.execute(query)
    except:
        print "ERROR: Unable to select from '"+query_table+"' table"
    keyList = ['item_id','vendor','description','part_number']
    returnList=[]
    for item in cur.fetchall():
        tempDict={}
        for index in range(4):
            tempDict[keyList[index]]=item[index]
        returnList.append(tempDict)
    return returnList



# API Classes/Functions

class list_sites(Resource):
    def get(self):
        try:
            conn = psycopg2.connect("dbname='dco_data' user='testUser' host='dco-aurora.cfrhjljbpdy8.us-west-2.rds.amazonaws.com' port='5432' password='6w2#1!n4TKnLmUOvm'")
        except:
            return jsonify(error="Unable to connect to database")

        cur = conn.cursor()

        query_columns = "site_id,site_code"
        query_table = "sites"

        query = ("SELECT "+query_columns+" FROM "+query_table)

        try:
            cur.execute(query)
        except:
            return jsonify(error="Unable to select from '"+query_table+"' table")

        output = cur.fetchall()

        return jsonify(output)

class list_items_all(Resource):
    def get(self):
        try:
            conn = psycopg2.connect("dbname='dco_data' user='testUser' host='dco-aurora.cfrhjljbpdy8.us-west-2.rds.amazonaws.com' port='5432' password='6w2#1!n4TKnLmUOvm'")
        except:
            return jsonify(error="Unable to connect to database")

        cur = conn.cursor()

        query_columns = "item_id,vendor,description,part_number"
        query_table = "sundry_items"
        
        query = ("SELECT "+query_columns+" FROM "+query_table)

        try:
            cur.execute(query)
        except:
            return jsonify(error="Unable to select from '"+query_table+"' table")

        output = make_dict_with_serial("item_id",query_columns,cur.fetchall())

        return jsonify(output)

class list_items_site(Resource):
    def get(self,siteName):
        try:
            conn = psycopg2.connect("dbname='dco_data' user='testUser' host='dco-aurora.cfrhjljbpdy8.us-west-2.rds.amazonaws.com' port='5432' password='6w2#1!n4TKnLmUOvm'")
        except:
            return jsonify(error="Unable to connect to database")

        siteName=siteName.upper()

        cur = conn.cursor()

        query_columns = "sundry_stock.item_id as item_id,vendor,part_number,description,quantity_current,quantity_expected,order_threshold,notes"
        query_table = "sundry_stock"
        query_join_1_table = "sites"
        query_join_1_on = "sundry_stock.site_id=sites.site_id"
        query_join_2_table = "sundry_items"
        query_join_2_on = "sundry_stock.item_id=sundry_items.item_id"
        query_where = "sites.site_code='"+siteName+"'"
        
        query = ("SELECT "+query_columns+" FROM "+query_table \
            +" JOIN "+query_join_1_table+" ON "+query_join_1_on \
            +" JOIN "+query_join_2_table+" ON "+query_join_2_on \
            +" WHERE "+query_where)

        try:
            cur.execute(query)
        except:
            return jsonify(error="Unable to query for "+siteName)

        query_columns = "item_id,vendor,part_number,description,quantity_current,quantity_expected,order_threshold,notes"
        output = make_dict_with_serial("item_id",query_columns,cur.fetchall())

        return jsonify(output)
    def post(site,siteName):
        postValues=json.loads(request.get_data())
        insert_values={}
        insert_values['item_id']=int(postValues['item_id'])
        insert_values['site_id']=int(postValues['site_id'])
        insert_values['quantity_expected']=int(postValues['expected'])
        insert_values['quantity_current']=int(postValues['current'])
        # insert_values['order_threshold']=int(postValues['threshold'])
        insert_values['notes']=str(postValues['notes'])
        insert_result=addInventoryItem('sundry_stock',insert_values)
        if insert_result==0:
            return jsonify(error="General error during add process")
        else:
            return insert_result

class inventory_increase(Resource):
    def get(self,siteName,itemID):
        try:
            conn = psycopg2.connect("dbname='dco_data' user='testUser' host='dco-aurora.cfrhjljbpdy8.us-west-2.rds.amazonaws.com' port='5432' password='6w2#1!n4TKnLmUOvm'")
        except:
            return jsonify(error="Unable to connect to database")

        cur = conn.cursor()

        try: 
            int(itemID)
        except ValueError:
            return jsonify(error="Specified item ID is not valid")

        query_columns = "sundry_stock.site_id,quantity_current"
        query_table = "sundry_stock"
        query_join_1_table = "sites"
        query_join_1_on = "sundry_stock.site_id=sites.site_id"
        query_where = "site_code='"+siteName+"' and item_id='"+itemID+"'"

        query = ("SELECT "+query_columns+" FROM "+query_table \
            +" JOIN "+query_join_1_table+" ON "+query_join_1_on \
            +" WHERE "+query_where)

        try:
            cur.execute(query)
        except:
            return jsonify(error="Unable to query for "+siteName)

        queryResponseRaw = cur.fetchall().pop()

        if len(queryResponseRaw) != 2:
            return jsonify(error="Unexpected response from database")

        siteID = queryResponseRaw[0]
        currentCount = queryResponseRaw[1]

        update_table = "sundry_stock"
        update_set = "quantity_current=%s"
        update_where = "site_id=%s AND item_id=%s"
        udpate_values = (currentCount+1,siteID,itemID)

        update = ("UPDATE "+update_table+" SET "+update_set \
            +" WHERE "+update_where)

        try:
            cur.execute(update,udpate_values)
            conn.commit()
        except:
            return jsonify(error="Unable to incrase quantity")

        cur.close()

        return jsonify(response="Updated "+str(cur.rowcount)+ " row with quantity increase")

class inventory_decrease(Resource):
    def get(self,siteName,itemID):
        try:
            conn = psycopg2.connect("dbname='dco_data' user='testUser' host='dco-aurora.cfrhjljbpdy8.us-west-2.rds.amazonaws.com' port='5432' password='6w2#1!n4TKnLmUOvm'")
        except:
            return jsonify(error="Unable to connect to database")

        cur = conn.cursor()

        try: 
            int(itemID)
        except ValueError:
            return jsonify(error="Specified item ID is not valid")

        query_columns = "sundry_stock.site_id,quantity_current"
        query_table = "sundry_stock"
        query_join_1_table = "sites"
        query_join_1_on = "sundry_stock.site_id=sites.site_id"
        query_where = "site_code='"+siteName+"' and item_id='"+itemID+"'"

        query = ("SELECT "+query_columns+" FROM "+query_table \
            +" JOIN "+query_join_1_table+" ON "+query_join_1_on \
            +" WHERE "+query_where)

        try:
            cur.execute(query)
        except:
            return jsonify(error="Unable to query for "+siteName)

        queryResponseRaw = cur.fetchall().pop()

        if len(queryResponseRaw) != 2:
            return jsonify(error="Unexpected response from database")

        siteID = queryResponseRaw[0]
        currentCount = queryResponseRaw[1]

        update_table = "sundry_stock"
        update_set = "quantity_current=%s"
        update_where = "site_id=%s AND item_id=%s"
        udpate_values = (currentCount-1,siteID,itemID)

        update = ("UPDATE "+update_table+" SET "+update_set \
            +" WHERE "+update_where)

        try:
            cur.execute(update,udpate_values)
            conn.commit()
        except:
            return jsonify(error="Unable to decrease quantity")

        cur.close()

        return jsonify(response="Updated "+str(cur.rowcount)+ " row with quantity decrease")

class download_inventory_csv(Resource):
    def get(slef,siteName):
        try:
            conn = psycopg2.connect("dbname='dco_data' user='testUser' host='dco-aurora.cfrhjljbpdy8.us-west-2.rds.amazonaws.com' port='5432' password='6w2#1!n4TKnLmUOvm'")
        except:
            return jsonify(error="Unable to connect to database")

        siteName=siteName.upper()

        cur = conn.cursor()

        query_columns = "vendor,part_number,description,quantity_current,quantity_expected,order_threshold,notes"
        query_table = "sundry_stock"
        query_join_1_table = "sites"
        query_join_1_on = "sundry_stock.site_id=sites.site_id"
        query_join_2_table = "sundry_items"
        query_join_2_on = "sundry_stock.item_id=sundry_items.item_id"
        query_where = "sites.site_code='"+siteName+"'"
        
        query = ("SELECT "+query_columns+" FROM "+query_table \
            +" JOIN "+query_join_1_table+" ON "+query_join_1_on \
            +" JOIN "+query_join_2_table+" ON "+query_join_2_on \
            +" WHERE "+query_where)

        try:
            cur.execute(query)
        except:
            return jsonify(error="Unable to query for "+siteName)
        returnCSV = "'header',"+query_columns+"\n"
        dataResponse=cur.fetchall()
        for element in dataResponse:
            returnCSV += "'sundry','"+str(element[0])+"','"+str(element[1])+"'," \
                +str(element[2])+","+str(element[3])+"," \
                +str(element[4])+","+str(element[5])+",'" \
                +str(element[6])+"'\n"
        # Create custom response from generated csv text
        response = make_response(returnCSV)
        # Set response to be a file with a generated filename and a .csv extension
        response.headers["Content-Disposition"] = "attachment; filename=dco-sundries-"+siteName+"-" \
            + time.strftime("%d/%m/%Y") + "_" + time.strftime("%H:%M:%S") + ".csv"
        return response

class upload_inventory_csv(Resource):
    def post(self,siteName):
        rawCSV = request.files['csv_upload']
        if not rawCSV:
            return jsonify(error="No file recieved")
        stream = io.StringIO(rawCSV.stream.read().decode("UTF8"), newline=None)
        inputCSV = csv.reader(stream)
        neededKeys=['vendor','part_number','quantity_current','quantity_expected','order_threshold']
        lineNumber=1
        headerLoaded=False
        functionLoaded=False
        fullItemList=getItemsList()
        currentInventory=getSiteInventoryList(siteName)
        finalOutput={}
        for line in inputCSV:
            line=[key.strip('"').strip("'") for key in line]
            if line[0]=='header':
                keyList=line
                if all(key in keyList for key in neededKeys)==False:
                    return jsonify(error="Error on CSV line "+str(lineNumber)+ \
                        ". Minimum columns not met.  Must contain at least "+ \
                        "'vendor','part_number','quantity_current','quantity_expected', and 'order_threshold'")
                headerLoaded=True
            if line[0]=='function':
                function=line[1]
                if function not in ['add','append','overwrite']:
                    return jsonify(error="Error on CSV line "+str(lineNumber)+ \
                        ". Processing function not recognized.  Please use "+ \
                        "'append' to only append new items for this site "+ \
                        "or 'add' to add all quantities to current values "+ \
                        "or 'overwrite' to replace current quantities with the new values.")
                functionLoaded=True
            if line[0]=='sundry':
                if not headerLoaded:
                    return jsonify(error="Error on CSV line "+str(lineNumber)+ \
                        ". Header line required before sundry listings.")
                if not functionLoaded:
                    return jsonify(error="Error on CSV line "+str(lineNumber)+ \
                        ". Function line required before sundry listings.")

                alreadyExists=False
                for currentItem in currentInventory:
                    if ((currentItem['vendor']==line[keyList.index('vendor')]) and (currentItem['part_number']==line[keyList.index('part_number')])):
                        alreadyExists=True
                
                newItemType=True
                for item in fullItemList:
                    if ((item['vendor']==line[keyList.index('vendor')]) and (item['part_number']==line[keyList.index('part_number')])):
                        newItemType=False
                

                if function=='add':
                    if alreadyExists:
                        finalOutput['CSV Line '+str(lineNumber)]="Item already exists.  Quantities added."
                    else:
                        if newItemType:
                            addOverallItem=addItem(line[keyList.index('vendor')],line[keyList.index('part_number')],line[keyList.index('description')])
                            if addOverallItem['complete']:
                                finalOutput['CSV Line '+str(lineNumber)]="New item (row "+str(addOverallItem['result'])+") type added and new row <WILL BE HERE> added to site."
                            else:
                                finalOutput['CSV Line '+str(lineNumber)]=["Error adding new overall item",addOverallItem['error']]  
                            
                        else:
                            finalOutput['CSV Line '+str(lineNumber)]="Item added to site as row <WILL BE HERE>."
                
                if function=='append':
                    if alreadyExists:
                        finalOutput['CSV Line '+str(lineNumber)]="Item not added.  Found to already exist while 'append' function specified."
                    else:
                        if newItemType:
                            finalOutput['CSV Line '+str(lineNumber)]="Item not added.  Item type does not exist"
                        else:
                            finalOutput['CSV Line '+str(lineNumber)]="Item added to site as row <WILL BE HERE>."
                
                if function=='overwrite':
                    if alreadyExists:
                        finalOutput['CSV Line '+str(lineNumber)]="Item already exists.  Quantities overwritten."
                    else:
                        finalOutput['CSV Line '+str(lineNumber)]="Item added as row <WILL BE HERE>."

                # insert_values={}
                # insert_values['item_id']=int(postValues['item_id'])
                # insert_values['site_id']=int(postValues['site_id'])
                # insert_values['quantity_expected']=int(postValues['expected'])
                # insert_values['quantity_current']=int(postValues['current'])
                # # insert_values['order_threshold']=int(postValues['threshold'])
                # insert_values['notes']=str(postValues['notes'])
                # insert_result=addInventoryItem('sundry_stock',insert_values)
                # if insert_result==0:
                #     return jsonify(error="General error during add process")
                # else:
                #     return insert_result
            lineNumber+=1
        return jsonify(upload="Complete",results=finalOutput,site=siteName,function=function)


# API Web Resource

api.add_resource(
    list_sites,
    '/stage/sites'
    )

api.add_resource(
    list_items_all,
    '/stage/items'
    )

api.add_resource(
    list_items_site,
    '/stage/items/<siteName>'
    )

api.add_resource(
    download_inventory_csv,
    '/stage/items/<siteName>/downloadCSV'
    )

api.add_resource(
    upload_inventory_csv,
    '/stage/items/<siteName>/uploadCSV'
    )

api.add_resource(
    inventory_increase,
    '/stage/item_increase/<siteName>/<itemID>'
    )

api.add_resource(
    inventory_decrease,
    '/stage/item_decrease/<siteName>/<itemID>'
    )