var app = angular.module('myApp', ['ngSanitize', 'ui.select']);

app.controller('dashController',function($scope,$http,$filter){

    <!--inject window-->
    $inject = ['$window'];
    console.log(window.location.href)

    <!--general variables-->
    $scope.gen = {
        paramString: {},
        paramStringTemp: {},
        tableLoading: true,
        errorEvent: null,
        searchValue: "",
        sortValue: "placeholder",
        sortReverse: false,
        expandCounter: 0
    }
    $scope.pattern = {
        'ip': '^10.(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){2}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',
        'location': '^[a-z]{3}[0-9]{2}$',
        'rack': '^([0-9]{3}|[0-9]{2})$',
        'position': '^[a-d]$',
        'software_version': '',
        'uNumber':'^([1-9]{2}|[0-9])$'
    }

    <!--user settings page function/variables-->
    $scope.userSettings = {
        pubKeyEdit: false,
    };
    $scope.pubKeyEditToggle = function() {
        $scope.userSettings.pubKeyEdit = !$scope.userSettings.pubKeyEdit;
    };

    <!-- anchor type behavior -->
    $scope.goToURL = function(tempString) {
        window.location.href=tempString;
    };

    <!-- decrement expandCounter -->
    $scope.expandCounterUpdate = function(tempBol) {
        if (tempBol) {
            $scope.gen.expandCounter = $scope.gen.expandCounter+1;
        } else {
            $scope.gen.expandCounter = $scope.gen.expandCounter-1;
        }
    };

    <!-- general number array conversion -->
    $scope.getNumber = function(num) {
        return new Array(num);   
    }

    <!-- sort and direction functions -->
    $scope.setSort = function(tempValue) {
        $scope.sortType = tempValue;
        $scope.gen.sortValue = tempValue;
    };
    $scope.reverseSort = function() {
        $scope.sortReverse = !$scope.sortReverse;
        $scope.gen.sortReverse = !$scope.gen.sortReverse;
    };

    <!-- IPMI Blink Function -->
    $scope.api_blink = function(behavior, address, callback) {
        console.log("**** Initiated command for IPMI blink on address " + address  + " ****");
        switch(behavior) {
            case 'start':
                callString = '/tools/blinkStart?ip=' + address
                break;
            case 'stop':
                callString = '/tools/blinkStop?ip=' + address
                break;
            default:
                console.error("Error with use of blink function")
        }
        $http.get((callString), {}).success(function(data){
            var columns = [];
            var response = data;
            try {
                if (Object.keys(response).length == 0 ){
                    console.error("No response from blink request");
                } else {
                    console.log(response)
                    callback(response)
                }
            } catch(err){
                console.error(err.message);
                $scope.gen.errorEvent='noData';
            }
        });
    };

    <!-- APIv2 read -->
    $scope.api_read2 = function(lookupString, callback) {
        console.log("**** Read (APIv2) Function Called ****");
        $scope.gen.errorEvent=null;
        $http.get(('/api2/'+lookupString), {}).success(function(data){
            var columns = [];
            var response = data;
            try {
                if (Object.keys(response).length == 0 ){
                    console.log("No data returned by API call");
                    $scope.gen.errorEvent='noData';
                } else {
                    callback(response)
                }
            } catch(err){
                console.log(err.message);
                $scope.gen.errorEvent='noData';
            }
        });
    };

    <!-- APIv2 Write -->
    $scope.api_write = function(lookupString, postDataDict, callback) {
        console.log("**** Write Function Called, method \"" + writeType + "\" ****" );
        $scope.gen.errorEvent=null;
        param_list["method"]=writeType
        $http.get('/api/write', {
            params: param_list
        }).success(function(data){
            var response = data.result;
            try {
                testVar = Object.keys(response);
            } catch(err){
                console.log(err.message);
                $scope.gen.errorEvent='noResponse';
            }
            console.log("Write function response... success:" + response['success'])
            console.log("Write function response... message:" + response['message'])
            callback(response)
        });
    };

    <!-- API Read - Returns list [<list-of-columns>,<full-response-data>] -->
    $scope.api_read = function(param_list, callback) {
        console.log("**** Read Function Called ****");
        $scope.gen.errorEvent=null;
        $scope.gen.tableLoading=true;
        $http.get('/api/read', {
            params: param_list
        }).success(function(data){
            var columns = [];
            var response = data.result;
            try {
                columns = Object.keys(response[0]);
                console.log("Read success with keys: " + columns)
            } catch(err){
                console.error(err.message);
                $scope.gen.errorEvent='noData';
            }
            $scope.gen.tableLoading=false;
            callback([columns,response])
        });
    };

    <!-- API Write - Returns dict response from server keys: success,Message -->
    $scope.api_write = function(writeType, param_list, callback) {
        console.log("**** Write Function Called, method \"" + writeType + "\" ****" );
        $scope.gen.errorEvent=null;
        param_list["method"]=writeType
        $http.get('/api/write', {
            params: param_list
        }).success(function(data){
            var response = data.result;
            try {
                testVar = Object.keys(response);
            } catch(err){
                console.error(err.message);
                $scope.gen.errorEvent='noResponse';
            }
            console.log("Write function response... success:" + response['success'])
            console.log("Write function response... message:" + response['message'])
            callback(response)
        });
    };

    <!-- Load POP List (APIv2) -->
    $scope.popList = function() {
        console.log("**** POP Table Loading ****");
        $scope.gen.expandCounter=0
        $scope.gen.tableLoading=true;
        $scope.api_read2('site', function(result) {
            $scope.popData = result.site;
            console.log($scope.popData)
            $scope.gen.tableLoading=false;
        });
    };

    <!-- Load Rack List -->
    $scope.rackListOld = function() {
        console.log("**** Rack Table Loading ****");
        $scope.gen.expandCounter=0
        $scope.gen.paramString={};
        $scope.gen.paramString["item"] = "rack";
        $scope.gen.paramString["sel"] = "rackName,uCount,rackNotes,twitch_room,provider_room,providerRackName,rackStatus,locationCode,rackSecNotes,powerFeedA,powerFeedB,powerFeedC,powerFeedD,rackID,rackMakeInfo,rackSubnet,rackSequenceNo";
        $scope.api_read($scope.gen.paramString, function(result) {
            $scope.rackData = result[1]
        });
    };

    <!-- Load Device List (APIv2) -->
    $scope.deviceList = function() {
        console.log("**** Device Table Loading ****");
        $scope.gen.expandCounter=0
        $scope.gen.tableLoading=true;
        $scope.api_read2('device', function(result) {
            $scope.deviceData = result.Device;
            $scope.locationLegend = result.locationLegend;
            $scope.rackLegend = result.rackLegend;
            $scope.gen.tableLoading=false;
        });
    };

    <!-- Load Rack List (APIv2) -->
    $scope.rackList = function() {
        console.log("**** Rack Table Loading ****");
        $scope.gen.expandCounter=0
        $scope.gen.tableLoading=true;
        $scope.api_read2('rack', function(result) {
            $scope.rackData = result.rack;
            $scope.legendData = result.locationLegend;
            for (i=0; i < $scope.rackData.length;i++){
                tempID=$scope.rackData[i]['locationID']
                $scope.rackData[i]['locationCode']=$scope.legendData[tempID]
            }
            $scope.gen.tableLoading=false;
        });
    };

    <!-- Update Rack Element -->
    $scope.submitChangeRack = function(tempData) {
        console.log("**** Rack Cange Submit Initiated ****");
        $scope.gen.paramString={};
        $scope.gen.paramString["subject"]="rack";
        $scope.gen.paramString["updateValues"]=Object.keys(tempData).join(',');
        tempArray = Object.keys(tempData)
        arrayLength = tempArray.length;
        for (var i = 0; i < arrayLength; i++) {
            $scope.gen.paramString[tempArray[i]]=tempData[tempArray[i]];
        }
        $scope.api_write('update', $scope.gen.paramString, function(result) {
            if (result){
                if (result.sucess=true){
                    $scope.rackList();
                } else {
                    $scope.gen.errorEvent = 'noResponse';
                }
            } else {
                $scope.gen.errorEvent = 'noResponse';
            }
        });
    };

    <!-- Tools -->

    <!-- Tool: Add Pop Utility -->
    $scope.testAlert = function() {
        console.log("Test Alert Created");
    };
    $scope.createNewTemplatePOP = function() {
        console.log("**** Create New POP Function Called ****");
        var tempData = $.param({
            popCode : $scope.gen.popCode,
            popStatus : $scope.gen.popStatus,
            popVersion : $scope.gen.popVersion,
            popSubnet : $scope.gen.popSubnet,
            serverCount : $scope.gen.serverCount,
        });
        console.log(tempData)
        var config = {
            headers : {
                'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8;'
            }
        }
        $http.post('/tools/pop_add',tempData,config)
        .success(function (data, status, headers, config) {
            console.log(data)
        })
        .error(function (data, status, header, config) {
            console.err(data)
        });
    };

    <!-- Tool: Snapshot-->
    $scope.snapshotDict={};
    $scope.snapshotLoading=true;
    $scope.snapshotError=false;
    $scope.snapshotErrorMessage=null;
    $scope.getSNMPSnapshot = function(locationName) {
        console.log("**** SNMP Environmental Snapshot Called ****");
        $scope.gen.paramString={};
        $scope.gen.paramString["name"]=locationName;
        $http.get('/tools/popSnapshot', {
            params: $scope.gen.paramString
        }).error(function(data, status) {
        }).success(function(data){
            if (data.ERROR != null) {
                $scope.snapshotError = true;
                $scope.snapshotErrorMessage = data.message;
                console.error('Repos error', data);
            } else {
                $scope.snapshotDict = data.POPAverage;
                $scope.snapshotDict.primary.power*=.01;
                $scope.snapshotDict.primary.power=$scope.snapshotDict.primary.power.toFixed(2);
                $scope.snapshotDict.secondary.power*=.01;
                $scope.snapshotDict.secondary.power=$scope.snapshotDict.secondary.power.toFixed(2);
                $scope.snapshotDict.primary.tempreture*=.1;
                $scope.snapshotDict.primary.tempreture=$scope.snapshotDict.primary.tempreture.toFixed(1);
                $scope.snapshotDict.secondary.tempreture*=.1;
                $scope.snapshotDict.secondary.tempreture=$scope.snapshotDict.secondary.tempreture.toFixed(1);
                try {
                    Object.keys($scope.snapshotDict);
                } catch(err){
                    console.error(err.message);
                    $scope.hostLookupError = true;
                }
                $scope.snapshotLoading=false;
            };

        });
    };

    <!-- Tool: Load DNS Device List (APIv2) -->
    $scope.dnsSelectList=[];
    $scope.dnsSelectInfo={};
    $scope.dnsDeviceInfoDictList=[];
    $scope.dnsTempLegend={};
    $scope.dnsDeviceList = function() {
        console.log("**** Device DNS Table Loading ****");
        $scope.gen.expandCounter=0
        $scope.gen.tableLoading=true;
        $scope.api_read2('device', function(result) {
            $scope.deviceData = result.Device;
            $scope.locationLegend = result.locationLegend;
            $scope.rackLegend = result.rackLegend;
            $scope.typeLegend = result.typeLegend;
            for (var i = 0; i < $scope.deviceData.length; i++){
                dnsTempDict={};
                if(new RegExp("TS|CDU").test($scope.typeLegend[$scope.deviceData[i]['deviceTypeID']]['deviceRole'])) {
                    dnsTempDict['deviceName']=$scope.deviceData[i]['deviceName'];
                    dnsTempDict['deviceID']=$scope.deviceData[i]['deviceID'];
                    dnsTempDict['rackName']=$scope.rackLegend[$scope.deviceData[i]['rackID']]['rackName'];
                    dnsTempDict['locationCode']=$scope.locationLegend[$scope.rackLegend[$scope.deviceData[i]['rackID']]['locationID']];
                    
                    $scope.dnsTempLegend[dnsTempDict['deviceID']]=dnsTempDict['deviceName'];
                    
                    $scope.dnsDeviceInfoDictList.push(dnsTempDict);
                }
            }
            for (var i = 0; i < $scope.dnsSelectList.length; i++){

            }
            $scope.gen.tableLoading=false;

        });
    };
    $scope.toggleDNSSelection = function toggleDNSSelection(valueID,valueName) {
        currentlyListed = $scope.dnsSelectList.indexOf(valueID);
        if (currentlyListed > -1) {
            $scope.dnsSelectList.splice(currentlyListed,1);
            delete $scope.dnsSelectInfo[valueID]
        } else {
            $scope.dnsSelectList.push(valueID);
            $scope.dnsSelectInfo[valueID]=valueName;
        }
    }











    <!-- New Above -->
    <!-- Old Below -->












    <!--general variables-->
    $scope.display = {
        list: true,
        details: false,
        pops: false,
        addDevice: false,
        serverList: false,
        list_search: true,
        list_table: true,
        addDevice_device: true,
        addDevice_pops: false,
    }
    $scope.current = {
        columnSelectCheck: false,
        paramString: {},
        paramStringTemp: {},
        optLoc: 'location',
        optIp: 'ip',
        optName: 'name'
    }
    $scope.tableLoading = true;
    <!--end general variables-->





    <!--device page variables-->
    $scope.select = {
        column_available: [
            'name','mgmtIP','location','rack'
        ],
        column_result: ['name','mgmtIP'],
        filter_available: ['location','name','mgmtIP'],
        filter_result: ['location']
    };
    $scope.errorEvent=null;
    $scope.hostnameFocus = null;
    $scope.hostLookupError = false;
    $scope.sortType = 'name';
    $scope.sortReverse = false;
    $scope.searchDevice = '';
    $scope.colsDevice = [];
    <!--end device page variables-->

    <!--device page functions-->
    $scope.lookup = function() {
        console.log("list function run");
        $scope.display.list = true;
        $scope.display.details = false;
        $scope.display.pops = false;
        $scope.display.addDevice = false;
        $scope.display.serverList = false;
        $scope.current.paramString = {};
        if($scope.current.columnSelectCheck==false){
            $scope.current.paramString["item"] = "dcopsDevice";
        } else if ($scope.current.columnSelectCheck==true){
            $scope.current.paramString["item"] = "dcopsDevice";
            $scope.current.paramString["sel" ]= $scope.select.column_result.join(',');
        };
        $scope.errorEvent=null;
        $scope.tableLoading=true;
        $http.get('/api/read', {
            params: $scope.current.paramString
        }).success(function(data){
            $scope.colsDevice = [];
            $scope.list = data.result;
            try {
                $scope.colsDevice = Object.keys($scope.list[0]);
            } catch(err){
                console.log(err.message);
                $scope.errorEvent='noData';
            }
            $scope.select.column_result_delay = $scope.select.column_result;
            $scope.current.paramStringTemp=$scope.current.paramString
            $scope.current.paramString={};
            $scope.tableLoading=false;
        });
        $scope.notSorted = function(obj){
            if (!obj) {
                return [];
            }
            keys = [];
            key_temp=Object.keys(obj);
            for (column in $scope.select.column_available){
                if (key_temp.indexOf($scope.select.column_available[column]) != -1){
                    keys.push($scope.select.column_available[column]);
                }
            }
            keys.push("filler");
            return keys;
        }
        $scope.sameSort = function(key_temp){
            sortedArray = [];
            for (column in $scope.select.column_available){
               if (key_temp.indexOf($scope.select.column_available[column]) != -1){
                    sortedArray.push($scope.select.column_available[column]);
                }
            }
            return sortedArray;
        }
    };
    $scope.backFromDeviceDetails = function(){
        console.log("Back from device details page");
        $scope.display.list = true;
        $scope.display.pops = false;
        $scope.display.details = false;
        $scope.display.addDevice = false;
        $scope.display.serverList = false;
    };
    $scope.details = function(hostname_temp) {
        console.log("detail function run - " + hostname_temp);
        $scope.display.list = false;
        $scope.display.details = true;
        $scope.display.addDevice = false;
        $scope.display.serverList = false;
        $scope.hostLookupError = false;
        if (hostname_temp==null){
            $scope.hostLookupError = true;
        } else {
            $scope.hostnameFocus = hostname_temp;
        }
        $scope.detailResult = []
        $scope.current.paramString = {};
        $scope.current.paramString["item"] = "dcopsDevice";
        $scope.current.paramString['deviceName'] = $scope.hostnameFocus;
        $http.get('/api/read', {
            params: $scope.current.paramString
        }).success(function(data){
            $scope.detailResult = data.result;
            try {
                Object.keys($scope.detailResult[0]);
            } catch(err){
                console.log(err.message);
                $scope.hostLookupError = true;
            }
            $scope.select.column_result_delay = $scope.select.column_result;
            $scope.current.paramStringTemp=$scope.current.paramString
            $scope.current.paramString={};
        });
    };
    <!--end device page functions-->





    <!--pop page variables-->
    $scope.popSelect = {
        column_available: [
            'locationCode','codeVersion','hostingProvider','cageInformation','contactPhone','contactEmail',
            'amazonEntity','physicalAddress','notes'
        ],
        column_result: ['locationCode','cageInformation','physicalAddress'],
        confirmation: false,
    }
    $scope.popSortType = 'locationCode';
    $scope.popSortReverse = false;
    $scope.searchPOP = '';
    <!--end pop page variables-->

    <!--pop page functions-->
    $scope.popSetSort = function(tempValue) {
        $scope.popSortType = tempValue;
    }
    $scope.popReverseSort = function() {
        $scope.popSortReverse = !$scope.popSortReverse;
    }
    $scope.popsPage = function(){
        console.log("POP page function - Moved to POP page");
        $scope.display.list = false;
        $scope.display.pops = true;
        $scope.display.details = false;
        $scope.display.addDevice = false;
        $scope.display.serverList = false;
        $scope.current.paramString = {};
        $scope.current.paramString["item"] = "pop";
        $scope.popErrorEvent=null;
        $scope.tableLoading=true;
        $http.get('/api/read', {
            params: $scope.current.paramString
        }).success(function(data){
            $scope.popList = data.result;
            try {
                tempVar = Object.keys($scope.popList[0]);
            } catch(err){
                console.log(err.message);
                $scope.popErrorEvent='noData';
            }
            $scope.popSelect.column_result_delay = $scope.popSelect.column_result;
            $scope.current.paramStringTemp=$scope.current.paramString
            $scope.current.paramString={};
            $scope.tableLoading=false;
        });
        $scope.popNotSorted = function(obj){
            if (!obj) {
                return [];
            }
            keys = [];
            key_temp=Object.keys(obj);
            for (column in $scope.popSelect.column_available){
                if (key_temp.indexOf($scope.popSelect.column_available[column]) != -1){
                    keys.push($scope.popSelect.column_available[column]);
                }
            }
            keys.push("filler");
            return keys;
        }
        $scope.popSameSort = function(key_temp){
            sortedArray = [];
            for (column in $scope.popSelect.column_available){
               if (key_temp.indexOf($scope.popSelect.column_available[column]) != -1){
                    sortedArray.push($scope.popSelect.column_available[column]);
                }
            }
            return sortedArray;
        }
    };
    <!--end pop page functions-->





    <!--server page variables-->
    $scope.serverSortType = 'name';
    $scope.serverSortReverse = false;
    $scope.searchServer = ''
    <!--end server page variables-->

    <!--server page functions-->
    $scope.serverSetSort = function(tempValue) {
        $scope.serverSortType = tempValue;
    }
    $scope.serverReverseSort = function() {
        $scope.serverSortReverse = !$scope.serverSortReverse;
    }
    $scope.serverLookup = function() {
        console.log("list function run");
        $scope.display.list = false;
        $scope.display.details = false;
        $scope.display.pops = false;
        $scope.display.addDevice = false;
        $scope.display.serverList = true;
        $scope.serverErrorEvent=null;
        $scope.tableLoading=true;

        $scope.api_read2('systems/devices', function(result) {
            $scope.serverList = result.result;
            console.log($scope.serverList)
            $scope.tableLoading=false;
        });
    };
    <!--end server page functions-->
    <!--start test server page functions-->
    $scope.serverLookupBackup = function() {
        console.log("list function run");
        $scope.display.list = false;
        $scope.display.details = false;
        $scope.display.pops = false;
        $scope.display.addDevice = false;
        $scope.display.serverList = true;
        $scope.serverErrorEvent=null;
        $scope.tableLoading=true;
        $http.get('/api/read_server').success(function(data){
            $scope.serverList = data.result;
            try {
                tempVar = Object.keys($scope.serverList[0]);
            } catch(err){
                console.log(err.message);
                $scope.serverErorEvent='noData';
            }
            $scope.tableLoading=false;
        });
    };
    <!--end test server page functions-->





    <!--add item variables-->
    $scope.addDeviceData = {
        'name':null,'ip':null,'location':null,'rack':null,'position':null,'software_version':null,'notes':null,
        'AA1_outlet':null,'AA2_outlet':null,'AA3_outlet':null,'AA4_outlet':null,'AA5_outlet':null,
        'AA6_outlet':null,'AA7_outlet':null,'AA8_outlet':null,'AB1_outlet':null,'AB2_outlet':null,
        'AB3_outlet':null,'AB4_outlet':null,'AB5_outlet':null,'AB6_outlet':null,'AB7_outlet':null,
        'AB8_outlet':null,'AC1_outlet':null,'AC2_outlet':null,'AC3_outlet':null,'AC4_outlet':null,
        'AC5_outlet':null,'AC6_outlet':null,'AC7_outlet':null,'AC8_outlet':null
    }
    $scope.addPopData = {
        'locationCode': null, 'codeVersion': null, 'hostingProvider': null, 'cageInformation': null,
        'contactPhone': null, 'contactEmail': null, 'amazonEntity': null, 'physicalAddress': null,
        'notes': null
    }
    $scope.writeResponse = null;
    <!--end add item variables-->

    <!--add item functions-->
    $scope.showEmpty = function(temp_string){
        if (temp_string == null || temp_string == "" || temp_string == "None"){
            return true;
        } else {
            return false;
        }
    };
    $scope.deviceNameCheck = function(){
        if (
            $scope.addDeviceData['location'] != null &&
            $scope.addDeviceData['location'] != '' &&
            $scope.addDeviceData.rack != null &&
            $scope.addDeviceData.rack != '' &&
            $scope.addDeviceData.position != null &&
            $scope.addDeviceData.position != ''
        ){
            return true;
        } else {
            return false;
        }
    };
    $scope.addDevicePage = function(){
        console.log("Swap to addDevice page");
        $scope.display.list = false;
        $scope.display.pops = false;
        $scope.display.details = false;
        $scope.display.addDevice = true;
        $scope.display.serverList = false;
    };
    $scope.submitAdd = function(){
        console.log("Submitt function initiated...");
        if($scope.display.addDevice_pops){
            console.log("submitt for POP");
            $scope.current.paramString={};
            $scope.current.paramString=$scope.addPopData;
            $scope.current.paramString["writeType"] = "pop";
            console.log("param string: " + $scope.current.paramString);
            for (key in $scope.current.paramString){
                console.log(key);
            };
            $http.get('/api/write', {
                params: $scope.current.paramString
            }).success(function(data){
                $scope.writeResponse = data;
                console.log("api response: " + $scope.writeResponse);
                $scope.current.paramString={};
            });
        } else if($scope.display.addDevice_device){
            console.log("submitt for Device");
        };
    };
    <!--end add item functions-->




    <!--initiate device lookup page-->
    <!--disabled in favor of page specific solution-->
    <!--$scope.lookup();-->
    <!--end initiate device lookup page-->
});
