var app = angular.module('myApp', ['ngSanitize', 'ui.select']);

app.controller('dashController',function($scope,$http,$filter){
    <!--general variables-->
    $scope.display = {
        list: true,
        details: false,
        pops: false,
        addDevice: false,
        serverList: false,
        list_search: true,
        list_table: true,
        addDevice_device: true,
        addDevice_pops: false,
    }
    $scope.pattern = {
        'ip': '^10.(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){2}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$',
        'location': '^[a-z]{3}[0-9]{2}$',
        'rack': '^([0-9]{3}|[0-9]{2})$',
        'position': '^[a-d]$',
        'software_version': ''
    }
    $scope.current = {
        columnSelectCheck: false,
        paramString: {},
        paramStringTemp: {},
        optLoc: 'location',
        optIp: 'ip',
        optName: 'name'
    }
    <!--end general variables-->





    <!--device page variables-->
    $scope.select = {
        column_available: [
            'name','ip','location','rack','position','software_version','notes',
            'AA1_outlet','AA2_outlet','AA3_outlet','AA4_outlet','AA5_outlet',
            'AA6_outlet','AA7_outlet','AA8_outlet','AB1_outlet','AB2_outlet',
            'AB3_outlet','AB4_outlet','AB5_outlet','AB6_outlet','AB7_outlet',
            'AB8_outlet','AC1_outlet','AC2_outlet','AC3_outlet','AC4_outlet',
            'AC5_outlet','AC6_outlet','AC7_outlet','AC8_outlet'
        ],
        column_result: ['name','ip'],
        filter_available: ['location','name','ip'],
        filter_result: ['location']
    };
    $scope.errorEvent=null;
    $scope.hostnameFocus = null;
    $scope.hostLookupError = false;
    $scope.sortType = 'name';
    $scope.sortReverse = false;
    $scope.searchDevice = '';
    $scope.colsDevice = [];
    <!--end device page variables-->

    <!--device page functions-->
    $scope.setSort = function(tempValue) {
        $scope.sortType = tempValue;
    };
    $scope.reverseSort = function() {
        $scope.sortReverse = !$scope.sortReverse;
    };
    $scope.lookup = function() {
        console.log("list function run");
        $scope.display.list = true;
        $scope.display.details = false;
        $scope.display.pops = false;
        $scope.display.addDevice = false;
        $scope.display.serverList = false;
        $scope.current.paramString = {};
        if($scope.current.columnSelectCheck==false){
            $scope.current.paramString["item"] = "device";
        } else if ($scope.current.columnSelectCheck==true){
            $scope.current.paramString["item"] = "device";
            $scope.current.paramString["sel" ]= $scope.select.column_result.join(',');
        };
        $scope.errorEvent=null;
        $http.get('/api/read', {
            params: $scope.current.paramString
        }).success(function(data){
            $scope.colsDevice = [];
            $scope.list = data.result;
            try {
                $scope.colsDevice = Object.keys($scope.list[0]);
            } catch(err){
                console.log(err.message);
                $scope.errorEvent='noData';
            }
            $scope.select.column_result_delay = $scope.select.column_result;
            $scope.current.paramStringTemp=$scope.current.paramString
            $scope.current.paramString={};
        });
        $scope.notSorted = function(obj){
            if (!obj) {
                return [];
            }
            keys = [];
            key_temp=Object.keys(obj);
            for (column in $scope.select.column_available){
                if (key_temp.indexOf($scope.select.column_available[column]) != -1){
                    keys.push($scope.select.column_available[column]);
                }
            }
            keys.push("filler");
            return keys;
        }
        $scope.sameSort = function(key_temp){
            sortedArray = [];
            for (column in $scope.select.column_available){
               if (key_temp.indexOf($scope.select.column_available[column]) != -1){
                    sortedArray.push($scope.select.column_available[column]);
                }
            }
            return sortedArray;
        }
    };
    $scope.backFromDeviceDetails = function(){
        console.log("Back from device details page");
        $scope.display.list = true;
        $scope.display.pops = false;
        $scope.display.details = false;
        $scope.display.addDevice = false;
        $scope.display.serverList = false;
    };
    $scope.details = function(hostname_temp) {
        console.log("detail function run - " + hostname_temp);
        $scope.display.list = false;
        $scope.display.details = true;
        $scope.display.addDevice = false;
        $scope.display.serverList = false;
        $scope.hostLookupError = false;
        if (hostname_temp==null){
            $scope.hostLookupError = true;
        } else {
            $scope.hostnameFocus = hostname_temp;
        }
        $scope.detailResult = []
        $scope.current.paramString = {};
        $scope.current.paramString["item"] = "device";
        $scope.current.paramString['sel'] = "all";
        $scope.current.paramString['name'] = $scope.hostnameFocus;
        $http.get('/api/read', {
            params: $scope.current.paramString
        }).success(function(data){
            $scope.detailResult = data.result;
            try {
                Object.keys($scope.detailResult[0]);
            } catch(err){
                console.log(err.message);
                $scope.hostLookupError = true;
            }
            $scope.select.column_result_delay = $scope.select.column_result;
            $scope.current.paramStringTemp=$scope.current.paramString
            $scope.current.paramString={};
        });
    };
    <!--end device page functions-->





    <!--pop page variables-->
    $scope.popSelect = {
        column_available: [
            'locationCode','codeVersion','hostingProvider','cageInformation','contactPhone','contactEmail',
            'amazonEntity','physicalAddress','notes'
        ],
        column_result: ['locationCode','cageInformation','physicalAddress'],
        confirmation: false,
    }
    $scope.popSortType = 'locationCode';
    $scope.popSortReverse = false;
    $scope.searchPOP = '';
    <!--end pop page variables-->

    <!--pop page functions-->
    $scope.popSetSort = function(tempValue) {
        $scope.popSortType = tempValue;
    }
    $scope.popReverseSort = function() {
        $scope.popSortReverse = !$scope.popSortReverse;
    }
    $scope.popsPage = function(){
        console.log("POP page function - Moved to POP page");
        $scope.display.list = false;
        $scope.display.pops = true;
        $scope.display.details = false;
        $scope.display.addDevice = false;
        $scope.display.serverList = false;
        $scope.current.paramString = {};
        $scope.current.paramString["item"] = "pop";
        $scope.popErrorEvent=null;
        $http.get('/api/read', {
            params: $scope.current.paramString
        }).success(function(data){
            $scope.popList = data.result;
            try {
                tempVar = Object.keys($scope.popList[0]);
            } catch(err){
                console.log(err.message);
                $scope.popErrorEvent='noData';
            }
            $scope.popSelect.column_result_delay = $scope.popSelect.column_result;
            $scope.current.paramStringTemp=$scope.current.paramString
            $scope.current.paramString={};
        });
        $scope.popNotSorted = function(obj){
            if (!obj) {
                return [];
            }
            keys = [];
            key_temp=Object.keys(obj);
            for (column in $scope.popSelect.column_available){
                if (key_temp.indexOf($scope.popSelect.column_available[column]) != -1){
                    keys.push($scope.popSelect.column_available[column]);
                }
            }
            keys.push("filler");
            return keys;
        }
        $scope.popSameSort = function(key_temp){
            sortedArray = [];
            for (column in $scope.popSelect.column_available){
               if (key_temp.indexOf($scope.popSelect.column_available[column]) != -1){
                    sortedArray.push($scope.popSelect.column_available[column]);
                }
            }
            return sortedArray;
        }
    };
    <!--end pop page functions-->





    <!--server page variables-->
    $scope.serverSortType = 'name';
    $scope.serverSortReverse = false;
    $scope.searchServer = ''
    <!--end server page variables-->

    <!--server page functions-->
    $scope.serverSetSort = function(tempValue) {
        $scope.serverSortType = tempValue;
    }
    $scope.serverReverseSort = function() {
        $scope.serverSortReverse = !$scope.serverSortReverse;
    }
    $scope.serverLookup = function() {
        console.log("list function run");
        $scope.display.list = false;
        $scope.display.details = false;
        $scope.display.pops = false;
        $scope.display.addDevice = false;
        $scope.display.serverList = true;
        $scope.serverErrorEvent=null;
        $http.get('/api/read_server').success(function(data){
            $scope.serverList = data.result;
            try {
                tempVar = Object.keys($scope.serverList[0]);
            } catch(err){
                console.log(err.message);
                $scope.serverErorEvent='noData';
            }
        });
    };
    <!--end server page functions-->





    <!--add item variables-->
    $scope.addDeviceData = {
        'name':null,'ip':null,'location':null,'rack':null,'position':null,'software_version':null,'notes':null,
        'AA1_outlet':null,'AA2_outlet':null,'AA3_outlet':null,'AA4_outlet':null,'AA5_outlet':null,
        'AA6_outlet':null,'AA7_outlet':null,'AA8_outlet':null,'AB1_outlet':null,'AB2_outlet':null,
        'AB3_outlet':null,'AB4_outlet':null,'AB5_outlet':null,'AB6_outlet':null,'AB7_outlet':null,
        'AB8_outlet':null,'AC1_outlet':null,'AC2_outlet':null,'AC3_outlet':null,'AC4_outlet':null,
        'AC5_outlet':null,'AC6_outlet':null,'AC7_outlet':null,'AC8_outlet':null
    }
    $scope.addPopData = {
        'locationCode': null, 'codeVersion': null, 'hostingProvider': null, 'cageInformation': null,
        'contactPhone': null, 'contactEmail': null, 'amazonEntity': null, 'physicalAddress': null,
        'notes': null
    }
    $scope.writeResponse = null;
    <!--end add item variables-->

    <!--add item functions-->
    $scope.showEmpty = function(temp_string){
        if (temp_string == null || temp_string == ""){
            return true;
        } else {
            return false;
        }
    };
    $scope.deviceNameCheck = function(){
        if (
            $scope.addDeviceData['location'] != null &&
            $scope.addDeviceData['location'] != '' &&
            $scope.addDeviceData.rack != null &&
            $scope.addDeviceData.rack != '' &&
            $scope.addDeviceData.position != null &&
            $scope.addDeviceData.position != ''
        ){
            return true;
        } else {
            return false;
        }
    };
    $scope.addDevicePage = function(){
        console.log("Swap to addDevice page");
        $scope.display.list = false;
        $scope.display.pops = false;
        $scope.display.details = false;
        $scope.display.addDevice = true;
        $scope.display.serverList = false;
    };
    $scope.submitAdd = function(){
        console.log("Submitt function initiated...");
        if($scope.display.addDevice_pops){
            console.log("submitt for POP");
            $scope.current.paramString={};
            $scope.current.paramString=$scope.addPopData;
            $scope.current.paramString["writeType"] = "pop";
            console.log("param string: " + $scope.current.paramString);
            for (key in $scope.current.paramString){
                console.log(key);
            };
            $http.get('/api/write', {
                params: $scope.current.paramString
            }).success(function(data){
                $scope.writeResponse = data;
                console.log("api response: " + $scope.writeResponse);
                $scope.current.paramString={};
            });
        } else if($scope.display.addDevice_device){
            console.log("submitt for Device");
        };
    };
    <!--end add item functions-->




    <!--initiate device lookup page-->
    <!--disabled in favor of page specific solution-->
    <!--$scope.lookup();-->
    <!--end initiate device lookup page-->
});
